/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.IURLConnectionListener;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Enumeration;

public class WebConversation
extends WebClient {
    static {
        HttpURLConnection.setFollowRedirects(false);
    }

    protected WebResponse newResponse(WebRequest request, IURLConnectionListener listener) throws MalformedURLException, IOException {
        URLConnection connection = this.openConnection(request.getURL(), listener);
        this.sendHeaders(connection, request.getHeaderDictionary());
        if (HttpUnitOptions.isLoggingHttpHeaders()) {
            Enumeration e = this.getHeaderFields().keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.out.println("Sending:: " + key + ": " + connection.getRequestProperty(key));
            }
        }
        request.completeRequest(connection);
        return new HttpWebResponse(request.getTarget(), request.getURL(), connection, this.getExceptionsThrownOnErrorStatus());
    }

    private URLConnection openConnection(URL url, IURLConnectionListener listener) throws MalformedURLException, IOException {
        URLConnection connection = url.openConnection();
        if (listener != null) {
            listener.connectionOpened(connection);
        }
        connection.setUseCaches(false);
        this.sendHeaders(connection);
        return connection;
    }

    private void sendHeaders(URLConnection connection) {
        this.sendHeaders(connection, this.getHeaderFields());
    }

    private void sendHeaders(URLConnection connection, Dictionary headers) {
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            connection.setRequestProperty(key, (String)headers.get(key));
        }
    }
}

