/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <baygui.h>
#include "gshortcut.h"

#if 0
/** モナーアイコン（パレット） */
static unsigned int monaIconPalette [4] = {
	0xffc0c0c0,
	0xfffefefe,
	0xff000000,
	0xfffc6604,
};

/** モナーアイコン（データ） */
static char monaIconData [15][16] = {
	{0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x2,0x1,0x1,0x1,0x2,0x2,0x2,0x1,0x1,0x1,0x2,0x0,0x0,0x0},
	{0x0,0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x2,0x0},
	{0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x2},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x3,0x2,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x0,0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0,0x0},
	{0x0,0x0,0x0,0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x0},
};
#endif

/** ディスクアイコン（パレット）*/
static unsigned int diskIconPalette [16] = {
	0xff040204,
	0xff04be04,
	0xff3c4644,
	0xff8c8e8c,
	0xffcccecc,
	0xffdc0604,
	0xff6c7674,
	0xffacaeac,
	0xffeceeec,
	0xff4c5654,
	0xffdcdedc,
	0xffbcbebc,
	0x00fc0204,
	0xff040604,
	0xff161300,
	0xff000000,
};

/** ディスクアイコン（データ）*/
static unsigned char diskIconData [32][32] = {
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc},
	{0xc,0x0,0x8,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0xb,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0xa,0x8,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0x7,0xb,0xb,0x3,0x0,0xc,0xc,0xc},
	{0x0,0xb,0x7,0x3,0x7,0x3,0x7,0x3,0x7,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x4,0x8,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x8,0xa,0xa,0x4,0xa,0xa,0xb,0x4,0x4,0xb,0x4,0x4,0xb,0x4,0xb,0x7,0xb,0xb,0x7,0xb,0xb,0x7,0xb,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x1,0x1,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x5,0x5,0xa,0xa,0xa,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0x2,0xc},
	{0xd,0x8,0x8,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0x2,0x2},
	{0x0,0x7,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x9,0x0,0x2,0x2,0x2},
	{0x0,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0x2,0x2,0x2,0xc},
};

/** 端末アイコン（パレット）*/
static unsigned int terminalIconPalette [16] = {
	0xff040604,
	0xff8c8e8c,
	0xff6466cc,
	0xffdbdddb,
	0xff444644,
	0x00fc0204,
	0xff049efc,
	0xff040654,
	0xfff4f6f4,
	0xffbbbdbb,
	0xff9c9efc,
	0xff242624,
	0xff545654,
	0xffcccefc,
	0xff343664,
	0xff141614,
};

/** 端末アイコン（データ）*/
static unsigned char terminalIconData [32][32] = {
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xb,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xf,0x1,0x9,0x1,0x4,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xb,0x1,0x9,0x8,0x8,0x8,0x3,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xf,0x1,0x9,0x3,0x8,0x8,0x3,0x3,0x3,0x3,0x3,0x1,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x1,0x4,0x9,0x3,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0xd,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x9,0x9,0x1,0x0,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0xd,0x3,0x3,0x3,0x3,0x9,0x9,0x1,0x0,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x9,0x9,0x1,0x0,0xf,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x6,0xa,0xe,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x1,0xc,0x0,0xb,0xc,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0xa,0xa,0x6,0xe,0x0,0x4,0x9,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0xa,0x6,0xa,0xa,0xa,0xe,0x0,0x4,0x9,0x9,0x1,0x4,0xc,0xc,0xc,0xe,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0x6,0xa,0xa,0xa,0x6,0xa,0xa,0x0,0x0,0x9,0x1,0xe,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x6,0xa,0xa,0xa,0x6,0xa,0xa,0xa,0x6,0x0,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x0,0x0,0xa,0xa,0xa,0x6,0xa,0xa,0xa,0x6,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0xa,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0xa,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x2,0x0,0xd,0xd,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x6,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x0,0xd,0xd,0xd,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0xa,0x0,0x9,0x1,0x4,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x4,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0xe,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x0,0x0,0x9,0x1,0xc,0x4,0x4,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x4,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x0,0x0,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x4,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0xb,0x4,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x0,0x1,0x9,0x1,0x4,0xc,0xc,0xc,0x4,0xb,0x0,0xb,0xb,0xb},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x2,0x2,0x0,0xd,0xd,0x0,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0xf,0xb,0xb},
	{0x0,0x2,0x2,0x2,0x2,0x7,0x7,0x7,0x0,0x0,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0x0,0x0,0xb,0xb,0x4},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0x4,0x4,0xb,0x0,0x0,0xb,0xb,0x4,0x4},
	{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0x4,0xb,0x0,0x0,0xb,0xb,0x4,0x4,0x5,0x5},
	{0x5,0x5,0xe,0xe,0xe,0xe,0xe,0xe,0xe,0x0,0xe,0xe,0xe,0xe,0xe,0xe,0xe,0xb,0x4,0x1,0x9,0x4,0x0,0x0,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x2,0x2,0x2,0xb,0x0,0xb,0xb,0xb,0x0,0x0,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0xf,0xb,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0xf,0xf,0xf,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
};

/** ゴミ箱アイコン（パレット）*/
static unsigned int trashboxIconPalette [16] = {
	0xff040604,
	0xff7c7e7c,
	0xff3c3e3c,
	0xffbcbebc,
	0x00fc0204,
	0xffb4b6b4,
	0xff6c6e6c,
	0xffe4e6e4,
	0xff242624,
	0xff545654,
	0xff8c968c,
	0xfff4f6f4,
	0xffd00082,
	0xff400000,
	0xff161300,
	0xff000000,
};

/** ゴミ箱アイコン（データ）*/
static unsigned char trashboxIconData [32][32] = {
	{0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x4,0x8,0x7,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x7,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x8,0x7,0x7,0x7,0x0,0x8,0x8,0x8,0x8,0x8,0xb,0xb,0xb,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0xb,0xb,0xb,0xb,0xb,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x0,0x7,0x8,0xb,0x7,0x7,0x7,0x7,0x7,0x8,0xb,0xb,0x7,0x8,0xb,0x3,0x3,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x0,0x3,0x7,0x8,0x7,0xb,0x7,0x7,0x7,0x8,0xb,0xb,0xb,0x8,0x7,0x8,0x5,0x5,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x0,0x5,0x3,0x8,0xb,0x7,0x7,0x7,0x8,0xb,0xb,0xb,0x8,0x7,0x7,0x7,0x8,0x2,0x6,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x1,0x0,0x3,0x8,0x7,0x7,0x7,0x8,0xb,0xb,0x7,0x8,0x7,0x7,0x5,0x3,0x2,0x2,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xb,0xa,0x0,0x0,0x0,0x7,0x8,0xb,0x7,0x7,0x8,0x3,0x5,0x6,0x2,0x2,0x6,0xa,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xa,0x7,0xb,0x1,0x9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0xa,0xa,0xa,0x9,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xa,0x7,0x7,0xb,0xb,0x5,0x5,0x5,0x3,0x3,0x3,0x5,0x5,0xa,0xa,0x6,0x6,0x9,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x8,0x2,0x7,0x7,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0x1,0xa,0x1,0x6,0x8,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x1,0x9,0x6,0x3,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0xa,0x1,0x8,0x2,0x7,0x7,0x1,0x5,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x5,0x5,0x1,0xa,0x6,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x9,0x7,0x7,0x1,0x7,0x7,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x5,0x5,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0xa,0x0,0x7,0x7,0x5,0x7,0xb,0xb,0x7,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x7,0x1,0x7,0x7,0x5,0x5,0x0,0x3,0x7,0x7,0x5,0xb,0xb,0xb,0xb,0x7,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0xb,0x7,0x5,0xb,0xb,0x7,0xb,0x7,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0xb,0x3,0x7,0xb,0xb,0xb,0xb,0xb,0x7,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0x7,0x5,0xb,0xb,0xb,0xb,0xb,0x2,0x2,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0x7,0x5,0x7,0x7,0xb,0xb,0x7,0x8,0x5,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x6,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0x5,0x7,0x7,0x7,0xb,0x3,0x2,0x0,0x8,0xa,0x0,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0xa,0x7,0x7,0x7,0xb,0x5,0x5,0x0,0x2,0xb,0x0,0x8,0x8,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0xa,0x3,0x7,0xa,0x2,0x2,0x2,0x8,0xb,0x0,0x8,0x8,0x8,0x8,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0xa,0xa,0x1,0x3,0x3,0xa,0x0,0xa,0xa,0x2,0xb,0x0,0x8,0x8,0x8,0x8,0x8,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0xb,0x6,0x5,0x5,0x7,0x5,0x9,0x0,0xa,0xa,0x1,0x5,0x5,0x1,0x2,0x0,0xa,0xa,0x0,0x8,0x8,0x8,0x8,0x0,0x8,0x8},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x2,0x1,0x9,0xa,0x5,0x1,0x2,0x8,0x0,0x0,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8},
	{0x4,0x0,0x5,0x5,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x3,0x9,0x9,0x8,0x9,0x9,0x9,0x5,0x1,0x6,0x2,0x2,0x2,0x0,0x8,0x0,0x8,0x8,0x8,0x8,0x8},
	{0x4,0x0,0x5,0x5,0x7,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x1,0x0,0x9,0x2,0x9,0x1,0xa,0xa,0x2,0x2,0x2,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x4},
	{0x4,0x8,0x1,0x7,0x7,0xb,0xb,0x7,0x6,0x7,0x7,0x5,0x5,0x9,0x0,0x2,0x9,0x9,0xa,0x5,0x5,0xa,0x2,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x4,0x4},
	{0x4,0x4,0x8,0x0,0x5,0xb,0xb,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0x8,0x9,0x9,0x2,0xa,0xa,0xa,0x2,0x0,0x8,0x8,0x8,0x8,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x0,0x0,0x0,0x5,0x5,0x3,0x3,0x5,0x5,0x1,0x0,0x0,0x2,0x2,0x2,0x9,0x1,0x9,0x0,0x8,0x8,0x8,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
};

/** コンストラクタ */
ShortCut::ShortCut()
{
}

/** デストラクタ */
ShortCut::~ShortCut()
{
}

/** タイトルを設定する */
void ShortCut::setTitle(const String& title)
{
	this->title = title;
}

/**
 アイコンタイプを設定する
 @param type アイコンタイプ
 */
void ShortCut::setType(int type)
{
	this->type = type;
	if (this->type == DISKICON) {
		setBounds(720, 22, 64, 64);
		setTitle("Mona HD");
	} else if (this->type == TERMINALICON) {
		setBounds(720, 86, 64, 64);
		setTitle("た～みなる");
	} else if (this->type == TRASHBOXICON) {
		setBounds(720, 510, 64, 64);
		setTitle("ゴミ箱");
	}
}

/** ウィンドウ生成時に呼ばれる */
void ShortCut::addNotify() {
	Window::addNotify();
#if defined(MONA)
	this->_window->Flags |= WINDOWFLAGS_BOTTOMMOST | WINDOWFLAGS_NOBORDER;
#endif
}

/** 再描画 */
void ShortCut::paint(Graphics* g) {
	int w = getWidth();
	int h = getHeight();

	// 透明にする
	g->setColor(0x00ffffff);
	g->fillRect(0,0,w,h);

	for (int i = 0; i < 32; i++) {
		for (int j = 0; j < 32; j++) {
			// ディスクアイコン
			if (this->type == DISKICON) {
				g->drawPixel(16 + j, i, diskIconPalette[(int)(diskIconData[i][j])]);
			// 端末アイコン
			} else if (this->type == TERMINALICON) {
				g->drawPixel(16 + j, i, terminalIconPalette[(int)(terminalIconData[i][j])]);
			// ゴミ箱アイコン
			} else if (this->type == TRASHBOXICON) {
				g->drawPixel(16 + j, i, trashboxIconPalette[(int)(trashboxIconData[i][j])]);
			}
		}
	}

	// タイトル
	int fw = getFontMetrics()->getWidth(this->title.getBytes());
	//int fh = this->_metrics->getHeight(getTitle());
	g->setColor(Color::white);
	g->fillRect((w - fw)/2 - 4, 36, fw + 8, 12);
	g->setColor(Color::black);
	g->drawString(this->title.getBytes(), (w - fw)/2, 36);
}

/** イベントハンドラ */
void ShortCut::processEvent(Event* event) {
#if defined(MONA)
	int w = getWidth();
	int h = getHeight();

	if (event->getType() == MouseEvent::MOUSE_RELEASED) {
		// 視覚効果
		if (this->type == DISKICON || this->type == TERMINALICON) {
			MonAPI::Message::sendReceive(NULL, this->guisvrID, MSG_GUISERVER_EXPANSIONEFFECT,
				MAKE_DWORD(getX() + w/2, getY() + h/2),
				MAKE_DWORD(getX(), getY()),
				MAKE_DWORD(64, 64)
			);
		}
		// アプリケーション実行
		if (this->type == DISKICON) {
			monapi_call_process_execute_file("/APPS/BAYGUI/GLAUNCH.EX5 FILE", MONAPI_FALSE);
		} else if (this->type == TERMINALICON) {
			monapi_call_process_execute_file("/APPS/BAYGUI/GSHELL.EX5", MONAPI_FALSE);
		}
	}
#endif
}
