/*!
    \file  NE2000.h
    \brief NE2000hCoNX wb_

    Copyright (c) 2004 Yamami, Higepon
    All rights reserved.
    License=MIT/X License

    \author  Yamami Higepon
    \version $Revision: 1.1 $
    \date   create:2004/08/08 update:$Date: 2005/12/11 10:01:50 $
*/
#ifndef _MONA_MONES_NE2000_
#define _MONA_MONES_NE2000_

#include <sys/types.h>
#include <monapi.h>
#include "Nic.h"

// don't include NE2000const.h at here.

namespace mones {

class NE2000 : public Nic
{
public:
    NE2000();
    virtual ~NE2000();

    int init();
    int probe();
    void inputFrame();
    void outputFrame(byte* packet, byte* macAddress, dword size, word protocolId);

    virtual dword getFrameBufferSize();
    virtual void getFrameBuffer(byte* buffer, dword size);
    void getMacAddress(byte* dest);
    byte getIRQ() const {return this->nicIRQ;}
    int getIOBase() const {return this->nicIo_Base;}
    void setIRQ(byte irq) {this->nicIRQ = irq;}
    void setIOBase(int iobase) {this->nicIo_Base = iobase;}

private:
    int nicIRQ;
    int nicIo_Base;

    void nic_init(void);
    void ne_pio_writemem( byte *, dword, dword );
    void ne_pio_readmem( dword, byte *, dword );
    int ne_bcompare( byte *, byte *, dword );
    void xfer_buf( byte *, byte *, dword, dword *, dword, dword,dword );

    //privateo
    /* MOobt@̃N̈ǂݍނƂ */
    /* ne_ring_buffer */
    byte       ne_ringbuf_status;
    byte       ne_ringbuf_bound;
    dword        ne_ringbuf_len;

    dword        ne_rx_start;      /* MpPbg{̂̊JnAhX */

    byte       ne_rx_bound;      /* M̋EWX^l */
    dword        ne_rx_write_p;    /* MpPbg݃AhX */
    dword        ne_rx_sub_len;    /* ܂Ԃ̒ */
    dword        ne_rx_remain_len; /* c̒(܂ԂȂƂ͖{̂̒Ɠ) */
    /*! \brief MpPbg{̂̒ */ 
    dword    frame_len;
    byte   frame_buf[1500];
    byte   ether_mac_addr[6];
    /* NE2000 [NGA */
    int        ne_sizeof_test_pattern;
    byte       ne_test_buffer[20];
};

}; // namespace mones
#endif
