/*!
    \file   Ne2000MoNic.cpp
    \brief  Ne2000hCoNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/07/28 update:$Date: 2005/12/13 09:00:45 $
*/

/*! \class Ne2000MoNic
 *  \brief Ne2000hCoNX
 */



#include "Ne2000MoNic.h"


/*!
    \brief initialize
         Ne2000MoNic RXgN^
    \author Yamami
    \date   create:2004/08/08 update:
*/
Ne2000MoNic::Ne2000MoNic()
{

}


/*!
    \brief initialize
         Ne2000MoNic init
    \author Yamami
    \return int  0: A 0ȊO:ُ
    \date   create:2004/08/12 update:
*/
int Ne2000MoNic::init() 
{

    int reti;
    

    //vCx[go
    ne_ringbuf_status=0;
    ne_ringbuf_bound=0;
    ne_ringbuf_len=0;

    ne_rx_start=0;      /* MpPbg{̂̊JnAhX */
    frame_len=0;        /* MpPbg{̂̒ */
    ne_rx_bound=0;      /* M̋EWX^l */
    ne_rx_write_p=0;    /* MpPbg݃AhX */
    ne_rx_sub_len=0;    /* ܂Ԃ̒ */
    ne_rx_remain_len=0; /* c̒(܂ԂȂƂ͖{̂̒Ɠ) */
    
    ne_sizeof_test_pattern=20;

    //Ne2000 ݊mF
    reti = nic_probe();
    if(reti != 0 ){
        printf("Does Not Exist Ne2K!!!\n");
        return -1;
    }

    //MACAhX\Ă݂
    //int i;
    //printf("MAC ADR:");
    //for(i=0 ;i < 6 ; i++){
    //    printf("%x ",ether_mac_addr[i]);
    //}
    //printf("\n");

    //Ne2000 
    nic_init();

    return 0;
}


/*!
    \brief frame_input
        NE2000 f[^̓[`
        {́ANE2000̊荞݂ɂăR[B
        eXgvOł́AIMonaMain ŃR[B
    \param  void
    \return void

    \author Yamami
    \date   create:2004/08/03 update:$Date: 2005/12/13 09:00:45 $
*/
void Ne2000MoNic::frame_input(void)
{

    byte sts,*buf;
    //oE_WX^ ƁAJgy[WWX^8rbg
    //f[^ɃANZXہA8rbgVtg16rbgANZXs
    word  bnd,cpg;

    buf=frame_buf;

    // Page 0
    outp8( NE_P0_COMMAND, NE_CR_STA );
    // sts <- MXe[^XWX^(Receive Status Reg)
    sts=inp8( NE_P0_RSR );

//Yamami fobO
//printf("sts : %x\n",sts);

    if( ( sts & NE_RSTAT_OVER ) !=0 ){
        printf("FIFO OverFlow\n");
        return; // MFIFOI[o[t[
    }

    if( ( inp8( NE_P0_ISR ) & NE_ISR_OVW ) !=0 ){
        printf("RING OverFlow\n");
        return; // MOobt@I[o[t[
    }

    //  M
    if( ( sts & NE_RSTAT_PRX ) ==0 ){
        printf("Not Exist Packet \n");
        return; //  MpPbgȂ
    }

    //y[W𖾎Iɐ؂ւ bnd  cpg ǂ
    outp8(NE_P0_COMMAND, NE_CR_PS0 | NE_CR_STA); /* Page 0 */
    bnd=inp8( NE_P0_BNRY ) + 1;      // bnd <-bnd  
    //bnd=inp8( NE_P0_BNRY );      // bnd <-bnd +1Ȃ
    outp8(NE_P1_COMMAND, NE_CR_PS1 | NE_CR_STA); /* Page 1 */
    cpg=inp8( NE_P1_CURR );          // cpg <- Current Page
    
    //Page0ɖ߂Ă
    outp8( NE_P0_COMMAND, NE_CR_PS0 );


//Yamami fobO
//printf("bnd : %x\n",bnd);
//printf("cpg : %x\n",cpg);


    if( bnd == NE_RX_PAGE_STOP ){
        // if last page then set to start page
        bnd=NE_RX_PAGE_START;
    }
    if( cpg == NE_RX_PAGE_STOP ){
        /* if last page then set to start page */
        cpg=NE_RX_PAGE_START; 
    }
    if( cpg == bnd ){        // Current Page = bound ?
        //printf("Not Exist Packet buffer \n");
        return;         // = Ȃ obt@ɃpPbgȂ
    }

    
    // bound+1 y[W̐擪4oCgǂݍ
    // Yamami ƁAAϐ錾AA4oCgł鎖ɗĂHH
    // obt@ɈU[hāA鏈ɕύX
    //ne_pio_readmem( bnd << 8, &ne_ringbuf_status, 4 );

    byte bndBuf[4];
    ne_pio_readmem( bnd << 8, bndBuf, 4 );

// YamamifobO [hAhX̕\
//printf("Read Src = bnd << 8 : %x\n",bnd << 8);

    ne_ringbuf_status = bndBuf[0]; /* Receive Status */
    ne_ringbuf_bound = bndBuf[1] & 0xFF; /* Next Packet Pointer */
    ne_ringbuf_len = bndBuf[3] * 256 + bndBuf[2];   /* Receive Byte Count */

    //ꂪAꂼt̂悤ȋCBGfBÄႢHH
    //  ̎́ARead/WriteύX
    //ne_ringbuf_status = bndBuf[1]; /* Receive Status */
    //ne_ringbuf_bound = bndBuf[0] & 0xFF; /* Next Packet Pointer */
    //ne_ringbuf_len = bndBuf[2] * 256 + bndBuf[3];   /* Receive Byte Count */

// YamamifobO
//printf("ne_ringbuf_status : %x\n",ne_ringbuf_status);
//printf("ne_ringbuf_bound  : %x\n",ne_ringbuf_bound);
//printf("ne_ringbuf_len : %x\n",ne_ringbuf_len);

    ne_rx_start=(bnd << 8) + 4; // pPbg{̂̊JnAhX

    // CRC̒̕
    // CRC̒̕ ? CRCȂne_ringbuf_*4 byte?
    frame_len=ne_ringbuf_len - 4; /* pPbg{̂̒ */

    // MI̋EWX^l
    ne_rx_bound=ne_ringbuf_bound;

    if( ( ne_ringbuf_status & NE_RSTAT_PRX ) !=0 ){
                    // MI
        if( frame_len >= ETHER_HEADER_SIZE ){
                    // ŒZZƂ̓G[
            if( frame_len < ETHER_MAX_PACKET ) {
                    // ő咷蒷Ƃ̓G[

                ne_rx_remain_len=frame_len;

                // pPbg̎荞ݏ
                // ܂Ԃ̒
                ne_rx_sub_len=NE_RX_PAGE_STOP * 256 - ne_rx_start;

// YamamifobO
//printf("frame_input 03 ne_rx_start=%x\n",ne_rx_start);
//printf("frame_input 04 ne_rx_sub_len=%x\n",ne_rx_sub_len);

                if( ne_rx_sub_len < frame_len ){
                    // MׂpPbg͐܂ԂĂ
                    // O̓ǂݍ
                    ne_pio_readmem( ne_rx_start, buf, ne_rx_sub_len );
                    ne_rx_start=NE_RX_PAGE_START * 256;

                    // ݃AhX̍XV
                    buf+=ne_rx_sub_len;
                    // c̓ǂݍݒ̍XV
                    ne_rx_remain_len=frame_len - ne_rx_sub_len;
                }
                // pPbg̓ǂݍ
                ne_pio_readmem( ne_rx_start, buf, ne_rx_remain_len );
                
            }
            else{
                //printf("Error frame_len >= ETHER_MAX_PACKET \n");
            }
        }
        else{
            //printf("Error frame_len >= ETHER_HEADER_SIZE \n");
        }
    }
    else{
        //printf("Error ne_ringbuf_status & NE_RSTAT_PRX = 0 \n");
    }

    // Yamami oE_WX^ ̍XV
    bnd=ne_rx_bound; 
    if( bnd == NE_RX_PAGE_START ){
        bnd=NE_RX_PAGE_STOP;
    }
    bnd--;
    outp8( NE_P0_BNRY, bnd );    // EWX^ = ̃obt@ - 1

    //  荞݃Xe[^XWX^NA
    outp8( NE_P0_ISR, 0xff );
    
    //H8 
    outp8(NE_P0_IMR, NE_IMR_PRXE); /* Packet Receive interrupt enable */

}



/*!
    \brief frame_output
        NE2000 f[^o̓[`
    \param  byte *pkt [in] f[^pPbgւ̃|C^
    \param  byte *mac [in] MACAhXւ̃|C^
    \param  dword size [in] pPbgTCY
    \param  word pid [in] vgRID(ETHER_PROTO)
    \return void

    \author Yamami
    \date   create:2004/08/03 update:$Date: 2005/12/13 09:00:45 $
*/
void Ne2000MoNic::frame_output( byte *pkt, byte *mac, dword size, word pid )
{
    
    dword        ptx_type=0;
    dword        ptx_size=0;
    byte       *ptx_packet=0;
    byte       *ptx_dest=0;
    
    
    // MĂ邩ǂ`FbN
    while( ( inp8( NE_P0_COMMAND ) & 0x04 ) !=0 );

//Yamami fobO
//printf("frame_output 01\n");
    
    ptx_dest=mac;
    ptx_size=size;
    ptx_packet=pkt;
    // lbg[NoCgI[_[ɕϊ
    // Yamami ϊsvH
    ptx_type=(pid >> 8)+(pid << 8);

//Yamami fobO
//int i;
//for(i=0 ; i<2 ; i++){
//    printf("ptx[1] = %x \n",(byte *)(&ptx_type + 1));
//}


    // 荞݋֎~
    // MɎMƃWX^Ă܂
    //disableInterrupt();
    disableNetWork();

    // AhX̏
    ne_pio_writemem( ptx_dest, NE_TX_PAGE_START << 8, 6 );
    // MAhX̏
    ne_pio_writemem( ether_mac_addr, ( NE_TX_PAGE_START << 8 ) + 6, 6 );
    // vgRID̏
    ne_pio_writemem( (byte *)&ptx_type, ( NE_TX_PAGE_START << 8 ) + 12, 2 );
    // f[^̏
    ne_pio_writemem( ptx_packet, ( NE_TX_PAGE_START << 8 ) + 14, ptx_size );

    ptx_size+=ETHER_HEADER_SIZE;

    // ŏpPbgZǂ`FbN
    if( ptx_size < ETHER_MIN_PACKET ){
        ptx_size=ETHER_MIN_PACKET;
    }

    outp8( NE_P0_COMMAND, NE_CR_PS0 + NE_CR_RD2 + NE_CR_STA );
    
    // Mobt@̈̎w
    outp8( NE_P0_TPSR, NE_TX_PAGE_START );
    
    // M̎w
    outp8( NE_P0_TBCR0, ptx_size & 0xff);
    outp8( NE_P0_TBCR1, ptx_size >> 8 );

    // M߂𔭍s
    outp8( NE_P0_COMMAND, NE_CR_PS0 + NE_CR_TXP + NE_CR_RD2 + NE_CR_STA );

    // 荞݋
    //enableInterrupt();
    enableNetWork();

//Yamami fobO
//printf("frame_output 02\n");

    // MĂ邩ǂ`FbN
    // 2004/11/16 Yamami QEMU on Ne2000 Ƃ̃`FbNiɒʂȂ悤Ȃ̂Ń`FbNȂ
    //while( ( inp8( NE_P0_COMMAND ) & 0x04 ) !=0 );

//Yamami fobO
//printf("frame_output 03\n");

}


/*!
    \brief nic_probe
        NE2000[`
        obt@ɏ݂Ɠǂݍ݂sANE2000݂邱ƂmF
    \param  void
    \return void

    \author Yamami
    \date   create:2004/08/01 update:$Date: 2005/12/13 09:00:45 $
*/
int Ne2000MoNic::nic_probe(void)
{
    int i;

    /* \tgEFAZbg */
    //outp8( NE_ASIC_RESET, inp8( NE_ASIC_RESET ) ); 
    /* Zbg܂ő҂ */
    //ne_wait_func(0);

    /* DMA ~B */
    outp8( NE_P0_COMMAND, NE_CR_RD2 + NE_CR_STP );

    /* ~鍠܂ő҂ */
    //ne_wait_func(0);

    //  pPbgɏȂ悤ɂ
    outp8( NE_P0_RCR, NE_RCR_MON );

    // [h]A[vobN[h
    outp8( NE_P0_DCR, NE_DCR_WTS + NE_DCR_FT1 + NE_DCR_LS );

    // Mobt@JnAhX
    // 64
    outp8( NE_P0_PSTART, NE_MEM_START );

    // Mobt@IAhX
    // 128
    outp8( NE_P0_PSTOP, NE_MEM_END );

    // eXgp^[
    ne_pio_writemem( (byte *)ne_test_pattern, NE_MEM_START * NE_PAGE_SIZE, ne_sizeof_test_pattern );
    // eXgp^[ǂݍ
    ne_pio_readmem( NE_MEM_START * NE_PAGE_SIZE, ne_test_buffer, ne_sizeof_test_pattern );
    // eXgp^[̔r
    if( ne_bcompare( (byte *)ne_test_pattern, ne_test_buffer, ne_sizeof_test_pattern )!=0 )
        return(1);  // svȂI

    // EEPROM f[^ǂ݂
    ne_pio_readmem( 0, ne_test_buffer, 16 );

    // C[TlbgAhX擾
    for(i=0;i<11;i+=2)
        ether_mac_addr[i/2]=ne_test_buffer[i];

    // 荞݃Xe[^XWX^NA
    outp8( NE_P0_ISR, 0xff );

    return(0);
}


/*!
    \brief nic_init
        NE2000[`
    \param  void
    \return void

    \author Yamami
    \date   create:2004/07/28 update:$Date: 2005/12/13 09:00:45 $
*/
void Ne2000MoNic::nic_init(void)
{
    // eϐ̏
    int i;
    byte c;

    //NICZbg
    c = inp8(NE_ASIC_RESET);
    outp8(NE_ASIC_RESET, c);
    
    //Zbg܂ő҂
    sleep(300);
    
    // [gDMA ~
    outp8( NE_P0_COMMAND, ne_cr_proto | NE_CR_STP );

    // FIFO XbVh 8Byte,[gDMA ֎~
    // 8086 oCgI[_,16bit DMA ] 
    // Page0_0Eh DATA CONFIGURATION REGISTER (DCR) 0EH (WRITE)
    //   7 6   5   4   3  2   1    0
    //   - FT1 FT0 ARM LS LAS BOS WTS
    //   0 1   0   0   1   0   0    1
    outp8( NE_P0_DCR, NE_DCR_FT1 + NE_DCR_WTS + NE_DCR_LS );

    // [gDMA oCgJE^NA
    outp8( NE_P0_RBCR0, 0 );
    outp8( NE_P0_RBCR1, 0 );

    // j^[h
    // (pPbgMȂAobt@O͂Ȃ)
    // RECEIVE CONFIGURATION REGISTER (RCR) 0CH (WRITE)
    outp8( NE_P0_RCR, NE_RCR_MON );

    // [vobN[h
    // TRANSMIT CONFIGURATION REGISTER (TCR) 0DH (WRITE)
    outp8( NE_P0_TCR, NE_TCR_LB0 );

    // MOobt@JnAhX̐ݒ
    // 64
    outp8( NE_P0_TPSR, NE_TX_PAGE_START );
    // MOobt@JnAhX̐ݒ 
    // 70
    outp8( NE_P0_PSTART, NE_RX_PAGE_START );
    
    // MOobt@EAhX̐ݒ
    // 70
    outp8( NE_P0_BNRY, NE_RX_PAGE_START );
    // MOobt@IAhX̐ݒ
    // 128
    outp8( NE_P0_PSTOP, NE_RX_PAGE_STOP );

    // 荞݃Xe[^XWX^̃NA
    outp8( NE_P0_ISR, 0xff );
    //  荞݋̐ݒ 
    // Packet recieve successful
    outp8( NE_P0_IMR, NE_IMR_PRXE );
    
    //Yamami S荞݂Ă݂
    //outp8( NE_P0_IMR, 0x7F );

    // Page 1 ̐ݒ
    outp8( NE_P0_COMMAND, ne_cr_proto | ( NE_CR_PS1 + NE_CR_STP ) );

    // Ethernet AhX̐ݒ
    // Ŏw肵AhX̃pPbg󂯎
    for(i=0;i<6;i++){
        outp8( NE_P1_PAR0 + i, ether_mac_addr[i] );
    }

    // ŏɎMpPbgi[AhX̐ݒ
    outp8( NE_P1_CURR, NE_RX_PAGE_START + 1 );

    /* }`LXgWX^̐ݒ */
    outp8( NE_P1_MAR0, 0 );
    outp8( NE_P1_MAR0+1, 0 );
    outp8( NE_P1_MAR0+2, 0 );
    outp8( NE_P1_MAR0+3, 0 );
    outp8( NE_P1_MAR0+4, 0 );
    outp8( NE_P1_MAR0+5, 0 );
    outp8( NE_P1_MAR0+6, 0 );
    outp8( NE_P1_MAR0+7, 0 );

    // Page 0 ɂǂ 
    outp8( NE_P0_COMMAND, ne_cr_proto | NE_CR_STP );

    // MpPbgtB^̐ݒ
    // u[hLXgƎ݂̂Ɋi[ 
    // accept broadcast
    outp8( NE_P0_RCR, NE_RCR_AB );
//  RgAEg
// Yamamij^[ĥ܂܂ƂĂ݂!!!!! ɂȂ

    //Yamami v~XLXĝݎ󂯎悤ɂĂ݂???? Ⴄ悤
    //outp8( NE_P0_RCR, NE_RCR_APROMIS );

    // NIC ANeBuɂ
    outp8( NE_P0_COMMAND, ne_cr_proto | NE_CR_STA );

    // [vobN[h𔲂Ēʏ퓮샂[hɓ 
    outp8( NE_P0_TCR, 0 );
}





/*!
    \brief ne_pio_writemem
        J[`
        Ne2000 obt@
    \param  byte *src [in] ]AhX
    \param  dword dest [in] ]AhX
    \param  dword size [in]  
    \return void

    \author Yamami
    \date   create:2004/08/02 update:$Date: 2005/12/13 09:00:45 $
*/
void Ne2000MoNic::ne_pio_writemem( byte *src, dword dest, dword size )
{
    dword i;

    word writetmp;

    /* Xe[^XWX^NA */
    outp8( NE_P0_COMMAND, NE_CR_RD2 + NE_CR_STA );
    outp8( NE_P0_ISR, NE_ISR_RDC);

    /*  */
    outp8( NE_P0_RBCR0, size & 0xff );
    outp8( NE_P0_RBCR1, size >> 8 );

    /* ]AhX */
    outp8( NE_P0_RSAR0, dest & 0xff );
    outp8( NE_P0_RSAR1, dest >> 8 );
    outp8( NE_P0_COMMAND, NE_CR_RD1 + NE_CR_STA );

//    for(i=0;i<size;i+=2){
//        outp8( PIO_ADATA, *(src+1) );
//        outp8( NE_ASIC_DATA, *src );
//        src+=2;
//    }


    // 2004/08/02 DATA16rbgłƂ肷̂ŁAWordϊI/O
    for(i = 0 ; i < size ; i+=2 , src+=2){
        //writetmp = (word)(*(src) << 8) + (word)*(src+1);
        //gGfBAȂ炱HH
        writetmp = (word)(*(src + 1) << 8) + (word)*(src);
        outp16( NE_ASIC_DATA, writetmp );
    }
    
    /* wait */
    for(i=0;i<0xff;i++){
        if( ( inp8(NE_P0_ISR) & NE_ISR_RDC ) == 0 )
            break;
    }

}


/*!
    \brief ne_pio_readmem
        J[`
         NE2000 ̃ǂ݂
    \param  dword src [in] ]AhX
    \param  byte *dest [in] ]AhX
    \param  dword size [in]  
    \return void

    \author Yamami
    \date   create:2004/08/02 update:$Date: 2005/12/13 09:00:45 $
*/
void Ne2000MoNic::ne_pio_readmem( dword src, byte *dest, dword size )
{
    dword i;

    word readtmp;

//Yamami fobO
//printf("ne_pio_readmem src=%x \n",src);

    // abort DMA, start NIC
    outp8( NE_P0_COMMAND, NE_CR_RD2 + NE_CR_STA );
    // length
    outp8( NE_P0_RBCR0, size & 0xff );
    outp8( NE_P0_RBCR1, size >> 8 );
    // source address
    outp8( NE_P0_RSAR0, src & 0xff );
    outp8( NE_P0_RSAR1, src >> 8 );
    outp8( NE_P0_COMMAND, NE_CR_RD0 + NE_CR_STA );

//    for(i=0;i<size;i+=2){
//        *dest=inp8( NE_ASIC_DATA );
//        *(dest+1)=inp8( PIO_ADATA );
//        dest+=2;
//    }
    
    // 2004/08/02 DATA16rbgłƂ肷̂ŁAWordϊI/O
    for(i = 0 ; i < size ; i+=2 , dest+=2){
        readtmp=inp16( NE_ASIC_DATA );
        //*dest=(byte)(readtmp >> 8);
        //*(dest+1)=(byte)(readtmp & 0xff);
        //gGfBAȂ炱HH
        *(dest+1)=(byte)(readtmp >> 8);
        *(dest)=(byte)(readtmp & 0xff);
    }
    
}



/*!
    \brief ne_bcompare
        J[`
         oCir[`
    \param  byte *src [in] rAhX
    \param  byte *dest [in] rAhX
    \param  dword size [in] 
    \return int :v==0,sv==0ȊO

    \author Yamami
    \date   create:2004/08/02 update:$Date: 2005/12/13 09:00:45 $
*/
int Ne2000MoNic::ne_bcompare( byte *src, byte *dest, dword size )
{
    dword i;

    for(i=0;i<size;i++){
        if( src[i]!=dest[i] )
            return(1);
    }

    return(0);
}



/*!
    \brief getNicIRQ
       NIC IRQ Qb^[
    \author Yamami
    \date   create:2004/08/30 update:
*/
int Ne2000MoNic::getNicIRQ() 
{

    //TODO Yamami!! {́Aݒt@CIRQ𓾂
    return nicIRQ;
}

/*!
    \brief setNicIRQ
       NIC IRQ Zb^[
    \author Yamami
    \date   create:2004/10/31 update:2004/10/31
*/
void Ne2000MoNic::setNicIRQ(int value) 
{
    nicIRQ = value;

}


/*!
    \brief getNicIOBASE
       NIC IO_BASE Qb^[
    \author Yamami
    \date   create:2004/10/31 update:2004/10/31
*/
int Ne2000MoNic::getNicIOBASE() 
{

    //TODO Yamami!! {́Aݒt@CIRQ𓾂
    return nicIo_Base;
}

/*!
    \brief setNicIOBASE
       NIC IO_BASE  Zb^[
    \author Yamami
    \date   create:2004/10/31 update:2004/10/31
*/
void Ne2000MoNic::setNicIOBASE(int value) 
{
    nicIo_Base = value;

}
