/*!
    \file  AbstractMonic.h
    \brief NICNX wb_
    
    Copyright (c) 2004 Yamami
    WITHOUT ANY WARRANTY

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/09/04 update:$Date: 2005/12/13 09:00:45 $
*/
#ifndef _MONA_ABSTRACT_MONIC_
#define _MONA_ABSTRACT_MONIC_

#include <sys/types.h>
#include <monapi.h>
#include <monapi/io.h>
//Lgp
#include <monapi/cmemoryinfo.h>


/*! 
 *  \struct WAIT_FRAME_BUF
 *  \brief ҂t[\
 */
typedef struct{
    dword cmHandle;  //Lnh
    dword cmSize;  //LTCY
}WAIT_FRAME_BUF;



/*!
    abstract class AbstractMonic
*/

class AbstractMonic {

  private:

  protected:
    /*! \brief AbstractMonic e|Mobt@ */ 
    byte   frame_buf[1500];
    
    /*! \brief MpPbg{̂̒ */ 
    dword    frame_len;
    
    virtual void frame_input(void) = 0;
    
  public:
  
    //Publico
    
    /*! \brief ҂t[Xg */ 
    List<WAIT_FRAME_BUF*>* waitFrameBufList;
    
    /*! \brief MACAhX */ 
    byte   ether_mac_addr[6];

    
    AbstractMonic();
    //NXȂ̂ŁAzfXNgN^`
    virtual ~AbstractMonic();
    
    virtual void enableNetWork(void);
    virtual void disableNetWork(void);
    
    //eC^[tF[X\bh TuNX(ۃNX(NIC)Ŏ)
    virtual void frame_output( byte *, byte *, dword, word ) = 0;
    virtual int init(void) = 0;
    virtual int nic_probe(void) = 0;
    //virtual void nic_init(void) = 0;
    virtual int getNicIRQ() = 0;
    virtual void setNicIRQ(int) = 0;
    virtual int getNicIOBASE() = 0;
    virtual void setNicIOBASE(int) = 0;
    
    void frame_input_public(void);
    //void pop_frame_list

};

#endif
