/**
	@file	IniManager.h
	@brief	.ini`̃f[^̃t@Cւ̓o

	.ini`̃f[^̃t@Cւ̓o

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifdef MONA
	#include <monapi.h>
#endif

#include "IniManager.h"
#include "../Basic/StringFn.h"
#include "../Basic/StringOther.h"
#include "../Basic/FileFn.h"

namespace monapi2	{

/**
IniManager::Write()̎̃\[gɎg

	@date	2005/08/20	junjunn 쐬
*/
class CDirKeyValue
{
public:
	String m_strDir;
	String m_strKey;
	String m_strValue;
};

/**
	@date	2005/08/20	junjunn 쐬
*/
int compareDirKeyValue(const void *p, const void *q)
{
	CDirKeyValue* pDKV1=(CDirKeyValue*)p;
	CDirKeyValue* pDKV2=(CDirKeyValue*)q;
	return (StringFn::compare(pDKV1->m_strDir,pDKV2->m_strDir));
}


//IniManager/////////////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool IniManager::isLineComment(cpchar1 p)
{
	if (StringFn::isEmpty(p))		return true;

	char1 c0 = p[0];
	char1 c1 = p[1];

	if (c0=='/'  && c1=='/')		return true;
	if (c0=='#')					return true;
	if (c0=='\n')					return true;

	return false;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::read(cpchar1 cszPath)
{
//t@CǂݏoB
	String str;
	if (! FileFn::read(cszPath,&str))		return;

//`B
	str.remove('\r');

//
	parse(str);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::parse(cpchar1 cszContent)
{
	m_strCurDir.empty();

//sɕ
	StringDivide SDLine(cszContent,"\n");

//s	
	for (uint i=0;i<SDLine.getCount();i++)
	{
//݂̍sB
		cpchar1 pLine = SDLine.getAt(i);
//RgsȂXLbv
		if (isLineComment(pLine))		continue;

//fBNgw̍s炵
		if (pLine[0]=='[')
		{
//fBNg̏߂ƏIB
			cpchar1 pStart = pLine+1;
			cpchar1 pEnd = StringFn::find(pLine,']');
			if (pEnd==NULL)	pEnd = StringFn::getEnd(pStart);	//JbRȂ̂͂ȂƂCB
			m_strCurDir.copy(pStart,pEnd-pStart);
		}
//l
		else
		{
//Key=Value`؂B
			StringDivide SDKeyValue(pLine,"=");
//L[
			String strKey=SDKeyValue.getAt(0);
//擪̋󔒂菜B
			strKey.remove(" ");		//
			strKey.remove("	");		//^u

//l
			String strValue;
			if (SDKeyValue.getCount()>=2)
			{
//	strTest= "a=b";
//Ȃǒlɂ=Ă܂Ă鍢P[XlĎcɂB
				String strValueUnified=SDKeyValue.getAt(1);
				for (uint i=2;i<SDKeyValue.getCount();i++)
				{
					strValueUnified+="=";
					strValueUnified+=SDKeyValue.getAt(i);
				}

//擪B
				cpchar1 pStart = strValueUnified;
//擪̋󔒂XLbvB
				while (*pStart==' ' || *pStart=='	')	pStart++;

//ŌB
				cpchar1 pEnd=pStart;
//="`"`Ή"B
				if (*pStart=='"')
				{
					pStart++;
					pEnd=StringFn::find(pStart,'"');
					if (pEnd==NULL)	pEnd = StringFn::getEnd(pStart+1);	//JbRȂ̂͂ȂƂCB
				}
//=``;s̏IB
				else
				{
					while (! (*pEnd==';' || *pEnd=='\0'))	pEnd++;

				}

//loB
				int iLen=pEnd-pStart;
				pchar1 pBuffer=(pchar1)strValue.extendBuffer(iLen+1);
				StringFn::copy(pBuffer,pStart,iLen);
			}

//fBNg{L[ōtL[B
			String strKeyWhole;
			strKeyWhole.format("%s/%s",m_strCurDir.getString(),strKey.getString());
			m_strstrmap.setAt(strKeyWhole,strValue);
		}
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::toString(String* pstrOut)
{
	pstrOut->empty();
	int iCount=m_strstrmap.getCount();
	if (iCount==0)		return;

//\[g邽ߔzɒu
	CDirKeyValue* paDKV=new CDirKeyValue[iCount];

	int i=0;
	mapposition pos = m_strstrmap.getStartPosition();
	String strKey,strValue;
	while(pos)
	{
		m_strstrmap.getNext(&pos,&strKey,&strValue);
		StringDivide SD(strKey,"/");
		paDKV[i].m_strDir=SD.getAt(0);
		paDKV[i].m_strKey=SD.getAt(1);
		paDKV[i].m_strValue=strValue;
		i++;
	}

//\[g
	quicksort(paDKV,iCount,sizeof(CDirKeyValue),compareDirKeyValue);

//ɏo
	String strLine;
	cpchar1 cszLastDir="";
	for (i=0;i<iCount;i++)
	{
//VfBNgɂȂfBNgZNV}B
		if (! StringFn::isEqual(cszLastDir,paDKV[i].m_strDir))
		{
			strLine.format("[%s]\n",paDKV[i].m_strDir.getString());
			*pstrOut+=strLine;
			cszLastDir = paDKV[i].m_strDir;
		}
		strLine.format("%s=%s\n",paDKV[i].m_strKey.getString(),paDKV[i].m_strValue.getString());
		*pstrOut+=strLine;
	}

	delete[] paDKV;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::write(cpchar1 cszPath)
{
	String str;
	toString(&str);
	FileFn::write(cszPath,&str);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool IniManager::lookup(cpchar1 cszDir,cpchar1 cszKey,bool bDefault)
{
	cpchar1 p=lookup(cszDir,cszKey,"");
	return (StringFn::isEmpty(p))?bDefault:(StringFn::toInt(p)!=0);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	IniManager::lookup(cpchar1 cszDir,cpchar1 cszKey,int iDefault)
{
	cpchar1 p=lookup(cszDir,cszKey,"");
	return (StringFn::isEmpty(p))?iDefault:StringFn::toInt(p);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
float IniManager::lookup(cpchar1 cszDir,cpchar1 cszKey,float fDefault)
{
	cpchar1 p=lookup(cszDir,cszKey,"");
	return (StringFn::isEmpty(p))?fDefault:(float)StringFn::toFloat(p);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
cpchar1	IniManager::lookup(cpchar1 cszDir,cpchar1 cszKey,cpchar1 cszDefault)
{
	String	strFullKey;
	strFullKey.format("%s/%s",cszDir,cszKey);

	if (m_strstrmap.lookup(strFullKey,&m_strValueBuffer))
	{
		return m_strValueBuffer;
	}

	return cszDefault;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::setAt(cpchar1 cszDir,cpchar1 cszKey,bool bValue)
{
	setAt(cszDir,cszKey,bValue);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::setAt(cpchar1 cszDir,cpchar1 cszKey,int iValue)
{
	char1 szValue[32];
	StringFn::toString(szValue,iValue);

	setAt(cszDir,cszKey,szValue);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::setAt(cpchar1 cszDir,cpchar1 cszKey,float fValue)
{
	char1 szValue[32];
	StringFn::format(szValue,"%f",fValue);

	setAt(cszDir,cszKey,szValue);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void IniManager::setAt(cpchar1 cszDir,cpchar1 cszKey,cpchar1 cszValue)
{
	String strFullKey;
	strFullKey.format("%s/%s",cszDir,cszKey);

	m_strstrmap.setAt(strFullKey,cszValue);
}

}	//namespace monapi2
