/**
	@file	Point.cpp
	@brief	(x,y)̓񎟌W

	(x,y)̓񎟌W

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Point.h"
#include "Size.h"

namespace monapi2	{

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Point::add(const Size* cpSize) const
{
	Point point(x+cpSize->m_iWidth,y+cpSize->m_iHeight);
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Point::add(const Point* cpPoint) const
{
	Point point(x+cpPoint->getX(),y+cpPoint->getY());
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Point::operator +(const Size& crefSize) const
{
	Point point(x+crefSize.m_iWidth,y+crefSize.m_iHeight);
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
Point Point::subtract(const Size* cpSize) const
{
	Point point(x-cpSize->m_iWidth,y-cpSize->m_iHeight);
	return point;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/09/20	junjunn 쐬
*/
Size Point::subtract(const Point* cpPoint) const
{
	Size size(x-cpPoint->x,y-cpPoint->y);
	return size;
}

Size Point::operator -(const Point& crefPoint)const
{
	return subtract(&crefPoint);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Point::move(const Size* cpSize)
{
	move(cpSize->getWidth(),cpSize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Point::move(const Point* cpPoint)
{
	move(cpPoint->getX(),cpPoint->getY());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Point::operator +=(const Size& crefSize)
{
	move(&crefSize);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Point::moveMinus(const Size* cpSize)
{
	move(-cpSize->getWidth(),-cpSize->getHeight());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Point::operator -=(const Size& crefSize)
{
	moveMinus(&crefSize);
}


}		//namespace monapi2
