/**
	@file	Color.h
	@brief	F

	F

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_MULTIMEDIA_COLOR_H
#define _MONAPI2_MULTIMEDIA_COLOR_H

#include "../Basic/Switch.h"
#include "../Basic/Type.h"

namespace monapi2	{

typedef dword colort;
typedef word color16t;

const colort COLOR_OPAQUE = 0xFF000000;			///<^

inline byte getRValue(colort color)	{return (byte)((color & 0x00FF0000) >> 16);}
inline byte getGValue(colort color)	{return (byte)((color & 0x0000FF00) >> 8);}
inline byte getBValue(colort color)	{return (byte)((color & 0x000000FF));}
inline byte getRValue(color16t color)	{return (byte)(color>>8);}		//(color>>11)*8Ɠ
inline byte getGValue(color16t color)	{return (byte)((color >> 3) & 0x000000F8);}
inline byte getBValue(color16t color)	{return (byte)((color << 3) & 0x000000F8);}
inline colort makeColor(byte r,byte g,byte b)	{return ((r<<16) + (g<<8) + (b));}

colort scaleColor(colort color,float fScale,bool bNormalize);

/**
24rbg̐Fl𑀍삷NXB

	@date	2005/08/20	junjunn 쐬
*/
class Color
{
//\bh
public:
///@name RXgN^
//@{
	Color()						{clear();}			///<RXgN^
	Color(byte r,byte g,byte b)	{set(r,g,b);}		///<RXgN^
	Color(colort color)			{set(color);}		///<RXgN^
	Color(color16t color16)		{set(color16);}		///<RXgN^
//@}

///@name 擾
//@{
	byte getR() const {return (byte)r;}
	byte getG() const {return (byte)g;}
	byte getB() const {return (byte)b;}
	colort getColort() const;		///<return RGB(r,g,b);
//@}

///@name Z
//@{
	void set(byte r,byte g,byte b);			///<Zbg
	void set(colort color);					///<Zbg
	void set(color16t color);				///<Zbg
	void scale(float f);					///<XP[O
	void scale(float f1,float f2,float f3);	///<XP[O
	void add(int r,int g,int b);			///<
	void add(colort color);					///<
	void subtract(int r,int g,int b);		///<
	void subtract(colort color);			///<
	void clear()	{set(0,0,0);}			///<NA
	void normalize();						///<ScaleAdďɐ0`0xFF͈̔͂Ƀg~O
//@}


///o
public:
	int r;		///<ԁB{byteZĂrɃI[o[t[oȂ悤intɂB
	int g;		///<
	int b;		///<
};

/**
16rbg̐FlNXB

	@date	2005/09/20	junjunn 쐬
*/
class ColorConvertFn
{
public:

	inline static word convert24to16(colort color)
	{
        return  (word)(((color >> 8) & 0xF800) | ((color >> 5) & 0x07E0) | ((color >> 3) & 0x001F));
	}

//	inline static word convert24to16(byte r, byte g, byte b) {
//		return (word)(((r << 8) & 0xF800) | ((g << 3) & 0x07E0) | (b >> 3));}

//	inline static word convert24to16(byte* rgb) {
//		return (word)(((rgb[2] << 8) & 0xF800) | ((rgb[1] << 3) & 0x07E0) | (rgb[0] >> 3));}
};



}		// namespace monapi2

#endif
