/**
	@file	StringFn.cpp
	@brief	֘A

	֘A

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "StringFn.h"
#include "Language.h"

namespace monapi2
{

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
uint StringFn::getLength(cpchar1 cszP)
{
	if (cszP==NULL)	return 0;
	cpchar1 p=cszP;
	while (*p!='\0')		p++;

	return p-cszP;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
uint StringFn::getLength(cpcharv cszP)
{
	cpcharv p=cszP;
	while (*p!=0)		p++;

	return p-cszP;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::findDiff(cpchar1 cszP,cpchar1 cszQ,int iSearchCount)
{

//pɂɎg֐Ȃ̂Ń[v̒̃Xs[hłȂ悤ɃP[X𕪊򂷂B
	if (iSearchCount<0)
	{
		cpchar1 p=cszP;
		cpchar1 q=cszQ;
		for (;;)
		{
			if (*p!=*q)		return p-cszP;	\
			if (*p=='\0')	return -1;		\
			p++;q++;
		}
	}
	else
	{
		return findDiffUpto(cszP,cszQ,cszP+iSearchCount);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::findDiffUpto(cpchar1 cszP,cpchar1 cszQ,cpchar1 cszPUpto)
{
	cpchar1 p=cszP;
	cpchar1 q=cszQ;
	for (;;)
	{
		if (p==cszPUpto)	return -1;
		if (*p!=*q)			return p-cszP;
		if (*p=='\0')		return -1;
		p++;q++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::findDiffNoCase(cpchar1 cszP,cpchar1 cszQ,int iSearchCount)
{
	cpchar1 p=cszP;
	cpchar1 q=cszQ;
	cpchar1 cszPUpto = cszP+iSearchCount;

	for (;;)
	{
		if (p==cszPUpto)	return -1;
		char p2=CharFn::toLower(*p);
		char q2=CharFn::toLower(*q);
		if (p2!=q2)			return p-cszP;
		if (p2=='\0')		return -1;
		p++;q++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::compare(cpchar1 cszP,cpchar1 cszQ,int iSearchCount)
{
	int iDiffPos = StringFn::findDiff(cszP,cszQ,iSearchCount);
	if (iDiffPos==-1)
	{
		return 0;
	}
	else
	{
		return	cszP[iDiffPos]-cszQ[iDiffPos];
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
pchar1 StringFn::find(cpchar1 cszSource,char1 cFind,int iSearchCount)
{
	return findUpto(cszSource,cFind,cszSource+iSearchCount);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
//@memo cszFindɉăXLbvlς邱Ƃō\B
pchar1 StringFn::find(cpchar1 cszSource,cpchar1 cszFind,int iSearchCount)
{
	if (cszSource==NULL) return NULL;

	if (iSearchCount<0)
	{
		int iLengthFind = getLength(cszFind);
		cpchar1 p = cszSource;
		for (;;)
		{
			if (isEqual(p,cszFind,iLengthFind))	return (pchar1)p;
			if (*p=='\0')						return NULL;
			p++;
		}
	}
	else
	{
		return findUpto(cszSource,cszFind,cszSource+iSearchCount);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
pchar1 StringFn::findUpto(cpchar1 cszSource,char1 cFind,cpchar1 cszSourceUpto)
{
	if (cszSource==NULL) return NULL;

	cpchar1 p = cszSource;

	for (;;)
	{
		if (p==cszSourceUpto)	return NULL;
		if (*p==cFind)			return (pchar1)p;
		if (*p=='\0')			return NULL;
		p++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
pchar1 StringFn::findUpto(cpchar1 cszSource,cpchar1 cszFind,cpchar1 cszSourceUpto)
{
	cpchar1 p = cszSource;
	int iLengthFind = getLength(cszFind);
	for (;;)
	{
		if (p==cszSourceUpto)				return NULL;
		if (isEqual(p,cszFind,iLengthFind))	return (pchar1)p;
		if (*p=='\0')						return NULL;
		p++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
pchar1 StringFn::findReverse(cpchar1 cszSource,char1 cFind,int iSearchCount)
{
	if (cszSource==NULL) return NULL;

	cpchar1 p = cszSource;
	cpchar1 pLastAppear=NULL;
	cpchar1 cszSourceUpto = cszSource+iSearchCount;

	for (;;)
	{
		if (p==cszSourceUpto)				return NULL;
		if (*p==cFind)	pLastAppear=p;
		if (*p=='\0')	return (pchar1)pLastAppear;	//constւ̃LXg͂傤ȂB
		p++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
pchar1 StringFn::findReverse(cpchar1 cszSource,cpchar1 cszFind,int iSearchCount)
{
	if (cszSource==NULL) return NULL;

	cpchar1 p = cszSource;
	cpchar1 pLastAppear=NULL;
	cpchar1 cszSourceUpto = cszSource+iSearchCount;
	int iLengthFind = getLength(cszFind);

	for (;;)
	{
		if (p==cszSourceUpto)				return NULL;
		if (isEqual(p,cszFind,iLengthFind))	pLastAppear=p;
		if (*p=='\0')						return (pchar1)pLastAppear;
		p++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::getCountAppear(cpchar1 cszSource,char1 cFind,int iSearchCount)
{
	if (cszSource==NULL) return 0;

	cpchar1 p=cszSource-1;
	cpchar1 cszSourceUpto = cszSource+iSearchCount;
	int iAppearCount=0;

	while (p = StringFn::findUpto(p+1,cFind,cszSourceUpto))
	{
		iAppearCount++;
	}

	return iAppearCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::getCountAppear(cpchar1 cszSource,cpchar1 cszFind,int iSearchCount)
{
	if (cszSource==NULL) return 0;

	cpchar1 p=cszSource-1;
	cpchar1 cszSourceUpto = cszSource+iSearchCount;
	int iAppearCount=0;
	int iLengthFind=StringFn::getLength(cszFind);

	while (p = StringFn::findUpto(p+1,cszFind,cszSourceUpto))
	{
		if (iSearchCount!=-1 && p+iLengthFind>cszSourceUpto)	break;
		iAppearCount++;
		p+=iLengthFind-1;
	}

	return iAppearCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::getIntAt(cpchar1 cszSource,int iBase,cpchar1* pcszEnd)
{
	cpchar1 p = cszSource;

	bool (*FnIsDigit)(char1)=(iBase==10)?CharFn::isDigit:CharFn::isHex;
	
//܂͐oĂ܂Ői߂
	int iNegative = 1;

	for (;;)
	{
		if		(*p=='\0')	{if (pcszEnd) *pcszEnd=p;return 0;}
		else if (*p=='-')	iNegative*=-1;
		else if (FnIsDigit(*p))	break;

		p++;
	}

	int iReturn=0;
	for (;;)
	{
		char c=*p;
		if (! FnIsDigit(c))	break;

		int iNumber;
		if		(c>='A')	iNumber=c-'A'+10;
		else if (c>='a')	iNumber=c-'a'+10;
		else				iNumber=c-'0';

		iReturn=iReturn*iBase + iNumber;
		p++;
	}
		
	if (pcszEnd) *pcszEnd=p;
	return iReturn*iNegative;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::toInt(cpchar1 cszSource,int iBase,cpchar1* pcszEnd)
{
	return getIntAt(cszSource,iBase,pcszEnd);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
float StringFn::toFloat(cpchar1 cszSource,cpchar1* pcszEnd)
{
//cszEndNULL̉\̂łgB
	cpchar1 cszEndTemp;

//܂͐p[gE
	float fReturn = (float)getIntAt(cszSource,10,&cszEndTemp);

//p[g
	if (*cszEndTemp == '.')
	{
		float fFloatPart = (float)getIntAt(cszEndTemp+1,10,&cszEndTemp);

//fFloatPart͐ł̌`Ȃ̂ŏ_ɒ10Ŋ葱B
		while (fFloatPart > 1)
			fFloatPart/=10;

		fReturn+=(fReturn>=0)?fFloatPart:-fFloatPart;
	}

	if (pcszEnd)	*pcszEnd=cszEndTemp;
	return fReturn;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::duplicate(pchar1* pszOut,cpchar1 cszIn)
{
	*pszOut = new char1[StringFn::getLength(cszIn) + 1];
	return StringFn::copy(*pszOut,cszIn);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
//R[h͍lĂȂB
void StringFn::toLower(pchar1 szSource)
{
	for(pchar1 p=szSource;*p!='\0';p++)
	{
		*p=CharFn::toLower(*p);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void StringFn::toUpper(pchar1 szSource)
{
	for(pchar1 p=szSource;*p!='\0';p++)
	{
		*p=CharFn::toUpper(*p);
	}
}


//////////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::copy(pchar1 szOut,cpchar1 cszIn,int iCopyCount)
{
	if (cszIn==NULL)	return 0;

	pchar1  p=szOut;
	cpchar1 cq=cszIn;

	if (iCopyCount<0)
	{
		while (*p++=*cq++)
			;
	}
	else
	{
		if (iCopyCount==0)	return 0;

		cpchar1 cqEnd=cszIn+iCopyCount;
		while (*p++=*cq++)
		{
			if (cq>=cqEnd)	{*p='\0';;return iCopyCount;}
		}
		
	}
	return cq-cszIn-1;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::copy(pchar2 szOut,cpchar2 cszIn,int iCopyCount)
{
	pchar2  p=szOut;
	cpchar2 cq=cszIn;

	if (iCopyCount<0)
	{
		while (*p++=*cq++)
			;

		return cq-cszIn-1;
	}
	else
	{
		cpchar2 cqEnd=cszIn+iCopyCount;
		while (*p++=*cq++)
		{
			if (cq>=cqEnd)	break;
		}
		*p='\0';
		return cq-cszIn;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::format(pchar1 szBuffer,cpchar1 cszFormat,...)
{
	vapointer vap;

	VAPOINTER_SET_START(vap,cszFormat);
	return formatV(szBuffer,cszFormat,vap);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::estimateVALength(cpchar1 cszFormat,vapointer vapStart)
{
	uint nNewLength=0;

//vlcszFormať̈w悤ɂȂB
	vapointer vap = vapStart;

	for (cpchar1 pRead = cszFormat;*pRead!='\0';)
	{
		char1 c1=pRead[0];
		if (c1 == '%')				//uV{
		{
			char1 c2=pRead[1];
			if (c2=='%')			//GXP[vV[NGXB
			{
				nNewLength+=1;
			}
			else
			{
				if		(c2=='s')		//
				{
					char* p= VAPOINTER_ADVANCE(vap,char*);
					nNewLength+=StringFn::getLength(p);
				}
				else if		(c2=='f')		//
				{
					VAPOINTER_ADVANCE(vap,int);	//float
					nNewLength+=30;		//double20{FXlĂꂾΏ\
				}
				else if	(c2=='d' || c2=='x' || c2=='X')		//
				{
					VAPOINTER_ADVANCE(vap,int);
					nNewLength+=16;		//2^3210Ȃ̂ŏ_Ƃ+-Ăŏ\
				}
			}
			pRead+=2;
		}
		else
		{
			if (! CharFn::isASCII(c1))
			{
				pRead+=2;
				nNewLength+=2;
			}
			else
			{
				pRead++;
				nNewLength++;
			}
		}
	}

	return nNewLength;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::formatV(pchar1 szBuffer,cpchar1 cszFormat,vapointer vapStart)
{
	vapointer vap = vapStart;
	pchar1 pWrite = szBuffer;

	for (cpchar1 pRead = cszFormat;*pRead!='\0';)
	{
		char1 c1=pRead[0];
		if (c1 == '%')				//uV{
		{
			char1 c2=pRead[1];
			if (c2=='%')			//GXP[vV[NGXB
			{
				*pWrite++='%';
			}
			else
			{
				int iWidth = 0;

//w肵ĂB
				if (CharFn::isDigit(c2))
				{
					iWidth = c2-'0';
					c2=pRead[2];
					pRead++;
				}

				if		(c2=='s')		//
				{
					char* p = VAPOINTER_ADVANCE(vap,char*);
					pWrite+=StringFn::copy(pWrite,p);
				}
				else if	(c2=='d')		//
				{
					int i = VAPOINTER_ADVANCE(vap,int);
					char szString[20];
					toString(szString,i,10,false,iWidth);
					pWrite+=StringFn::copy(pWrite,szString);
				}
				else if	(c2=='x')		//16i
				{
					int i = VAPOINTER_ADVANCE(vap,int);
					char szString[20];
					toString(szString,i,16,false,iWidth);
					pWrite+=StringFn::copy(pWrite,szString);
				}
				else if	(c2=='f')		//
				{
					double d = VAPOINTER_ADVANCE(vap,double);
					char szString[30];
					toStringFloatPlain(szString,d);
					pWrite+=StringFn::copy(pWrite,szString);
				}
				else if	(c2=='X')		//16i
				{
					int i = VAPOINTER_ADVANCE(vap,int);
					char szString[20];
					toString(szString,i,16,true,iWidth);
					pWrite+=StringFn::copy(pWrite,szString);
				}
				else	//sBǂ悤Ȃ̂ŋL̂܂܏óB
				{
					*pWrite++='%';
					*pWrite++=c2;
				}
			}
			pRead+=2;
		}
		else
		{
			if (! CharFn::isASCII(c1))
			{
				*pWrite++=*pRead++;
				*pWrite++=*pRead++;
			}
			else
			{
				*pWrite++=*pRead++;
			}
		}
	}

	*pWrite='\0';
	return pWrite-szBuffer;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::toString(pchar1 szBuffer,int iTarget,int iBase,bool bCapital,int iWidth)
{
//`͂܂Ȃ̏ԂłƂ肠쐬B
	char szNumberWithoutFormat[32];
	pchar1 pWrite = szNumberWithoutFormat;
	if (iTarget==0)
	{
		pWrite+=StringFn::copy(pWrite,"0");
	}
	else
	{
		if (iTarget<0)
		{
			*pWrite++='-';
			iTarget=-iTarget;
		}

		if (iBase==10)
		{
			bool bWriteOn = false;
			for (int iDivide = 1000000000;iDivide!=0;iDivide/=10)
			{
				char cDigit = (char)(iTarget/iDivide);
				if (cDigit!=0)	bWriteOn=true;
				if (bWriteOn)
					*pWrite++=toString(cDigit,bCapital);
				iTarget-=cDigit*iDivide;
			}
		}
		else
		{
			int abMaskTable[]={0xF0000000,0x0F000000,0x00F00000,0x000F0000,0x0000F000,0x00000F00,0x000000F0,0x0000000F};
			bool bWriteOn = false;
			for (int i=0;i<8;i++)
			{
				int cDigit = (char)((iTarget & abMaskTable[i]) >> ((7-i)*4));
				if (cDigit!=0)	bWriteOn=true;
				if (bWriteOn)
					*pWrite++=toString(cDigit,bCapital);
			}
		}
		*pWrite='\0';
	}

//ꂩ琮`B
	int iNumberWidth = StringFn::getLength(szNumberWithoutFormat);
	pWrite = szBuffer;
	for (int i=iNumberWidth;i<iWidth;i++)
	{
		*(pWrite++) = '0';
	}
	pWrite+=StringFn::copy(pWrite,szNumberWithoutFormat);

	return pWrite-szBuffer;
}

/**
	@brief	d𕶎ɂB܂肩BꕔĂȂEEE
	@param dFullPrecision trueȂ1.1200000000̂悤ɍŌ0KóBfalseȂ1.12̂悤ɐ؂ƂŐ؂B
	@date	2005/09/28	junjunn 쐬
*/
void StringFn::toStringFloatPlain(pchar1 szBuffer,double d)
{
	pchar1 pWrite = szBuffer;

//vX}CiX
	bool bPositive = (d>=0);
	if (!bPositive)
	{
		d=-d;
		*pWrite++='-';
	}

//_̕Ɖɂ킯
	int iIntPart = (int)d;
	pWrite+=toString(pWrite,iIntPart);

//B
//ۂĂ݂doubleł͐x̖333.14 - 333 = 0.13999999݂ȍׂ[
//Ė肪ôfloatgBfloatȂ琸xȂ̂KĒ[Ȃ̂œsǂB
	double dFloatPart = d-iIntPart;

//d傫intɒȂBiKł͏łȂP[XȂ̂ŋAĖႤEEE
	if (dFloatPart >= 1)
	{
		StringFn::copy(szBuffer,"error");
		return;
	}


//ȏ㏬͖
	const double fIgnoreFloatSize = 0.00000001;

//Ȃ
	if (dFloatPart>fIgnoreFloatSize)
	{
		*pWrite++='.';

//𐮐ɒBȂȂ܂ŊgB
		int i0Count=0;	//0}JEgB
		while ((dFloatPart - (int)round(dFloatPart)) > fIgnoreFloatSize)
		{
			dFloatPart*=10;
			if (dFloatPart < 1) i0Count++;
		}

		for (int i=0;i<i0Count;i++)
		{
			*pWrite++='0';
		}

		pWrite+=toString(pWrite,(int)round(dFloatPart));
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
char StringFn::toString(int i,bool bCapital)
{
	if (i<10)
	{
		return (char)('0'+i);
	}
	else
	{
		int i2=(char)(i-10);
		return (bCapital)?(char)('A'+i2):(char)('a'+i2);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::replace(pchar1 szSource,char1 cFrom,char1 cTo)
{
	int iReplaceCount=0;

	pchar1 p = szSource-1;
	while (p = find(p+1,cFrom))
	{
		*p = cTo;
		iReplaceCount++;
	}
	return iReplaceCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::replace(pchar1 szSource,cpchar1 cszFrom,cpchar1 cszTo)
{
//܂͕񂪈xłĂ邩yׂBuKvȂȂ炱̎_ŋpĂyȂB
	cpchar1 cpNextAppear;
	if ((cpNextAppear = StringFn::find(szSource,cszFrom))==NULL)	return 0;

//uƕ񂪂ǂǂςĂ䂭̂Ō̃Rs[Ă͂ɎgB
	pchar1 cszSourceCopy;
	duplicate(&cszSourceCopy,szSource);

	int iReplaceCount = replace(szSource,cszSourceCopy,cszFrom,cszTo,cpNextAppear - szSource);

	delete cszSourceCopy;
	return iReplaceCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::replace(pchar1* pszOut,cpchar1 cszIn,cpchar1 cszFrom,cpchar1 cszTo)
{
//܂͒u̒߂B
	int iReplaceLength = getReplaceLength(cszIn,cszFrom,cszTo);

	*pszOut = new char1[iReplaceLength+1];

	return replace(*pszOut,cszIn,cszFrom,cszTo);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::replace(class String* pstrOut,cpchar1 cszIn,cpchar1 cszFrom,cpchar1 cszTo)
{
	int iReplaceLength = getReplaceLength(cszIn,cszFrom,cszTo);
	pchar1 pBuffer = pstrOut->extendBuffer(iReplaceLength);
	return replace(pBuffer,cszIn,cszFrom,cszTo);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::getReplaceLength(cpchar1 cszIn,cpchar1 cszFrom,cpchar1 cszTo)
{
	int iOriginalLength = getLength(cszIn);

	int iCountAppear = getCountAppear(cszIn,cszFrom);
	int iLengthDiff = getLength(cszTo) - getLength(cszFrom);

	int iNewLength = iOriginalLength + iLengthDiff * iCountAppear;
	return iNewLength;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int	StringFn::replace(pchar1 szOut,cpchar1 cszIn,cpchar1 cszFrom,cpchar1 cszTo,int iFirstAppear)
{
	cpchar1 cpNextAppear;

//replace`̌ĂяoōŏɌꏊłɒׂĂB
	if (iFirstAppear!=-1)
	{
		cpNextAppear = cszIn + iFirstAppear;
	}
	else
	{
//܂͕񂪈xłĂ邩yׂBuKvȂȂ炱̎_ŋpĂyȂB
		if ((cpNextAppear = StringFn::find(cszIn,cszFrom))==NULL)	return 0;
	}


//u̕Kvȏ˔ĵłuJnB

//̑ZbgAbv
	pchar1 pWrite	= szOut;
	cpchar1 cpRead	= cszIn;
	int iLengthFrom	= StringFn::getLength(cszFrom);

//uC
	int iReplaceCount = 0;
	while(*cpRead)
	{
		if (cpRead == cpNextAppear)
		{
			pWrite+=StringFn::copy(pWrite,cszTo);
			cpRead+=iLengthFrom;
			cpNextAppear = StringFn::find(cpRead,cszFrom);

			iReplaceCount++;
		}
		else	
		{
			*pWrite++=*cpRead++;
		}
	}

	*pWrite = '\0';
	return iReplaceCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int StringFn::remove(pchar1 szOut,char1 cRemove)
{
	char szRemove[2];
	szRemove[0]=cRemove;
	szRemove[1]='\0';

	return replace(szOut,szRemove,"");
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
cpchar1 StringFn::getEnd(cpchar1 cszSource)
{
	return cszSource + getLength(cszSource);
}


}		//namespace monapi2
