/**
	@file	Memory.cpp
	@brief	ǂݍ݁E݁E

	ǂݍ݁E݁E

	License=Mona License
	@version $Revision: 1.4 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Memory.h"
#include "Math.h"

namespace monapi2	{

/*
E1

	foȑ
		for(uint n=0;n<nCount;n++)
	ƏƂ
		for(uint n=nCount;n>0;n--)
	ƏƂ͌҂̕[vƂnCount̒lĂяoKvȂ̂ő
	reXgʂ͈Ⴂ͂ȂB

	RpC̍œKŎsɂ͂ǂőȌ`ɒ̂B
	͋CɂȂł悳B


E2

	łnCount̘A
		divide(nCount,4,&i4ByteCount,&i1ByteCount);
		for(uint n=0;n<(uint)i4ByteCount;n++)		{*pdwTo++ = iValue4;}
	ȊłĂ邪ʂ̏Ƃ
		for (;nCount>=4;nCount-=4)					{*pdwTo++ = iValue4;}
	ƂɂǂȂ邩B

	҂̕divideĂԎԂȂR[hʂăX}[gɌ邪ۂ͒xȂB
	O҂̏ƃ[v̒++̉\Ȍ̃Vvȃ[vɂȂ̂ɔ
	҂̓[vJE^̑-=4̌vZĂꂪyieBɂȂ悤B

	
̑ɂMemoryFn::setɂ傱傱Ă܂B
*/


/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
	@date	2005/09/17	junjunn ֐̂copy̖߂lɂnCountԂ悤ɂBl̎󂯓no邽߂킸ɃptH[}X͗g₷DB
*/
uint MemoryFn::copy(void* pTo,const void* cpFrom,uint nCount)
{
//@memo 4oCgE΍􂪕KvB

//Xs[hグ邽߂4oCg]gB
//܂]oCg4ŊďƏ]vZA4oCg]1oCg]ɂ킯B
	int i4ByteCount,i1ByteCount;
	divide(nCount,4,&i4ByteCount,&i1ByteCount);

#ifdef _COMPILER_VISUALC
//4oCg]
	__asm
	{
		mov edi,pTo			//WX^Zbg
		mov esi,cpFrom
		mov ecx,i4ByteCount
		cld					//]w
		rep movsd			//4oCg]
	}

//1oCg]
	__asm
	{
		mov ecx,i1ByteCount	//̃WX^l4oCg]̎ɃZbg痬p
		rep movsb			//1oCg]
	}
#else
//4oCg]
    asm volatile("movl %0, %%edi \n"
                 "movl %1, %%esi \n"
                 "movl %2, %%ecx \n"
                 "cld            \n"
                 "rep movsd      \n"
                 :
                 : "m"(pTo), "m"(cpFrom), "m"(i4ByteCount)
                 : "edi", "esi", "ecx");

//1oCg]
    asm volatile("movl %0, %%ecx \n"
                 "rep movsb      \n"
                 :
                 : "m"(i1ByteCount)
                 : "ecx");
#endif

	return nCount;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void MemoryFn::swap(void* pBuffer1,void* pBuffer2,uint nCount)
{
//Xs[hグ邽߂4oCg]gB
	int i4ByteCount,i1ByteCount;
	divide(nCount,4,&i4ByteCount,&i1ByteCount);

//4oCg]
	uint32* pdwBuffer1=(uint32*)pBuffer1;
	uint32* pdwBuffer2=(uint32*)pBuffer2;
	uint n;
	for(n=0;n<(uint)i4ByteCount;n++)
	{
		int iTemp = *pdwBuffer1;
		*pdwBuffer1++ = *pdwBuffer2;
		*pdwBuffer2++ = iTemp;
	}

//1oCg]
	uint8* pcBuffer1=(uint8*)pdwBuffer1;
	uint8* pcBuffer2=(uint8*)pdwBuffer2;
	for(n=0;n<(uint)i1ByteCount;n++)
	{
		char cTemp = *pcBuffer1;
		*pcBuffer1++ = *pcBuffer2;
		*pcBuffer2++ = cTemp;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void MemoryFn::copySafe(void* pTo, const void* cpFrom,uint nCount)
{
//ʂcopył͍
	if (pTo>cpFrom && pTo<(uint8*)cpFrom+nCount)
	{
//Xs[hグ邽߂4oCg]gB
		int i4ByteCount,i1ByteCount;
		divide(nCount,4,&i4ByteCount,&i1ByteCount);

//ΕRs[
//1oCg]
		uint8* pcTo		=(uint8*)pTo	+ nCount;
		uint8* cpcFrom	=(uint8*)cpFrom	+ nCount;
		uint n;
		for(n=0;n<(uint)i1ByteCount;n++)
		{
			*--pcTo = *--cpcFrom;
		}

//4oCg]
		uint32* pdwTo		=(uint32*)pcTo;
		uint32* cpdwFrom	=(uint32*)cpcFrom;
		for(n=0;n<(uint)i4ByteCount;n++)
		{
			*--pdwTo = *--cpdwFrom;
		}
	}
	else
	{
		copy(pTo,cpFrom,nCount);
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int MemoryFn::findDiff(const void* cpBuffer1,const void* cpBuffer2,uint nCount)
{
//Xs[hグ邽߂4oCgrgB
	int i4ByteCount,i1ByteCount;
	divide(nCount,4,&i4ByteCount,&i1ByteCount);

	uint32* cpdwBuffer1=(uint32*)cpBuffer1;
	uint32* cpdwBuffer2=(uint32*)cpBuffer2;
	uint n;
	for (n=0;n<(uint)i4ByteCount;n++)
	{
//Ⴂ1oCgrɐ؂ւB
		if (*cpdwBuffer1!=*cpdwBuffer2)
		{
			uint8* cpcBuffer1=(uint8*)cpdwBuffer1;
			uint8* cpcBuffer2=(uint8*)cpdwBuffer2;
			for (;;)	//K4oCgɎ~܂̂ŕKvȂB
			{
				if (*cpcBuffer1!=*cpcBuffer2)	return (cpcBuffer1-(uint8*)cpBuffer1);

				cpcBuffer1++;
				cpcBuffer2++;
			}
		}

		cpdwBuffer1++;
		cpdwBuffer2++;
	}

	uint8* cpcBuffer1=(uint8*)cpdwBuffer1;
	uint8* cpcBuffer2=(uint8*)cpdwBuffer2;
	for(n=0;n<(uint)i1ByteCount;n++)
	{
		if (*cpcBuffer1!=*cpcBuffer2)	return (cpcBuffer1-(uint8*)cpBuffer1);

		cpcBuffer1++;
		cpcBuffer2++;
	}

	return -1;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void MemoryFn::set(void* pTo,int iValue,uint nCount)
{
//Xs[hグ邽߂4oCg]gB
	uint32* pdwTo=(uint32*)pTo;
	int iValue4 = iValue + (iValue<<8) + (iValue<<16) + (iValue<<24);


//Xs[ĥ߂ɓ̈ႤŎ݂Ă݂B

//P[X1Bdivide͎gȂ-=4[vgBxB10000000̃[v35.0bB
#if 0
	for (;nCount>=4;nCount-=4)
	{
		*pdwTo++ = iValue4;
	}

/*
Lfor̒VCɂœKAZu

00401971 	mov	ebx,[ebp+00000010h]	//ebx = n2
00401974 	cmp	ebx,04h				//if (n2>4)
00401977 	jc	00401992h			//if (n2>4) goto 401992

00401979 	push	esi
0040197A 	mov	esi,ebx
0040197C 	shr	esi,02h
0040197F 	mov	ecx,esi
00401981 	mov	eax,edx
00401983 	repz
00401984 	stosd
00401985 	mov	eax,[ebp+00000008h]
00401988 	lea	edi,[eax+esi*4]

0040198B 	sub	ebx,04h
0040198E 	dec	esi
0040198F 	jnz	0040198Bh
00401991 	pop	esi

00401997 	test	ebx,ebx
00401999 	jbe	004019BAh
0040199B 	mov	al,[ebp+0000000Ch]
0040199E 	mov	ecx,ebx
004019A0 	mov	bl,al
004019A2 	mov	edx,ecx
004019A4 	mov	bh,bl
004019A6 	mov	eax,ebx
004019A8 	shl	eax,10h
004019AB 	mov	ax,bx
004019AE 	shr	ecx,02h
004019B1 	repz
004019B2 	stosd
004019B3 	mov	ecx,edx
004019B5 	and	ecx,03h
004019B8 	repz
004019B9 	stosb
`return
*/
	uint n;
	int i1ByteCount =nCount;

//P[X2Bdivideŕ++[vgBB10000000̃[v7.5bB
#else
	int i4ByteCount,i1ByteCount;
	divide(nCount,4,&i4ByteCount,&i1ByteCount);

	uint n;
	for(n=0;n<(uint)i4ByteCount;n++)
	{
		*pdwTo++ = iValue4;
	}

/*
Lfor̒VCɂœKAZu

00401988 	mov	edx,[ebp+0000000Ch]		:.
0040198B 	test	edx,edx				:.
0040198D 	jbe	0040199Bh				:if (n2!=0)	goto 40199B

0040198F 	mov	ecx,edx					:ecx=n2;
00401991 	mov	eax,esi					:eax=
00401993 	repz
00401994 	stosd
00401995 	mov	eax,[ebp+00000008h]
00401998 	lea	edi,[eax+edx*4]

004019A0 	mov	ecx,[ebp+00000010h]
004019A3 	test	ecx,ecx
004019A5 	jbe	004019C1h
004019A7 	mov	al,bl
004019A9 	mov	bh,bl
004019AB 	mov	eax,ebx
004019AD 	mov	edx,ecx
004019AF 	shl	eax,10h
004019B2 	mov	ax,bx
004019B5 	shr	ecx,02h
004019B8 	repz
004019B9 	stosd
004019BA 	mov	ecx,edx
004019BC 	and	ecx,03h
004019BF 	repz
004019C0 	stosb
`return
*/
#endif


//1oCg]
	uint8* pcTo=(uint8*)pdwTo;
	for(n=0;n<(uint)i1ByteCount;n++)
	{
		*pcTo++ = (uint8)iValue;
	}
/*

	uint anMask1[4] ={0x00000000,0x000000FF,0x0000FFFF,0x00FFFFFF};
	uint anMask2[4] ={0xFFFFFFFF,0xFFFFFF00,0xFFFF0000,0xFF000000};
	*pdwTo &= anMask2[i1ByteCount];
	*pdwTo |= 0x12345678 & anMask1[i1ByteCount];
̂悤ɏΏȂčςނƎv
񂹂񂱂ꂾƈꎞIɂƂ͌dwordŃobt@̊_z
readAwriteĂĕیᔽ炢Ȃ̂Ŏ~߂B
*/
}


}		//namespace monapi2
