/**
	@file	Math.cpp
	@brief	w֘A

	w֘A

	License=Mona License
	@version $Revision: 1.4 $
	@date	$Date: 2005/09/05 15:00:18 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Math.h"
#include "Debug.h"

namespace monapi2
{
//ɎgIuWFNg
KnuthRandom g_KnuthRandom;

const double g_cd1overLn2	= 1.4426950408890;	// 1/ln2
const double g_cdLn2		= 0.69314718055995;	// ln2



/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void divide(int iNumerator,int iDenominator,int* piQuotient,int* piRemainder)
{
	*piQuotient = iNumerator / iDenominator;
	*piRemainder = iNumerator - iDenominator * *piQuotient;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void divide(double dNumerator,double dDenominator,int* piQuotient,double* pdRemainder)
{
	*piQuotient = (int)(dNumerator / dDenominator);
	*pdRemainder = dNumerator - dDenominator * *piQuotient;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
float convertLinearUnit(float fTarget,float fValue1From,float fValue1To,float fValue2From,float fValue2To)
{
	return (fValue2To - fValue1To) / (fValue2From - fValue1From) * (fTarget-fValue1From)+ fValue1To;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void putBetween(int* piTarget,int iMin,int iMax)
{
	*piTarget=getMin(*piTarget,iMax);
	*piTarget=getMax(*piTarget,iMin);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void getModule_ReduceRemainder(double dTarget,double udModule,int* piQuotient,double* piRemainder)
{
	*piQuotient = (int) (dTarget/udModule);
	*piRemainder = dTarget - udModule * *piQuotient;

//]dMolude̔傫ꍇ̕i߂B
	if (dTarget>0)
	{
		if (*piRemainder * 2 > udModule)
		{
			(*piQuotient)++;
			*piRemainder-=(udModule);
		}
	}
	else
	{
		if (-(*piRemainder) * 2 > udModule)
		{
			(*piQuotient)--;
			*piRemainder+=(udModule);
		}
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int mod(int iTarget,int iModule)
{
	int i=iTarget % iModule;
	return i;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double mod(double dTarget,double dModule)
{
	int iQuotient;
	double dRemainder;
	divide(dTarget,dModule,&iQuotient,&dRemainder);

	return dRemainder;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double floor(double x)
{
	return (x>=0)?(int)x:(int)x-1;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double ceil(double x)
{
	return (x>=0)?(int)x+1:(int)x;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double round(double x)
{
	return (x>=0)?floor(x+0.5):ceil(x-0.5);	//0.5𑫂Đ؂̂Ă͌ÓTIȃgbNB
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double log2(double x)
{
	if (x < 0)	return 0;

	double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld1
		fld		x
		fyl2x
		fstp	dResult
	}
#else
	asm volatile ("fld1");
    asm volatile ("fyl2x" : "=t"(dResult) : "0"(x));
#endif

	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double log10(double x)
{
/*
		10^y=x;			߂鎮B
		10=2^z;			z𓱓ĂuB
		(2^z)^y=x;
		2^(z*y)=x;
		z*y=log2(x);
		y=log2(x)/z;
*/

//L1/zBzŊ1/zCPUIɑ̂łuƂB
	const double cd1overLog2of10 = 0.30102999566398;
	double dResult = log2(x) * cd1overLog2of10;
	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double log(double x)
{
/*
		e^y=x;			߂鎮B
		e=2^z;			z𓱓ĂuB
		(2^z)^y=x;
		2^(z*y)=x;
		z*y=log2(x);
		y=log2(x)/z;
*/
	double dResult = log2(x) * g_cdLn2;
	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double exponential(double x)
{
//AZu
#if 1
	{
/*
		y=e^x;			߂鎮B
		e=2^z;			z𓱓ĂuB
		y=(2^z)^x;
		y=2^(z*x);
*/
		return SCPowerOf2::get(g_cd1overLn2 * x);	//ʂ̒Lz*x
	}
//WJ
#else
	{
/*
e^x̃eC[WJe^x=1+x+x^2/2! + x^3/3!@EEE

ǂxł邪x傫Ƃɂ͎Ԃ̂
x = i() + d()̌`ɕ

  e^x = e^(i + d) = e^i + e^d;

ɂB
e^i͐񐔂ׂ̂Ȃ̂ŕʂɌvZłB
e^d̓eC[WJŌvZB

ꂪʂƎv邪ꂶ܂Ȃ̂MonaIWi
x = i() + d1(1) + d(2)܂ōׂ
xƐx҂ƂɂEEE
*/
		int iXInteger;
		double dXFloat;
		getModule_ReduceRemainder(x,1,&iXInteger,&dXFloat);

//e^i̕B

//getPowerOf2Intg邪܂ǂAZułȂ̂Ŏ蓮łႦB
		double dExponentialIntegerResult;
		{
			if (iXInteger>0)
			{
				dExponentialIntegerResult=NAPIER;
				for (int i=0;i<iXInteger-1;i++)
				{
					dExponentialIntegerResult*=NAPIER;
				}
			}
			else
			{
				dExponentialIntegerResult=1;
				for (int i=0;i<-iXInteger;i++)
				{
					dExponentialIntegerResult/=NAPIER;
				}
			}
		}

//_1ƂȉɕB
		int iDecimal1;
		double dXFloat2=dXFloat;
		getModule_ReduceRemainder(dXFloat,0.1,&iDecimal1,&dXFloat2);

		double adExponentialDecimal1[]=
		{
			0.40656965974060,	//	e^-0.9
			0.44932896411722,	//	e^-0.8
			0.49658530379141,	//	e^-0.7
			0.54881163609403,	//	e^-0.6
			0.60653065971263,	//	e^-0.5
			0.67032004603564,	//	e^-0.4
			0.74081822068172,	//	e^-0.3
			0.81873075307798,	//	e^-0.2
			0.90483741803596,	//	e^-0.1
			1.0000000000000,	//	e^-0.0
			1.1051709180756,	//	e^ 0.1
			1.2214027581602,	//	e^ 0.2
			1.3498588075760,	//	e^ 0.3
			1.4918246976413,	//	e^ 0.4
			1.6487212707001,	//	e^ 0.5
			1.8221188003905,	//	e^ 0.6
			2.0137527074705,	//	e^ 0.7
			2.2255409284925,	//	e^ 0.8
			2.4596031111569,	//	e^ 0.9
		};

		double dExponentialFloat2Result=0;
		double dProduct = 1;
		double iFactorial=1;
		for (int i=1;i<10;i++)	//10񂮂炢double̐xo݂Bȏ͖ʁB
		{
			dExponentialFloat2Result += dProduct/iFactorial;
			iFactorial*=i;
			dProduct *= (dXFloat2);
		}

		return dExponentialIntegerResult * adExponentialDecimal1[iDecimal1+9] * dExponentialFloat2Result;
	}
#endif	//if 1
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
uint power(uint x, uint y)
{
	uint nResult=1;
	for (uint n=0;n<y;n++)
	{
		nResult*=x;
	}
	return nResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double power2(double x)
{
	return SCPowerOf2::get(x);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double power(double x, double y)
{
/*
		z=x^y;					߂鎮B
		log2(z)=y*log2(x);
		z = 2^(y*log2(x))
*/
	double dResult = power2(y * log2(x));
	return dResult;
}


/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double squareroot(double x)
{
	if (x<0)	return 0;

    double dResult;
#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		fsqrt
		fstp	dResult
	}
#else
//@author HigePon
    asm volatile ("fsqrt" : "=t"(dResult) : "0"(x));
#endif
    return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double sin(double x)
{
    double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		fsin
		fstp	dResult
	}
#else
//@author HigePon
    asm volatile ("fsin" : "=t"(dResult) : "0"(x));
#endif

	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double cos(double x)
{
    double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		fcos
		fstp	dResult
	}
#else
//@author HigePon
    asm volatile ("fcos" : "=t"(dResult) : "0"(x));
#endif

	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double tan(double x)
{
    double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		fptan
		fstp	st					//sinƂƈႢʂst(1)ɓĂ̂st͐؂̂
		fstp	dResult
	}
#else
    asm volatile ("fptan" : "=t"(dResult),"=u"(dResult) : "0"(x));
#endif

	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double atan(double y,double x)
{
    double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		y
		fld		x
		fpatan
		fstp	dResult
	}
#else
//@author HigePon
    asm volatile("fpatan" : "=t" (dResult) : "0" (x), "u" (y) : "st(1)");
#endif

	return dResult;
}

double atan(double x)
{
	return atan(x,1);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double asin(double x)
{
	if (absolute(x) > 1)	return 0;
/*
			1=sin(x)^2+cos(x)^2
		tan(x)=sin(x)/cos(x)	Ȃ̂
			1=(sin(x)^2+(sin(x)/tan(x))^2
			tan(x) = (sin(x)^2 / (1-sin(x)^2))

	Ŗɂ	sin(y)=x;
			tan(y) = (sin(y)^2 / (1-sin(y)^2))
			tan(y) = (x^2 / (1-x^2))
			y = atan((x^2 / (1-x^2))
*/

	double d = x*x;
	double dResult = atan(squareroot(d / (1-d)));

	return (x>0)?dResult:-dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double acos(double x)
{
	if (absolute(x) > 1)	return 0;
	if (x==-1)	return PI;
/*
			1=sin(x)^2+cos(x)^2
		tan(x)=sin(x)/cos(x)	Ȃ̂
			1=(tan(x)cos(x))^2+cos(x)^2
			tan(x) = ((1-cos(x)^2)/cos(x)^2)
			tan(x) = (1/cos(x)^2 - 1)

	Ŗɂ	cos(y)=x;
			tan(y) = (1/cos(y)^2 - 1)
			tan(y) = (1/x^2 - 1)
			y = atan((1/x^2 - 1))
*/

	double d = x;
	double dResult = atan(squareroot(1.0/(d*d) -1));

	return (x>0)?dResult:(PI-dResult);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
double SCPowerOf2::get(double x)
{
//CPU̖ߏ㏬Ɛ킯ĕʁXɌvZB
	int iIntPart;
	double dFloatPart;
	divide(x,1,&iIntPart,&dFloatPart);
	double dResultFloat	= getFloat(dFloatPart);
	double dResultInt	= getInt(iIntPart);
	double dResult = dResultInt * dResultFloat;
	return dResult;
}

/**
	@brief	2^fvZB-1<f<1B
	@date	2005/08/20	junjunn 쐬
*/
double SCPowerOf2::getFloat(double x)
{
	double dResult;

//2^f-1
#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		f2xm1
		fstp	dResult
	}
#else
    asm volatile ("f2xm1" : "=t"(dResult) : "0"(x));
#endif

	return dResult+1;
}

/**
	@brief	2^fvZBf͐ɐ؂̂ĂB
	@date	2005/08/20	junjunn 쐬
*/
//st(0) * 2^(st(1)vZB
double SCPowerOf2::getInt(double x)
{
	double dResult;

#ifdef _COMPILER_VISUALC
	__asm
	{
		fld		x
		fld1
		fscale
		fstp	st(1)	//ʂst(0)ɂ̂ǂst(1)|bvKv̂st(1)ɈړB
		fstp	dResult
	}
#else
  	asm volatile ("fld %0"::"f"(x));
  	asm volatile ("fld1");
	asm volatile ("fscale;" : "=t"(dResult));
#endif

	return dResult;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void initRandom(int iSeed)
{
	g_KnuthRandom.init(iSeed);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int getRandom(uint nRange)
{
	int r = g_KnuthRandom.getInt();

	return ((int) (r/g_KnuthRandom.getRange()*nRange));
}

//KnuthRandom////////////////
/**
	@brief	RXgN^
	@date	2005/08/20	junjunn 쐬
*/
KnuthRandom::KnuthRandom()
{
	m_iCurPos=0;
	m_fRange = (float)iRANDOM_RANGE;
}

/**
	@brief	
	@date	2005/08/20	junjunn 쐬
*/
void KnuthRandom::init(long lSeed)
{
	m_aiBuffer[iTABLE_SIZE] = lSeed;
	long r = 1;
	int i;
	for (i=1;i<iTABLE_SIZE;i++) 
	{
		int iPos = (iTABLE_SEED * i) % iTABLE_SIZE;
		m_aiBuffer[iPos] = r;
		r = lSeed - r;
		if (r < 0) r += iRANDOM_RANGE;
		lSeed = m_aiBuffer[iPos];
	}

//ŏɓ]B
	for (i=0;i<3;i++)		randomize();
	m_iCurPos = iTABLE_SIZE;
}

/**
	@brief	_
	@date	2005/08/20	junjunn 쐬
*/
void KnuthRandom::randomize()
{
	int i;
	for (i = 1; i <= iTABLE_MID_SIZE; i++) 
	{
		int r = m_aiBuffer[i] - m_aiBuffer[i + iTABLE_MID_SIZE+7];
		if (r < 0) r += iRANDOM_RANGE;
		m_aiBuffer[i] = r;
	}
	for (i = iTABLE_MID_SIZE+1; i <= iTABLE_SIZE; i++) 
	{
		int r = m_aiBuffer[i] - m_aiBuffer[i - iTABLE_MID_SIZE];
		if (r < 0) r += iRANDOM_RANGE;
		m_aiBuffer[i] = r;
	}
}

/**
	@brief	intoB
	@date	2005/08/20	junjunn 쐬
*/
long KnuthRandom::getInt()
{
	if (++m_iCurPos > iTABLE_SIZE) 
	{
		randomize();
		m_iCurPos = 1;  
	}
	return m_aiBuffer[m_iCurPos];
}

/**
	@brief	floatoB
	@date	2005/08/20	junjunn 쐬
*/
double KnuthRandom::getFloat()
{
	return (1.0 / iRANDOM_RANGE) * getInt();
}

}		//namespace monapi2
