/*!
    \file  AbstractMonic.cpp
    \brief NICNX

    Copyright (c) 2004 Yamami
    WITHOUT ANY WARRANTY

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/09/04 update:$Date: 2005/12/13 09:00:45 $
*/


/*! \class AbstractMonic
 *  \brief NICNX
 */


//#include "AbstractMonic.h"
#include <AbstractMonic.h>

using namespace MonAPI;

/*!
    \brief AbstractMonic RXgN^

    \author Yamami
    \date   create:2004/09/04 update:
*/
AbstractMonic::AbstractMonic()
{
    waitFrameBufList = new HList<WAIT_FRAME_BUF*>();
}


/*!
    \brief AbstractMonic fXNgN^

    \author Yamami
    \date   create:2004/09/04 update:
*/
AbstractMonic::~AbstractMonic()
{
    //
}


/*!
    \brief disable netRecv interrupt

    \author Yamami
    \date   create:2004/08/08 update:
*/
void AbstractMonic::disableNetWork() 
{

    byte IrqMask;
    int  nicIrqNo;
    
    IrqMask = 0x00;
    
    //qNX̃Qb^[ŁAIRQ擾
    nicIrqNo = getNicIRQ();
    
    if(0 <= nicIrqNo && nicIrqNo <= 7){
        //IRQ͈̔͂A0`7ł
        //PIC-0}X^IMR(0x21)֊荞݃}XN
        IrqMask = 1 << (nicIrqNo - 0);
        outp8(0x21, (inp8(0x21) | IrqMask));
    }
    else if(8 <= nicIrqNo && nicIrqNo <= 15){
    
        //IRQ͈̔͂A8`15ł
        //PIC-1X[uIMR(0xA1)֊荞݃}XN
        IrqMask = 1 << (nicIrqNo - 8);
        outp8(0xA1, (inp8(0xA1) | IrqMask));
    
    }
    
}


/*!
    \brief enable netRecv interrupt

    \author Yamami
    \date   create:2004/08/08 update:
*/
void AbstractMonic::enableNetWork() 
{

    byte IrqMask;
    int  nicIrqNo;
    
    IrqMask = 0xFF;

    //qNX̃Qb^[ŁAIRQ擾
    nicIrqNo = getNicIRQ();

    if(0 <= nicIrqNo && nicIrqNo <= 7){
        //IRQ͈̔͂A0`7ł
        //PIC-0}X^IMR(0x21)֊荞݃}XN
        IrqMask = IrqMask ^ (1 << (nicIrqNo - 0));  //XOR Yrbĝ0ƂB
        outp8(0x21, (inp8(0x21) & IrqMask));
    }
    else if(8 <= nicIrqNo && nicIrqNo <= 15){
    
        //IRQ̃JXP[h}XN
        outp8(0x21, (inp8(0x21) & 0xFB)); /* IR2 cascade */
    
        //IRQ͈̔͂A8`15ł
        //PIC-1X[uIMR(0xA1)֊荞݃}XN
        IrqMask = IrqMask ^ (1 << (nicIrqNo - 8));  //XOR Yrbĝ0ƂB
        outp8(0xA1, (inp8(0xA1) & IrqMask));
    }
    
}

/*!
    \brief t[M 

    \author Yamami
    \date   create:2005/05/22 update:
*/
void AbstractMonic::frame_input_public() 
{

    //t[M H/W qNXֈϏ
    //frame_buf[1500] ֊i[鎖
    frame_input();
    
    
    //҂Xg֓o^
    //TCY̋LmۂAۑBnhXg֓o^
    //܂Amonapi_cmemoryinfo\̂new
    monapi_cmemoryinfo* cmInfo = new monapi_cmemoryinfo();
    
    if (!monapi_cmemoryinfo_create(cmInfo, frame_len , 0)){
        monapi_cmemoryinfo_delete(cmInfo);
        //TODO mۂłȂǂH
        return;
    }
    
    //L}bvADatavfɊmۂoCg񂪃ZbgB
    monapi_cmemoryinfo_map(cmInfo);
    
    //LցApPbgZbg
    memcpy(cmInfo->Data , frame_buf, frame_len);
    
    //Xg֓o^
    WAIT_FRAME_BUF *addWork = new WAIT_FRAME_BUF();
    addWork->cmHandle = cmInfo->Handle;
    addWork->cmSize = cmInfo->Size;
    
    waitFrameBufList->add(addWork);
    
    //vgRw֏vbZ[WM
    dword targetID = Message::lookupMainThread("MONES.EX5");
    if (targetID == 0xFFFFFFFF){
        //TODO łȂǂH
    }

    MessageInfo info;
    Message::create(&info, MSG_MONES_FRAME_REQ, 0, 0, 0, NULL);

    // send
    if (Message::send(targetID, &info)) {
        //TODO łȂǂH
    }
    

}
