/**
	@file	Bitmap.cpp
	@brief		rbg}bv̎舵EB

	rbg}bv̎舵EB

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 14:00:34 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifdef MONA
	#include <monapi.h>
#endif

#include "Bitmap.h"
#include "../Basic/File.h"
#include "../Basic/Debug.h"
#include "../Basic/Memory.h"
#include "Size.h"

namespace monapi2	{

#define ASSERT_PIXEL(x,y)	ASSERT(x>=0 && x<m_oSize.getWidth() && y>=0 && y<m_oSize.getHeight());

	
	

//.bmpt@C̋KiBÂKîߍgĂȂoSɗȂo
//ł͂.bmp`ɓK͂ȂBgȂo͑SB
//ߋׂ݊̈̃t@Co͂ɎgB

/**
rbg}bvɂĂ̏B

	@date	2005/08/20	junjunn 쐬
*/
class BitmapInfoHeader
{
public:
	void set(const byte* p)
	{
		m_iWidth	=*(dword*)(p+0x04);
		m_iHeight	=*(dword*)(p+0x08);
		m_wBitFormat=* (word*)(p+0x0E);
	}


public:
//	dword	m_dwSizeStructure;		///<̍\̂̃TCYBӖo[WɎgB
	int		m_iWidth;				///<BuintȂintȂ̂̓}CiXlƏ㉺]BMP𐶐ӖƂlB
	int		m_iHeight;				///<B
//	word	m_wPlanes;				///<sgpB1B
	word	m_wBitFormat;			///<rbgtH[}bgB1,4,8,16,24,32ȂǂB
//	dword	m_dwCompression;		///<k@Bʂ͕sgpB
//	dword	m_dwSize;				///<C[W̃TCYBkĂƂ̉𓀌̑傫Ɏgʂ͕sgpB
//	long	m_lXPelsPerMeter;		///<𑜓xBʂ͕sgpB
//	long	m_lYPelsPerMeter;		///<𑜓xBʂ͕sgpB
//	dword	m_dwClrUsed;			///<ۂɎgĂFBʂ͕sgpB
//	dword	m_dwClrImportant;		///<dvȐFBʂ͕sgpB
}; 

//FwBpbgɎgB
/**
	@date	2005/08/20	junjunn 쐬
*/
struct RGBQuad
{
	byte	r; 
	byte	g; 
	byte	b;
	byte	m_byReserved; 
}; 

//rbg}bv+pbgf[^B24rbgȂpbgȂ̂Ńpbgf[^͖B
/**
	@date	2005/08/20	junjunn 쐬
*/
struct BitmapInfo
{
	BitmapInfoHeader	m_BitmapInfoHeader;
	RGBQuad*			m_RGBQuad;	//rbg}bv̐FrbgɉĕKvȕIɊmۂB
};

//rbg}bvt@Cwb_[B
/**
	@date	2005/08/20	junjunn 쐬
*/
struct BitmapFileHeader
{
public:
	void set(const byte* p)	
	{
		m_dwSize		=*(dword*)(p+0x02);
		m_dwOffsetToData=*(dword*)(p+0x0A);
	}
	int getDataSize()	{return m_dwSize-m_dwOffsetToData;};		//f[^{̂̑傫B

public:
//	word	m_wType;			///<t@C^CvʁB"BM"B
	dword	m_dwSize;			///<t@C̑傫B
//	word	m_wReserved1;		///<sgpB
//	word	m_wReserved2;		///<sgpB
	dword	m_dwOffsetToData;	///<t@C擪f[^{̂܂ł̃rbgB
}; 


//Bitmap/////////////////
/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::init()
{
	m_oSize.set(0,0);

//	m_strPath.empty();
	m_bufferData.clear();

	m_bYReverse = false;

//	m_strPath = "Bitmap.bmp";
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::clear()
{
	init();
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/09/20	junjunn 쐬
*/
byte* Bitmap::createCanvas(const Size* cpSize)
{
	return createCanvas(cpSize->getWidth(),cpSize->getHeight());
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
	@date	2005/09/20	junjunn createCanvas疼OύXB
*/
byte* Bitmap::createCanvas(int iWidth,int iHeight)
{
	return getNewBuffer(iWidth,iHeight);
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
byte* Bitmap::getNewBuffer(int iWidth,int iHeight)
{
	clear();

	m_oSize.set(iWidth,iHeight);
	setLineBits();

	return m_bufferData.extendBuffer(m_iLineSize * iHeight);
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::setLineBits()
{
	m_iLineSize = getBMPLineSize(m_oSize.getWidth());
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::copy(const Bitmap* cpBitmap)
{
	if (! cpBitmap->isValid())	return;

	clear();

	m_oSize = cpBitmap->m_oSize;
	m_bufferData.copy(&cpBitmap->m_bufferData);
}

byte* Bitmap::getPixelBuffer()
{
	return m_bufferData.getBuffer();
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
byte* Bitmap::getPixelBuffer(int x,int y)
{
	int iOffset = (m_oSize.getHeight() - y - 1)*m_iLineSize + x*3;
	return m_bufferData.getBuffer() + iOffset;
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
const byte* Bitmap::getPixelBufferConst(int x,int y) const
{
	int iOffset = (m_oSize.getHeight() - y - 1) * m_iLineSize + x*3;
	return m_bufferData.getData() + iOffset;
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/10/03	junjunn 쐬
*/
const byte* Bitmap::getPixelBufferConst() const
{
	return m_bufferData.getData();
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
colort Bitmap::getPixel(int x,int y) const
{
	const byte* cpBaseByte = getPixelBufferConst(x,y);
//BGRɕłB
	return makeColor(cpBaseByte[2],cpBaseByte[1],cpBaseByte[0]);
}


/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::setPixel(int x,int y,colort color)
{
//	ASSERT_PIXEL(x,y);

	byte* pBaseByte = getPixelBuffer(x,y);

	pBaseByte[0] = getBValue(color);
	pBaseByte[1] = getGValue(color);
	pBaseByte[2] = getRValue(color);
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::fill(colort color)
{
	byte* p = getPixelBuffer();
//dword]ł͍Ō̈̓obt@̊OɏoĂ܂̂ŁB
	for (int i=0;i<(m_oSize.getWidth()*m_oSize.getHeight())-1;i++)
	{
		*(dword*)p = color;
		p+=3;
	}

	setPixel(m_oSize.getWidth()-1,m_oSize.getHeight()-1,color);
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
	@date	2005/10/03	junjunn Y]@\tB
*/
bool Bitmap::read(cpchar1 cszPath,bool bReverseY)
{
	File file;
	if (! file.open(cszPath))		return false;

//BMPt@Cwb_̓ǂݍ
	int iRead=0;
	BitmapFileHeader bitmapFileHeader;
	BitmapInfoHeader bitmapInfoHeader;

	byte abyBuffer[100];
	iRead+=file.read(abyBuffer,iRead,14);
	bitmapFileHeader.set(abyBuffer);

	iRead+=file.read(abyBuffer,iRead,40);
	bitmapInfoHeader.set(abyBuffer);

//_ł24rbgȊO͑ΉĂȂB
	if (bitmapInfoHeader.m_wBitFormat != 24)		return false;
//	ASSERT(m_oSize.getWidth()>0 && m_oSize.getHeight()>0);

//BݒB
//	m_strPath = cszPath;
	byte* pBuffer = createCanvas(bitmapInfoHeader.m_iWidth,bitmapInfoHeader.m_iHeight);


	m_bYReverse = bReverseY;

//ǂݍ݁B
	int iDataStart = bitmapFileHeader.m_dwOffsetToData;
	for (int y=0;y<getHeight();y++)
	{
//Y]@\BVRAMȂǂ.bmpƋtɏォ牺Ƀf[^̂Ŕ]Ăƕ֗ȏꍇB
		int y2 = (! bReverseY)?y:(getHeight()-y-1);

		int iOffsetYSource = y * getLineDataSize();
		int iOffsetYTarget = y2 * getLineDataSize();
		file.read(pBuffer + iOffsetYTarget,iDataStart + iOffsetYSource,getLineDataSize());
	}

	return true;
}

/**
	@brief	Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Bitmap::write(cpchar1 cszPath) const
{
//	ASSERT(m_iBitCount==8 || m_iBitCount==24);

const int iBMP_HEADER_SIZE = 0x36;

//54oCg
	byte abyHeader[] = {
0x42,0x4D,				//00:t@C̎ID
0x36,0x10,0x0E,0x00,	//02:TCYBB640*480*24 = E10000BɃwb_[ 
0x00,0x00,				//06:ŒB0
0x00,0x00,				//08:ŒB0
0x36,0x00,0x00,0x00,	//0A:摜f[^{̂ւ̃ItZbg

0x28,0x00,0x00,0x00,	//0E:ŒBwb_[TCY
0x80,0x02,0x00,0x00,	//12:m_nWidth.			
0xE0,0x01,0x00,0x00,	//16:biHeight.			
0x01,0x00,				//1A:biPlanes.			ŒBJ[v[
0x18,0x00,				//1C:m_wBitFormat.		J[rbg
0x00,0x00,0x00,0x00,	//1E:biCompression.		ŒBkXL[(0=Ȃj
0x00,0x10,0x0E,0x00,	//22:biSizeImage.		摜̃TCYik̂݁j
0x13,0x0B,0x00,0x00,	//26:biXPelsPerMeter.	ŒB𑜓x
0x13,0x0B,0x00,0x00,	//2A:biYPelsPerMeter.	ŒB𑜓x
0x00,0x00,0x00,0x00,	//2E:biClrUsed.			ŒBF
0x00,0x00,0x00,0x00};	//32:biClrImportant.	ŒBKvȐFi݂͎gpĂȂ)


	int* piSize		= (int*) (abyHeader + 2);
	int* piMainDataOffset = (int*) (abyHeader + 10);
	int* piWidth	= (int*) (abyHeader + 18);
	int* piHeight	= (int*) (abyHeader + 22);
	int* piBitCount	= (int*) (abyHeader + 28);

	int iSize=0;
	int iMainDataOffset=0;

	iSize = m_iLineSize * m_oSize.getHeight() + iBMP_HEADER_SIZE;
	iMainDataOffset = iBMP_HEADER_SIZE;

	*piSize = iSize;
	*piMainDataOffset = iMainDataOffset;
	*piWidth			= m_oSize.getWidth();
	*piHeight			= m_oSize.getHeight();
	*piBitCount			= 24;

	File file(cszPath,true);
	int iWrite=0;
	iWrite += file.write(abyHeader,iWrite,sizeof(abyHeader));
	iWrite += file.write(m_bufferData.getData(),iWrite,m_bufferData.getSize());
}


//̑֐////////////////
/**
	@date	2005/08/20	junjunn 쐬
*/
int	getBMPLineSize(int iWidth)
{
//es̑傫4oCgPʂłȂĂ͂ȂȂ̂ŕKvȂoCgǉB
	int iLineSize = 3 * iWidth;

	int iExcess = iLineSize % 4;
	if (iExcess != 0)
	{
		iLineSize += (4-iExcess);
	}

	return iLineSize;
}


}	// namespace monapi2
