/**
	@file	Time.h
	@brief	EԊ֘A

	EԊ֘A

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_TIME_H
#define _MONAPI2_BASIC_TIME_H

#include "Switch.h"
#include "Type.h"

namespace monapi2	{

/**
	@brief	ԁE舵BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
class Time
{
public:
//\z
	Time()						{init();}
	Time(const Time* cpTime)	{set(cpTime);}
	Time(int iSecondCount)		{set(iSecondCount);}
	Time(int iYear,int iMonth,int iDay,int iHour,int iMinute,int iSecond)	{set(iYear,iMonth,iDay,iHour,iMinute,iSecond);}

//擾
	static int getCurrentSecondCount();

	int getYear()		const{return m_iYear;}			///<N𓾂
	int getMonth()		const{return m_iMonth;}			///<𓾂
	int getDay()		const{return m_iDay;}			///<𓾂
	int getHour()		const{return m_iHour;}			///<𓾂
	int getMinute()		const{return m_iMinute;}		///<𓾂
	int getSecond()		const{return m_iSecond;}		///<b𓾂
	int getDayOfWeek()	const{return m_iDayOfWeek;}		///<jB0=jB
	int getSecondCount()const{return m_iSecondCount;}	///<b𓾂

	bool isEqual(const Time* cpTime);
	bool operator ==(const Time& crefTime)	{return isEqual(&crefTime);}
	bool operator !=(const Time& crefTime)	{return ! (isEqual(&crefTime));}
	bool isBefore(const Time* cpTime,bool bAllowEqual=false)	{return  (bAllowEqual)?((getSecondCount()) <= (cpTime->getSecondCount())):(getSecondCount() < cpTime->getSecondCount());}
	bool operator <(const Time& crefTime)	{return isBefore(&crefTime,false);}
	bool operator <=(const Time& crefTime)	{return isBefore(&crefTime,true);}
	bool isAfter(const Time* cpTime,bool bAllowEqual=false)		{return  (bAllowEqual)?(getSecondCount() >= cpTime->getSecondCount()):(getSecondCount() > cpTime->getSecondCount());}
	bool operator >(const Time& crefTime)	{return isAfter(&crefTime,false);}
	bool operator >=(const Time& crefTime)	{return isAfter(&crefTime,true);}
	int compare(const Time* cpTime)			{return getSecondCount() - cpTime->getSecondCount();}

	Time add(int iSecondCount)			{return Time(getSecondCount()+iSecondCount);}
	Time operator +(int iSecondCount)	{return add(iSecondCount);}
	Time subtract(int iSecondCount)		{return Time(getSecondCount()-iSecondCount);}
	Time operator -(int iSecondCount)	{return subtract(iSecondCount);}

//
	void set(int iSecondCount);						///<bJEgZbgYMDhmsɕϊB
	void operator =(int iSecondCount)	{set(iSecondCount);}
	void set(const Time* cpTime);
	void operator = (const Time& crefTime)	{set(&crefTime);}
	void set(int iYear,int iMonth,int iDay,int iHour,int iMinute,int iSecond);

	void addSelf(int iSecondCount)		{set(getSecondCount()+iSecondCount);}
	void operator +=(int iSecondCount)	{addSelf(iSecondCount);}
	void subtractSelf(int iSecondCount)	{set(getSecondCount()-iSecondCount);}
	void operator -=(int iSecondCount)	{subtractSelf(iSecondCount);}

protected:
///N̒̓JEg猎Ɠ߂B
	void getMonthAndDay(int iDayInYear,int* piMonth,int* piDay);

///1970iYear,iMonth܂ł̉[N̉񐔂߂B
	int getLeapYearCountSince1970(int iYear,int iMonth);

///
	void init();

protected:
	int m_iYear;
	int m_iMonth;
	int m_iDay;
	int m_iDayOfWeek;
	int m_iHour;
	int m_iMinute;
	int m_iSecond;
	int m_iDayCountInYear;		//N̒̃g[^
	int m_iSecondCount;			//1970N11̑bB
};

/**
	@brief	_Ԃ̎vBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
class TimeMeasure
{
public:
	void start();
	uint finish();

protected:
	uint m_nTick;
};

}	//namespace monapi2

#endif
