/**
	@file	Time.h
	@brief	EԊ֘A

	EԊ֘A

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#include "Debug.h"
#include "Time.h"
#include "Math.h"

#ifdef MONA
	#include <monapi/syscall.h>
#endif

namespace monapi2
{

//ꂼ̌Ɏ܂ł̑
//31.28.31.30.31.30.31.31,30.31.30.31
int g_aiCumulativeMonthDayCount[] = {0,31,59,90,120,151,181,212,243,273,304,334,365};


/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Time::init()
{
	m_iYear		= 0;
	m_iMonth	= 0;
	m_iDay		= 0;
	m_iDayOfWeek= 0;
	m_iHour		= 0;
	m_iMinute	= 0;
	m_iSecond	= 0;
	m_iDayCountInYear =0;
	m_iSecondCount	= 0;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
bool Time::isEqual(const Time* cpTime)
{
	return (
	m_iYear		== cpTime->getYear()				&&
	m_iMonth	== cpTime->getMonth()				&&
	m_iDay		== cpTime->getDay()					&&
	m_iDayOfWeek== cpTime->getDayOfWeek()			&&
	m_iHour		== cpTime->getHour()				&&
	m_iMinute	== cpTime->getMinute()				&&
	m_iSecond	== cpTime->getSecond()				&&
	m_iDayCountInYear ==cpTime->m_iDayCountInYear	&&
	m_iSecondCount	== cpTime->getSecondCount());
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int Time::getCurrentSecondCount()
{
	return 0;
}

/**
	@brief	1970N1100̑bNbɒBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Time::set(int iSecondCount)
{
//Ή
	if (iSecondCount<0)
	{
		init();
		return;
	}

//bJEgZbgB
	m_iSecondCount = iSecondCount;

//ꂼ̒Pʂ̕bϊȂǂĂB
	const uint cnMinuteSecond	= 60;
	const uint cnHourSecond		= cnMinuteSecond * 60;
	const uint cnDaySecond		= cnHourSecond * 24;
	const uint cn4YearDay		= 365 * 4+ 1;

//͖̓ɂ΂邵N͉[NBčŏ͂܂mȑ߂B
	int iDayCount;
	divide(iSecondCount,cnDaySecond	,&iDayCount,&iSecondCount);

//͗j߂B
	m_iDayOfWeek = iDayCount%7 + 4;
	if (m_iDayOfWeek>=7)	m_iDayOfWeek-=7;

//[N̂4NPʂ̑傫߂B
	int i4YearCount;	//4N̉񐔁B
	int iDayIn4Year;	//i4YearCountmodƂɎcB
	divide(iDayCount,cn4YearDay		,&i4YearCount,&iDayIn4Year);

//4N̒ŉN߂B
	int iYearIn4Year=3;
	m_iDayCountInYear = iDayIn4Year;
	int aiYearDiv[] = {0,365,730,1096,1461};	//ꂼ̔NɒB܂ł̑B1970ÑJEgȂ̂3Nڂɉ[NĂB
	for (int i=0;i<4;i++)
	{
		if (iDayIn4Year<aiYearDiv[i+1])			//ꂼ̔N̑ɗ甲B
		{
			iYearIn4Year = i;
			m_iDayCountInYear = iDayIn4Year - aiYearDiv[i];
			break;
		}
	}

//N߂B
	m_iYear = 1970 + i4YearCount*4 + iYearIn4Year;

//[NB4NɈB100Ŋ؂N͂ȂȂB400Ŋ؂N͗LɂȂB
	bool bLeapYear=false;
	if (m_iYear%4==0)
	{
		bLeapYear = true;
		if (m_iYear%100==0)
		{
			bLeapYear = false;
			if (m_iYear%400==0)
			{
				bLeapYear = true;
			}
		}
	}

//1N̒̑猎Ɠ߂B
	const int cnLeapDay = 59;	//229̓JEgB
//[𒼌B
	if (bLeapYear && m_iDayCountInYear==cnLeapDay)
	{
		m_iMonth=1;
		m_iDay=28;
	}
	else
	{
//[N菜B
		int iDayCountInYearNoLeap = m_iDayCountInYear;
		if (bLeapYear && m_iDayCountInYear>cnLeapDay)	iDayCountInYearNoLeap--;

		getMonthAndDay(iDayCountInYearNoLeap,&m_iMonth,&m_iDay);
	}

//c̕bƕƕbɂ킯B
	divide(iSecondCount,cnHourSecond	,&m_iHour,&iSecondCount);
	divide(iSecondCount,cnMinuteSecond	,&m_iMinute,&m_iSecond);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Time::set(const Time* cpTime)
{
	m_iYear		= cpTime->getYear();
	m_iMonth	= cpTime->getMonth();
	m_iDay		= cpTime->getDay();
	m_iDayOfWeek= cpTime->getDayOfWeek();
	m_iHour		= cpTime->getHour();
	m_iMinute	= cpTime->getMinute();
	m_iSecond	= cpTime->getSecond();
	m_iDayCountInYear =cpTime->m_iDayCountInYear;
	m_iSecondCount	= cpTime->getSecondCount();
}

/**
	@brief AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void Time::set(int iYear,int iMonth,int iDay,int iHour,int iMinute,int iSecond)
{
//1970N[NN񐔂߂B
	int iLeapYearCount = getLeapYearCountSince1970(iYear,iMonth);

//N̒̓{̒̓{{[N␳
	int iDayCount = (iYear-1970)*365 + g_aiCumulativeMonthDayCount[iMonth] + iDay + iLeapYearCount;

//̒̕b{̒̕b{̒̕b{bB
	int iSecondCount = iSecond + 60*(iMinute + 60*(iHour + 24*iDayCount));

//bZbgB
//@memo _ł͂xNb߂閳ʂȍƂEE
	set(iSecondCount);
}


//protected///////
/**
	@date	2005/08/20	junjunn 쐬
*/
void Time::getMonthAndDay(int m_iDayCountInYear,int* piMonth,int* piDay)
{
	for (int i=0;i<12;i++)
	{
		if (m_iDayCountInYear < g_aiCumulativeMonthDayCount[i+1])
		{
			*piMonth = i;
			*piDay = m_iDayCountInYear - g_aiCumulativeMonthDayCount[i];
			return;
		}
	}

//	ASSERT(0);		//ɂ͗Ȃ͂B
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int Time::getLeapYearCountSince1970(int iYear,int iMonth)
{
//0`iYearN܂ł̉[NCxgB
	int i4YearCount		= iYear/4;		//4Ŋ؂N͉[NB
	int i100YearCount	= iYear/100;	//100Ŋ؂N͗OŖB
	int i400YearCount	= iYear/400;	//400Ŋ؂N͂ɗOł̏ォLɂȂB

//0`1970N܂ł̉[NJEgB
	const int ciLeapYearCountUntil1970 = 477;

//1970Nȍ~̉[N̉񐔁B
	int iLeapYearCount = (i4YearCount-i100YearCount+i400YearCount) - ciLeapYearCountUntil1970;

//N̕B܂[NNO̓Ȃ̂Ɋ܂߂Ă܂P[XCB
	if (iYear%4==0 && iMonth<2)		iLeapYearCount--;

	return iLeapYearCount;
}

//TimeMeasureFn///////
#ifdef MONA
void TimeMeasure::start()
{
	m_nTick=syscall_get_tick();
}

uint TimeMeasure::finish()
{
	return syscall_get_tick()-m_nTick;
}

#endif	//#ifdef MONA

}		//namespace monapi2
