/**
	@file	Language.cpp
	@brief	ER[h

	ER[h

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifdef MONA
#include <monapi.h>
#endif

#include "Language.h"
#include "StringFn.h"
#include "Buffer.h"
#include "FileFn.h"


namespace monapi2	{

//UnicodeShiftJIS̕ϊ[`B
//xt@CǂލޏƂKvȂ̂ŃIuWFNgƂđ݂ĂB
CLanguageCodeConverter g_ShiftJISUnicodeConverter;

//ϊ̈B
Rect g_arectConversionShiftJIStoUnicode[5+1];
Rect g_arectConversionUnicodeShiftJISto[8+1];


//LanguageFn/////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertShiftJIStoUnicode(pcharv wszOut,cpchar1 cszIn,int iMaxInLen)
{
	if (cszIn==NULL || iMaxInLen==0)	return 0;

	pcharv	pWriteStart	= wszOut;
	pcharv	pWrite		= pWriteStart;
	cpchar1	pReadStart	= cszIn;
	cpchar1	pRead		= pReadStart;
	cpchar1	pReadEnd	= pRead + iMaxInLen;

	char1 c;
	while ((c=*pRead) != '\0')
	{
		if (CharFn::isASCII(c))
		{
			*pWrite = (charv)convertShiftJIStoUnicode(0,c);
			pRead++;
		}
		else
		{
			*pWrite = (charv)convertShiftJIStoUnicode(pRead[0],pRead[1]);
			pRead+=2;
		}
		pWrite++;

		if (iMaxInLen>=0 && pRead>=pReadEnd)		break;
	}

	*pWrite = '\0';
	return pWrite - pWriteStart;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertUnicodetoShiftJIS(pchar1 szOut,cpcharv cwszIn,int iMaxInLen)
{
	pchar1	pWriteStart	= szOut;
	pchar1	pWrite		= pWriteStart;
	cpcharv	pRead		= cwszIn;
	cpcharv	pReadEnd	= pRead + iMaxInLen;

	charv c;
	while ((c=*pRead) != '\0')
	{
		if (c<0x80)
		{
			*pWrite++ = (char1)convertUnicodetoShiftJIS((uint)c);
		}
		else
		{
			int iReturn = convertUnicodetoShiftJIS((uint)c);
			*pWrite++ = (char1)((iReturn & 0xFF00) >> 8);
			*pWrite++ = (char1)(iReturn & 0xFF);
		}

		pRead++;

		if (iMaxInLen>=0 && pRead>=pReadEnd)
			break;
	}

	*pWrite = '\0';
	return pWrite - pWriteStart;
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertShiftJIStoUnicode(Buffer* pbufOut,cpchar1 cszIn)
{
	int iSizeIn = StringFn::getLength(cszIn) + 1;
	
	pbufOut->extendBuffer(iSizeIn * 2);
	return convertShiftJIStoUnicode((pcharv)pbufOut->getBuffer(),cszIn);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertUnicodetoShiftJIS(Buffer* pbufOut,cpcharv cwszIn)
{
	int iSizeIn = (StringFn::getLength(cwszIn) + 1) * 2;

	pbufOut->extendBuffer(iSizeIn/2);
	return convertUnicodetoShiftJIS((pchar1)pbufOut->getBuffer(),cwszIn);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertShiftJIStoUnicode(int iSJISCode)
{
	return g_ShiftJISUnicodeConverter.convert1to2(iSJISCode);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertShiftJIStoUnicode(byte x,byte y)
{
	return g_ShiftJISUnicodeConverter.convert1to2(x,y);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertUnicodetoShiftJIS(int iUnicodeCode)
{
	return g_ShiftJISUnicodeConverter.convert2to1(iUnicodeCode);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
int LanguageFn::convertUnicodetoShiftJIS(byte x,byte y)
{
	return g_ShiftJISUnicodeConverter.convert2to1(x,y);
}

/**
	@brief	[ǂݍށB
	@date	2005/08/20	junjunn 쐬
*/
void LanguageFn::initRule()
{
	g_arectConversionShiftJIStoUnicode[0].setRectRB(0x00,0x00	,0x00 + 1,0xDF + 1);
	g_arectConversionShiftJIStoUnicode[1].setRectRB(0x81,0x40	,0x9F + 1,0xFC + 1);
	g_arectConversionShiftJIStoUnicode[2].setRectRB(0xE0,0x40	,0xEE + 1,0xFC + 1);
	g_arectConversionShiftJIStoUnicode[3].setRectRB(0xFA,0x40	,0xFB + 1,0xFC + 1);
	g_arectConversionShiftJIStoUnicode[4].setRectRB(-1,0,0,0);	//ԕ

	g_arectConversionUnicodeShiftJISto[0].setRectRB(0x00,0x00	,0x00 + 1,0xF7 + 1);
	g_arectConversionUnicodeShiftJISto[1].setRectRB(0x03,0x91	,0x03 + 1,0xC9 + 1);
	g_arectConversionUnicodeShiftJISto[2].setRectRB(0x04,0x01	,0x04 + 1,0x51 + 1);
	g_arectConversionUnicodeShiftJISto[3].setRectRB(0x20,0x00	,0x26 + 1,0xE9 + 1);
	g_arectConversionUnicodeShiftJISto[4].setRectRB(0x2F,0x00	,0x33 + 1,0xFE + 1);
	g_arectConversionUnicodeShiftJISto[5].setRectRB(0x4E,0x00	,0x9E + 1,0xFF + 1);
	g_arectConversionUnicodeShiftJISto[6].setRectRB(0xF9,0x0E	,0xFA + 1,0xDC + 1);
	g_arectConversionUnicodeShiftJISto[7].setRectRB(0xFF,0x01	,0xFF + 1,0xE5 + 1);
	g_arectConversionUnicodeShiftJISto[8].setRectRB(-1,0,0,0);	//ԕ

	g_ShiftJISUnicodeConverter.m_ConversionRule2Way.setShiftJISUnicode();
}

/**
	@brief	B
	@date	2005/08/20	junjunn 쐬
*/
bool LanguageFn::init(cpchar1 cszPathShiftJIStoUnicode)
{
	initRule();
	return g_ShiftJISUnicodeConverter.readTable(cszPathShiftJIStoUnicode);
}


//CLanguageCodeConverter///////////////
/**
	@date	2005/08/20	junjunn 쐬
*/
bool CLanguageCodeConverter::readTable(cpchar1 cszPath)
{
//łɕϊf[^ǂݍł̂ŉ邱ƂȂB
	if (m_bReady)	return true;

//t@Cǂݍ
	String strSource;
	if (! FileFn::read(cszPath,&strSource))	return false;

	cpchar1 pSource = strSource.getString();

//1221̓
	for (int iConversionWay=0;iConversionWay<2;iConversionWay++)
	{
		CConversionRule* pConversionRule = &m_ConversionRule2Way.m_aConversionRule[iConversionWay];

//SĂ̗̈B
		for (int iRuleRect=0;;iRuleRect++)
		{
			Rect* pRect = &pConversionRule->m_parectConversion[iRuleRect];
			if (pRect->getLeft() < 0)	break;		//ԕ

//̈m
			word* awBuffer = new word[pRect->getArea()];
			m_arrayPWordConversionData[iConversionWay].add(awBuffer);

//awTable_UnicodetoShiftJIS_0_224_0_1Ȃǂ̃e[uTB
			char szTableName[64];
			getCGenerateConversionCodeTableName(szTableName,pConversionRule,iRuleRect);
			cpchar1 pTableNamePos = StringFn::find(pSource,szTableName);
			if (pTableNamePos==NULL)		continue;
//{T
			cpchar1 pBracketLeft = StringFn::find(pTableNamePos,'{');
			if (pBracketLeft==NULL)			continue;
//e[u̍ŏ̃Gg[B0xŎn܂镶TB
			cpchar1 pTableElementStart = StringFn::find(pBracketLeft,"0x");
			if (pTableElementStart==NULL)	continue;

			cpchar1 p = pTableElementStart;

//ɑ0x`ǂݍށB
			for (int iCount=0;;iCount++)
			{
				if (p[0]!='0' && p[1]!='x')		break;
				int iInt = StringFn::toInt(p+2,16,&p);

				awBuffer[iCount] = (word)iInt;

				p++;	//','XLbv
				while (*p=='\n')	p++;	//sXLbvB
				while (*p=='\t')	p++;	//^uXLbvB
				if (*p=='}')	break;		//IB
			}
		}
	}

	m_bReady=true;

	return true;
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int CLanguageCodeConverter::convert1to2(int iCode1)
{
	return convert1to2((char1)((iCode1 & 0xFF00)>>8),(char1)(iCode1 & 0xFF));
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int CLanguageCodeConverter::convert1to2(byte x,byte y)
{
	return convert(x,y,0);
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int CLanguageCodeConverter::convert(byte x,byte y,int i1to2)
{
	if (! isReady())	return 0;

	CConversionRule* pConversionRule = &m_ConversionRule2Way.m_aConversionRule[i1to2];

//SĂ̗̈B
	for (int iRuleRect=0;;iRuleRect++)
	{
		Rect* pRect = &pConversionRule->m_parectConversion[iRuleRect];
		if (pRect->getLeft() < 0)	break;		//ԕ
//̈ɂȂ
		if (pRect->isPointInside(x,y))
		{
			word* awConversionTable = m_arrayPWordConversionData[i1to2].getAt(iRuleRect);
			int iReturn = awConversionTable[(y-pRect->getTop()) + pRect->getHeight()*(x - pRect->getLeft())];

			return iReturn;
		}
	}

	return 0;
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int CLanguageCodeConverter::convert2to1(int iCode2)
{
	return convert2to1((char1)((iCode2 & 0xFF00)>>8),(char1)(iCode2 & 0xFF));
}

/**
	@date	2005/08/20	junjunn 쐬
*/
int CLanguageCodeConverter::convert2to1(byte x,byte y)
{
	return convert(x,y,1);
}

/**
	@date	2005/08/20	junjunn 쐬
*/
void CConversionRule2Way::setShiftJISUnicode()
{
	m_aConversionRule[0].set("ShiftJIStoUnicode",g_arectConversionShiftJIStoUnicode);
	m_aConversionRule[1].set("UnicodetoShiftJIS",g_arectConversionUnicodeShiftJISto);
}

/**
	@date	2005/08/20	junjunn 쐬
*/
void getCGenerateConversionCodeTableName(pchar1 szOut,CConversionRule* pConversionRule,int iIndex)
{
	Rect* pRect = &pConversionRule->m_parectConversion[iIndex];

	StringFn::format(szOut,
		"awTable_%s_%2X_%2X_%2X_%2X",
		pConversionRule->m_strName.getString(),pRect->getLeft(),pRect->getTop(),pRect->getRight(),pRect->getBottom());
}

}	//namespace monapi2
