/**
	@file	FileOther.h
	@brief	t@C[eBeB

	t@CEt@CEt@C[eBeB

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_FILEOTHER_H
#define _MONAPI2_BASIC_FILEOTHER_H

#include "switch.h"
#include "Type.h"
#include "FileFn.h"
#include "String.h"
#include "CollectionArray.h"

namespace monapi2	{

/**
"C:/aaa/bbb/ccc/ddd.txt"Ȃǂ"C:/aaa/bbb/ccc""ddd.txt"ɕB.

@par gF
@code
{IȎgF

//\z
	CSplitPath SplitPath("C:/aaa/bbb/ccc/ddd.txt");


//gp
	cpchar1 cszDir		= SplitPath.GetDir();		//=="C:/aaa/bbb/ccc"
	cpchar1 cszFilename	= SplitPath.GetFilename();	//=="ddd.txt"
@endcode

	@date	2005/08/20	junjunn 쐬
*/

class SplitPath
{
//\bh
public:
///@name 
//@{
	SplitPath()					{init();}					///<RXgN^
	SplitPath(cpchar1 cszPath)	{set(cszPath);}				///<RXgN^
	void init();											///<
//@}


///@name Zbg
//@{
	void set(cpchar1 cszPath);								///<Zbg
//@}

///@name 擾
//@{
	cpchar1 getDirectory()	const {return m_szDirectory;}	///<fBNgԂ
	cpchar1 getFilename()	const {return m_szFilename;}	///<t@CԂ
//@}


//o
protected:
	char1 m_szDirectory[g_iMAX_PATH];								///<fBNg
	char1 m_szFilename[g_iMAX_PATH];							///<t@C
};


/**
"test.txt"Ȃǂ"test""txt"ɕB.

@par gF
@code
{IȎgF

//\z
	CSplitFilename SplitFilename("test.txt");


//gp
	cpchar1 cszDir		= SplitFilename.GetName();		//=="test"
	cpchar1 cszFilename	= SplitFilename.GetExtension();	//=="txt"
@endcode

	@date	2005/08/20	junjunn 쐬
*/
class SplitFilename
{
//\bh
public:
///@name 
//@{
	SplitFilename()						{init();}				///<RXgN^
	SplitFilename(cpchar1 cszFilename)	{set(cszFilename);}		///<RXgN^
	void init();												///<B
//@}


///@name 擾
//@{
	cpchar1 getName()		const {return m_szName;}			///<OԂ
	cpchar1 getExtension()	const {return m_szExtension;}		///<gqԂ
//@}

//
	void set(cpchar1 cszFilename);								///<Zbg

//o
protected:
	char1 m_szName[g_iMAX_PATH];								///<O
	char1 m_szExtension[g_iMAX_PATH];							///<gq
};



/**
	@brief	fBNgXLĒg񋓁BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/

//P̃t@C
class FileProperty
{
public:
	cpchar1 getName()	const {return m_strName;}
	cpchar1 getPath()	const {return m_strPath;}
	int getSize()		const {return m_iSize;}
	bool isDirectory()	const {return m_bDirectory;}


public:
	String m_strName;			///<O
	String m_strPath;			///<pX
	bool m_bDirectory;			///<trueȂfBNgAfalseȂt@CB
	int m_iSize;				///<TCY
};

class ScanDirectory
{
//\[g͖Cvg
	enum ESortBy
	{
		SORTBY_NONE,
		SORTBY_NAME,
		SORTBY_EXTENSION,
		SORTBY_LASTMODIFIEDTIME,
	};

public:
	ScanDirectory(cpchar1 cszPath,bool bIncludeFile,bool bIncludeDirectory,enum ESortBy eSortBy=SORTBY_NONE);
	ScanDirectory()	{init();}

	cpchar1 getNameAt(int iIndex) const;
	cpchar1 getPathAt(int iIndex) const;
	FileProperty* getFilePropertyAt(int iIndex);
	int getCount()						{return m_iCount;}

	void scan(cpchar1 cszPath,bool bIncludeFile,bool bIncludeDirectory,enum ESortBy eSortBy=SORTBY_NONE);


protected:
	void init();
	bool assertIndex(int iIndex) const	{return (iIndex>=0 && iIndex<m_iCount);}


protected:
	int m_iCount;
	String m_strPathBase;			///<ݒTĂfBNg̃pXB

	ArrayAD<FileProperty*> m_oArrayPFileProperty;
};

}	//namespace monapi2

#endif
