/**
	@file	FileOther.h
	@brief	t@C[eBeB

	t@CEt@CEt@C[eBeB

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifdef MONA
	#include <monapi.h>
	#include <monapi/messages.h>
#endif

#include "Math.h"
#include "FileOther.h"
#include "StringFn.h"

namespace monapi2	{

//SplitPath//////////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void SplitPath::init()
{
	StringFn::empty(m_szDirectory);
	StringFn::empty(m_szFilename);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void SplitPath::set(cpchar1 cszPath)
{
	init();

//ԉE̋؂
	cpchar1 pDivYen = StringFn::findReverse(cszPath,'\\');
//ł
	cpchar1 pDivSlash = StringFn::findReverse(cszPath,'/');

	cpchar1 pDiv = getMax(pDivYen,pDivSlash);

//ʂɌ
	if (pDiv)
	{
		StringFn::copy(m_szDirectory,cszPath,pDiv - cszPath);
		StringFn::copy(m_szFilename	,pDiv+1);
	}
	else
	{
//Ȃcszt@CfBNgǂ炩𐄑B
		pchar1 pDestination = StringFn::find(cszPath,'.')?m_szFilename:m_szDirectory;
		StringFn::copy(pDestination,cszPath);
	}
}

//SplitFilename//////////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void SplitFilename::init()
{
	StringFn::empty(m_szName);
	StringFn::empty(m_szExtension);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void SplitFilename::set(cpchar1 cszFilename)
{
//OƊgqɕ
	cpchar1 pDiv = StringFn::findReverse(cszFilename,'.');

	if (pDiv)
	{
		int iLengthLeft = pDiv - cszFilename;
		StringFn::copy(m_szName,cszFilename,iLengthLeft);
		StringFn::copy(m_szExtension,pDiv + 1);

#ifdef _WIN32
//NV[gJbg̏ꍇaaa.txt.lnk̂悤Ȍ`Ȃ̂aaa.txtɕł悤iKׂ
		if (StringFn::isEqual(m_szExtension,"lnk"))
		{
			char1 szFilenameCp[g_iMAX_PATH];
			StringFn::copy(szFilenameCp,cszFilename);		//Rs[
			*(szFilenameCp + iLengthLeft)='\0';				//.̏ꏊ\0Zbg

			SplitFilename SF2(szFilenameCp);				//񒧐
			StringFn::copy(m_szName		,SF2.getName());
			StringFn::copy(m_szExtension,SF2.getExtension());
		}
#endif
	}
//ۂƖOɂB
	else
	{
		StringFn::copy(m_szName,cszFilename);
	}
}

#ifdef MONA
//ScanDirectory///////
/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
ScanDirectory::ScanDirectory(cpchar1 cszPath,bool includeFile,bool includeDirectory,ESortBy eSortBy)
{
	scan(cszPath,includeFile,includeDirectory,eSortBy);
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
void ScanDirectory::init()
{
	m_iCount = 0;
	m_oArrayPFileProperty.removeAll();
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/10/12	junjunn 쐬
*/
void ScanDirectory::scan(cpchar1 cszPath,bool bIncludeFile,bool bIncludeDirectory,ESortBy /*eSortBy*/)
{
	init();
	m_strPathBase = cszPath;

	monapi_cmemoryinfo* pMemoryInfo = monapi_call_file_read_directory(cszPath,MONAPI_FALSE);

	if (! pMemoryInfo)		return;
	int iCount = *(int*)pMemoryInfo->Data;
	if (iCount == 0)		return;

	monapi_directoryinfo* pDirectoryInfo = (monapi_directoryinfo*)(pMemoryInfo->Data + sizeof(int));
	for (int i=0;i<iCount;i++) 
	{
		cpchar1 cszName = pDirectoryInfo->name;
		if (!StringFn::isEqual(cszName,".") &&	!StringFn::isEqual(cszName,".."))
		{
			bool bDirectory = (pDirectoryInfo->attr & ATTRIBUTE_DIRECTORY);

			if (
				(bIncludeFile && !bDirectory) ||
				(bIncludeDirectory && bDirectory)
				)
			{
				FileProperty* pFileProperty = new FileProperty;
				pFileProperty->m_strName	= cszName;
				pFileProperty->m_bDirectory = bDirectory;
				pFileProperty->m_iSize		= pDirectoryInfo->size;

				if (m_strPathBase.isEqual("/"))
					pFileProperty->m_strPath.format("/%s",cszName);
				else
					pFileProperty->m_strPath.format("%s/%s",m_strPathBase.getString(),cszName);

				m_oArrayPFileProperty.add(pFileProperty);
				m_iCount++;
			}
		}
		pDirectoryInfo++;
	}
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/10/12	junjunn 쐬
*/
cpchar1 ScanDirectory::getNameAt(int iIndex) const
{
	if (! assertIndex(iIndex)) return NULL;

	return m_oArrayPFileProperty.getAt(iIndex)->getName();
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
cpchar1 ScanDirectory::getPathAt(int iIndex) const
{
	if (! assertIndex(iIndex)) return NULL;

	return m_oArrayPFileProperty.getAt(iIndex)->getPath();
}

/**
	@brief	AA߂lMonapi2t@XQƁB
	@date	2005/10/12	junjunn 쐬
*/
FileProperty* ScanDirectory::getFilePropertyAt(int iIndex)
{
	if (! assertIndex(iIndex)) return NULL;

	return m_oArrayPFileProperty.getAt(iIndex);
}

#endif	//ifdef MONA
}		//namespace monapi2
