/**
	@file	CollectionMap.h
	@brief	RNV }bv

	RNV }bv

	License=Mona License
	@version $Revision: 1.3 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_COLLECTIONMAP_H
#define _MONAPI2_BASIC_COLLECTIONMAP_H

#include "switch.h"
#include "Type.h"
#include "String.h"

#include "CollectionList.h"

namespace monapi2	{

//}bvn///////////////
/**
nbV֐

炱\nbV\֐N邩mȂ̂
ł͕W𐧒肷悤Ȏ͂ȂgetHash1ƃoG[VꂻȖO鎖ɂB

	@date	2005/08/20	junjunn 쐬
*/
uint getHash1(cpchar1 cszKey,uint nHashTableSize);
uint getHash1(int iKey,uint nHashTableSize);

/**
}bvnɎgpnbVe[ȗ傫B
	@date	2005/08/20	junjunn 쐬
*/
enum EPrimeNumber
{
	PRIME_ORDER_10			= 11,			///<10
	PRIME_ORDER_12			= 13,
	PRIME_ORDER_14			= 17,
	PRIME_ORDER_17			= 17,
	PRIME_ORDER_20			= 23,
	PRIME_ORDER_24			= 29,
	PRIME_ORDER_29			= 31,
	PRIME_ORDER_35			= 37,
	PRIME_ORDER_42			= 43,
	PRIME_ORDER_51			= 53,
	PRIME_ORDER_61			= 67,
	PRIME_ORDER_74			= 79,
	PRIME_ORDER_89			= 97,

	PRIME_ORDER_100			= 101,			///<100
	PRIME_ORDER_120			= 127,
	PRIME_ORDER_144			= 149,
	PRIME_ORDER_172			= 173,
	PRIME_ORDER_207			= 211,
	PRIME_ORDER_248			= 251,
	PRIME_ORDER_298			= 307,
	PRIME_ORDER_358			= 359,
	PRIME_ORDER_429			= 431,
	PRIME_ORDER_515			= 521,
	PRIME_ORDER_619			= 631,
	PRIME_ORDER_743			= 751,
	PRIME_ORDER_891			= 907,

	PRIME_ORDER_1000		= 1009,			///<1K
	PRIME_ORDER_1200		= 1201,
	PRIME_ORDER_1440		= 1447,
	PRIME_ORDER_1728		= 1733,
	PRIME_ORDER_2073		= 2081,
	PRIME_ORDER_2488		= 2503,
	PRIME_ORDER_2985		= 2999,
	PRIME_ORDER_3583		= 3593,
	PRIME_ORDER_4299		= 4327,
	PRIME_ORDER_5159		= 5167,
	PRIME_ORDER_6191		= 6197,
	PRIME_ORDER_7430		= 7433,
	PRIME_ORDER_8916		= 8923,

	PRIME_ORDER_10000		= 10007,			///<10K
	PRIME_ORDER_12000		= 12007,
	PRIME_ORDER_14400		= 14447,
	PRIME_ORDER_17280		= 17291,
	PRIME_ORDER_20736		= 20743,
	PRIME_ORDER_24883		= 24889,
	PRIME_ORDER_29859		= 29863,
	PRIME_ORDER_35831		= 35837,
	PRIME_ORDER_42998		= 43003,
	PRIME_ORDER_51597		= 51599,
	PRIME_ORDER_61917		= 61927,
	PRIME_ORDER_74300		= 74311,
	PRIME_ORDER_89161		= 89189,

	PRIME_ORDER_100000		= 100003,			///<100K
	PRIME_ORDER_120000		= 120011,
	PRIME_ORDER_144000		= 144013,
	PRIME_ORDER_172800		= 172801,
	PRIME_ORDER_207360		= 207367,
	PRIME_ORDER_248832		= 248839,
	PRIME_ORDER_298598		= 298601,
	PRIME_ORDER_358318		= 358327,
	PRIME_ORDER_429981		= 429991,
	PRIME_ORDER_515978		= 515993,
	PRIME_ORDER_619173		= 619181,
	PRIME_ORDER_743008		= 743027,
	PRIME_ORDER_891610		= 891617,

	PRIME_ORDER_1000000		= 1000003,			///<1M
	PRIME_ORDER_1200000		= 1200007,
	PRIME_ORDER_1440000		= 1440011,
	PRIME_ORDER_1728000		= 1728017,
	PRIME_ORDER_2073600		= 2073601,
	PRIME_ORDER_2488320		= 2488327,
	PRIME_ORDER_2985984		= 2985991,
	PRIME_ORDER_3583180		= 3583187,
	PRIME_ORDER_4299816		= 4299821,
	PRIME_ORDER_5159780		= 5159813,
	PRIME_ORDER_6191736		= 6191737,
	PRIME_ORDER_7430083		= 7430107,
	PRIME_ORDER_8916100		= 8916107,

	PRIME_ORDER_10000000	= 10000019,			///<10M
	PRIME_ORDER_12000000	= 12000017,
	PRIME_ORDER_14400000	= 14400011,
	PRIME_ORDER_17280000	= 17280013,
	PRIME_ORDER_20736000	= 20736017,
	PRIME_ORDER_24883200	= 24883207,
	PRIME_ORDER_29859840	= 29859877,
	PRIME_ORDER_35831808	= 35831833,
	PRIME_ORDER_42998169	= 42998173,
	PRIME_ORDER_51597803	= 51597817,
	PRIME_ORDER_61917364	= 61917367,
	PRIME_ORDER_74300837	= 74300839,
	PRIME_ORDER_89161004	= 89161013,

//	PRIME_ORDER_100000000	= 100000007,	///<100M	iȑʂɃHAvP[V͐݌vԈĂȂEEEj
//	PRIME_ORDER_1000000000	= 1000000007,	///<1G@

//ȏUINT_MAX4294967296𒴂̂Ŏg@ȂƁB
};

/**
	@brief	}bv̒ŎgBL[ƒl̃yABꎩ͎̂gȂB
	@date	2005/08/20	junjunn 쐬
*/
template<class KEYTYPE,class VALUETYPE>
struct SKVPairBase
{
	KEYTYPE		m_tKey;
	VALUETYPE	m_tValue;
};

/**
Mapn̏ɎgʒuB
listnpositionƂ͑SRႢCfbNXx[Xւ̂ߓ悤ȕ@
g悤ɏ׍HB

	@date	2005/08/20	junjunn 쐬
*/
class mapposition
{
public:
	mapposition();	///<RXgN^

/**
while (mapposition)ŌĂяoLB
|C^x[XpositionƃCfbNXx[Xmapposition𓯂`ɂĂ܂Ȃ
ŃR\R\Ď炩ȂEEEꐫƌ邩C`Lƌ邩B
*/
	operator int()	{return m_iListArrayIndex>=0;}

///ȒlƂăZbgB
	void setInvalid()	{m_iListArrayIndex=-1;}


public:
	int m_iListArrayIndex;		///<Xgz̃CfbNX
	int m_iListIndex;			///Xg̒̃CfbNXB
};


/*
}bṽNX}

StringMap<int>@@@@@@StringMapCollidable<int>						//l^̎̉

StringMap<VALUETYPE>@@@StringMapCollidable<VALUETYPE>				//L[^ƃnbV֐EĂяoE݂ȂǎBUncollibable}bv̓ftH̃}bv`ƂĖɂȂB
@@|@@@@@@@@@@@@@@@@@@|
@@|@@@@@@@@@@@@@@@@@@|@@@L[^̎̉
@@|@@@@@@@@@@@@@@@@@@|
MapUncollidable<KEYTYPE,VALUETYPE>@MapCollidable<KEYTYPE,VALUETYPE>	//nbVe[u̎
 @@ _@@@@@@@@@@@@@@@@^
  @@@_@@@@@@@@@@@@@@^@@@@	p
  @@@@_@@@@@@@@@@@@^
@@@@@@@@@@MapBase												//nbVe[u̗vf
*/

/**
}bv̊bNXBnbV̉܂ĂȂ̂ł܂
łȂ}bv̌n}IɑS}bvn̈ԉɂꂪ݂B

	@date	2005/08/20	junjunn 쐬
*/
template<class KEYTYPE,class VALUETYPE>
class MapBase
{
	typedef SKVPairBase<KEYTYPE,VALUETYPE> SKVPair;

public:
	uint getCount()	{return m_nCount;}
	virtual bool lookup(KEYTYPE tKey,VALUETYPE* ptOut) const = 0;
	virtual mapposition getStartPosition() const = 0;
	virtual void getNext(mapposition* ppos,KEYTYPE* ptKey,VALUETYPE* ptValue) const = 0;
	virtual uint getHash(KEYTYPE tKey)	const =0;
	virtual void findNextPosition(mapposition* ppos) const = 0;
	virtual void initHashTable(uint nSize) = 0;
	virtual void setAt(KEYTYPE tKey,const VALUETYPE tValue)=0;
	virtual bool removeAt(KEYTYPE tKey) = 0;
	virtual void removeAll() = 0;

protected:
	MapBase()		{m_nCount=0;}		///<܂EEEBprotectedɂăANZX֎~B


protected:
	uint m_nHashTableSize;	///<nbVe[ȗ傫
	uint m_nCount;			///<݂̗vfB
};



/**
}bvBL[͏Փˉ\B
Ƀ}bvꂽՓ˃L[̓XgŊǗĂB

	@date	2005/08/20	junjunn 쐬
*/
template<class KEYTYPE,class VALUETYPE>
class MapUncollidable : public MapBase<KEYTYPE,VALUETYPE>
{
	typedef SKVPairBase<KEYTYPE,VALUETYPE> SKVPair;
	typedef ListAD<SKVPair*> ListADPSKVPair;

public:
///RXgN^B
	MapUncollidable()						{init();}
	MapUncollidable(uint nHashTableSize)	{init();initHashTable(nHashTableSize);}
///
	void init();

///fXgN^B
	virtual ~MapUncollidable();

///nbVe[ȕBgOɐ΂ɎsKvB
///@param nSize nbVe[ũTCYBővf20ȏ傫fIԂ̂őɌ悭ȂB
	void initHashTable(uint nPrimeNumber);

///L[ŒTB
///qbgꍇ͖߂ltrueԂptOutɒlĂB
///qbgȂꍇfalseԂptOutɂ͉ȂB
	bool lookup(KEYTYPE tKey,VALUETYPE* ptOut) const;

///L[ZbgB
///ȏ㓯L[setAt()sꍇ͊YlsetAt()VtŒuB
	void setAt(KEYTYPE tKey,const VALUETYPE tValue);

///L[ō폜B
	bool removeAt(KEYTYPE tKey);
///S폜B
	void removeAll();

///TBX^[g𓾂B
	mapposition getStartPosition() const;
///TBppos̎̈ʒuƌ݂̒l𓾂B
	void getNext(mapposition* ppos,KEYTYPE* ptKey,VALUETYPE* ptValue) const;

protected:
///uint nHashKEYTYPE tKeyĂ̗vf郊XgƂ̈ʒuTB
	bool lookup_Internal(uint nHash,KEYTYPE tKey,ListADPSKVPair** ppListOut,monapi2::position* pPosOut) const;
///uint nHashKEYTYPE tKeyĂ̗vf̃AhXTB
	SKVPair* lookup_Internal(uint nHash,KEYTYPE tKey) const;

///nbV֐
	uint getHash(KEYTYPE tKey)	const {return monapi2::getHash1(tKey,MapBase<KEYTYPE,VALUETYPE>::m_nHashTableSize);}

///TBppos̎̈ʒuTB
	void findNextPosition(mapposition* ppos) const;


protected:
//o
///ɂ͕A@gpĂB
///i܂nbVŔzɑ傫U킯āAzɔ΂ꂽd̓XgőT)
	ListADPSKVPair** m_apListPKVP;	//Xg̃AhX̔zւ̃AhXB
};

/**
	@brief	MapUncollidableBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class VALUETYPE>
class StringMap : public MapUncollidable<String,VALUETYPE>
{
public:
	StringMap()	{}
	StringMap(uint nHashTableSize):MapUncollidable<String,VALUETYPE>(nHashTableSize)	{}
	virtual ~StringMap(){}
};

/**
	@brief	intMapUncollidable
	@date	2005/08/20	junjunn 쐬
*/
template<class VALUETYPE>
class IntMap : public MapUncollidable<int,VALUETYPE>
{
public:
	IntMap()	{}
	IntMap(uint nHashTableSize):MapUncollidable<int,VALUETYPE>(nHashTableSize)	{}
	virtual ~IntMap()	{}
};


/*
}bvBL[͏Փ˕sB
Ƀ}bvꂽL[͌̃GR[h񂪈ĂĂォ痈lŏ㏑B
Monapi2t@XQƁB

	@date	2005/08/20	junjunn 쐬
*/
template<class KEYTYPE,class VALUETYPE>
class MapCollidable : public MapBase<KEYTYPE,VALUETYPE>
{
	typedef SKVPairBase<KEYTYPE,VALUETYPE> SKVPair;

public:
	MapCollidable()						{init();};		///<RXgN^
	MapCollidable(uint nHashTableSize)	{init();initHashTable(nHashTableSize);}		///<RXgN^
	virtual ~MapCollidable();						///<fXgN^
///
	void init();

///nbVe[ȕBgOɐ΂ɎsKvB
///@param nSize nbVe[ũTCYBővf20ȏ傫fIԂ̂őɌ悭ȂB
	void initHashTable(uint nPrimeNumber);

	void removeAll();		///<Svf菜


///L[ZbgB
///ȏ㓯L[setAt()sꍇ͊YlsetAt()VtŒuB
	void setAt(KEYTYPE tKey,const VALUETYPE t);

///L[B
///qbgꍇ͖߂ltrueԂptOutɒlĂB
///qbgȂꍇfalseABptOutɂ͉ȂB
	bool lookup(KEYTYPE tKey,VALUETYPE* ptOut) const;

///L[ō폜B
	bool removeAt(KEYTYPE tKey);

	mapposition getStartPosition() const;
	void getNext(mapposition* ppos,KEYTYPE* ptKey,VALUETYPE* ptValue) const;

protected:
	uint getHash(KEYTYPE tKey)const 	{return getHash1(tKey,MapBase<KEYTYPE,VALUETYPE>::m_nHashTableSize);}

	SKVPair* lookup_Internal(uint nHash) const	{return m_apKVP[nHash];}

//ppos̎̈ʒuTB
	void findNextPosition(mapposition* ppos) const;

protected:
	SKVPair** m_apKVP;
};


/**
	@brief	MapCollidableBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class VALUETYPE>
class StringMapCollidable : public MapCollidable<String,VALUETYPE>
{
public:
	StringMapCollidable()	{}
	StringMapCollidable(uint nHashTableSize):MapCollidable<String,VALUETYPE>(nHashTableSize)	{}
	virtual ~StringMapCollidable()	{}
};

/**
	@brief	intMapCollidableBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class VALUETYPE>
class IntMapCollidable : public MapCollidable<int,VALUETYPE>
{
public:
	IntMapCollidable()	{}
	IntMapCollidable(uint nHashTableSize):MapCollidable<int,VALUETYPE>(nHashTableSize)	{}
	virtual ~IntMapCollidable()	{}
};

}	//namespace monapi2

//////////////////////////////////////////////////////////////////////
//ev[g.cppɏĂ͔FȂ̂.hɓĂ
#include "CollectionMapInline.h"

#endif
