/**
	@file	CollectionList.h
	@brief	RNV Xg

	RNV Xg

	License=Mona License
	@version $Revision: 1.2 $
	@date	$Date: 2005/12/12 13:54:45 $
*/
//oOC鎞͊֐{̐@dateɓtƖOƍƓetĂĂB
//܂.ht@CɂNXȂǂ@date𕔕ɂl̎ĂĂB
#ifndef _MONAPI2_BASIC_COLLECTIONLIST_H
#define _MONAPI2_BASIC_COLLECTIONLIST_H

#include "switch.h"
#include "Type.h"
#include "String.h"

namespace monapi2	{

//\[gŎgr֐typedefĂB
typedef int (__cdecl *FnCompare)(const void *p,const void *q);

///<StringList::sort()ȂǂŎgB
int compareByPString(const void *p, const void *q);

///Xg̏ɎgB
typedef void* position;


/**
	@brief	List̓ŎgpBlƁAƑO̗vfւ̃|C^Bꎩ̂̓[U[͎gȂBB
			Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template <class TYPE>
class CListElement
{
public:
	CListElement();					///<RXgN^

public:
	TYPE m_tValue;					///<l
	CListElement<TYPE>* m_pPrev;	///<̗vfւ̃|C^
	CListElement<TYPE>* m_pNext;	///<O̗vfւ̃|C^
};

//
/**
	@brief	fXgN^m_tValuedelete^CvCListElementBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template <class TYPE>
class CListElementAD:public CListElement<TYPE>
{
public:
	~CListElementAD()	{delete CListElement<TYPE>::m_tValue;}	///<fXgN^
};

/*
class Listclass ListAD̃x[XNXB

Xg̃p[^[ɂ͓ނ܂B
߂int,float,class*Ȃǂǂ̌^쐬邩̃^Cv
͎deleteIɂ邩Itɂ邩̃tOB

template <class TYPE,class ELEMENT>
TYPEO҂ELEMENT҂w肵Ă܂B
TYPEɂint,float,class*Ȃǂ̔Cӂ̌^ݒ\B
ELEMENTɂ͎deleteȂȂCListElement<TYPE>AdeleteȂCListElementAD<TYPE>
I\B

x[XɃp[^[ȈՔłList<TYPE>ListAD<TYPE>gݗĂA
Ăx[XList<int>Ȃǂ̎ۂ̃CX^Xs܂B

	@date	2005/08/20	junjunn 쐬
*/
template <class TYPE,class ELEMENT>
class ListBase
{
public:
	ListBase();								///<RXgN^
	virtual ~ListBase();					///<fXgN^

//擾
	position getHeadPosition() const;		///<擪ʒu𓾂B
	position getTailPosition() const;		///<Iʒu𓾂B
	TYPE getNext(position* ppos) const;		///<񂵁ÄʒuTYPE𓾂B
	TYPE getPrev(position* ppos) const;		///<񂵁AÖʒuTYPE𓾂B
	uint getCount() const;					///<vfԂB
	bool isEmpty()	const {return (getCount()==0);}
	TYPE getAt(position pos) const;			///<pos̈ʒuTYPE𓾂B
	position find(TYPE tFind) const;		///<tFind̒löʒupositionœB

//
	void addTail(TYPE t);					///<t𑫂B
	void addHead(TYPE t);					///<擪t𑫂B
	void insertAfter(position pos,TYPE t);	///<pošt𑫂B
	void insertBefore(position pos,TYPE t);	///<pos̑Ot𑫂B
	virtual void setAt(position pos,TYPE t);///<pos̈ʒutZbgB
	virtual void removeAt(position pos);	///<pos̈ʒu̗vfB
	virtual void removeAll();				///<SďăXgB

///nIndexԖڂ̗vfXg̑OA܂͌ɓB
///@bToHead trueȂ瓪ɁAfalseȂ疖ɓB
///@return vf̐Vʒu
	int moveNextPrev(uint nIndex,bool bToHead);


//
	position getPositionFromIndex(uint nIndex) const;	///<nIndeẍʒupositionœBi0=擪j


///ړEёւ
//\[g͏ɏ~~ꍇpFnComparetɂ邩AtɃANZX΂EEE
	void sort(FnCompare pFnCompare);

protected:
	void init();					///<

//removeAt̃Xg\B
//Ɏsłꍇpos̎wvfԂĂBsꍇNULLB
	ELEMENT* removeAt_reconstructList(position pos);			///<pos̈ʒu̗vfB

///Ŝ߂̃Rs[RXgN^`B
///q[v|C^j]̂protectedŃANZXłȂ悤ɂăRs[͋֎~B
	ListBase(ListBase&)		{};

/**
\[g֘ABɂ͑}\[ggB

܂͏̐ĂȂvfB
@param posStart X^[gꏊB
@return ߂l͓ւKvposition
*/
	position sort_FindUnordered(position posStart) const;

///@param pos̗vf𐳂ʒu܂łčsB
///@return ̌X^[gꏊ(񂳂Ă鎖ۏ؂ĂԑȌꏊ)
	position sort_BringToOrderedPos(position pos);

///m_pFnCompareƏƂ炵킹ďԂǂ
	bool isRightOrder(TYPE* p,TYPE* q)	const{return (m_pFnCompare(p,q) <= 0);}

#ifdef _DEBUG
	void assertSort() const;	///<fobOpsort()Őׂꂽ؁B
#endif


protected:
	ELEMENT*	m_pHead;			///<擪vf
	ELEMENT*	m_pTail;			///<vf
	uint		m_nCount;			///<vfB{Xg\ɂ͂ȂTOT[rXƂgetCount()pӂĂƕ֗ȎB
	FnCompare	m_pFnCompare;		///<r֐oĂB
};


/**
	@brief	XgNXBintƂfloatƂ̒PȌ^A͂łɂclass*ȂǂȂɈB
			Monapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
//Ȃ݂ɐ錾"TYPE> >"ƔpXy[X󂢂Ă̂̓}N̓WJɕsŝ
//ȂȂVisual C++RpCŒʂȂEEE
template <class TYPE>
class List	: public ListBase<TYPE, CListElement<TYPE> >	{};

/**
	@brief	onewōđĂ䂭XgBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template <class TYPE>
class ListAD: public ListBase<TYPE, CListElementAD<TYPE> >	{};


/**
	@brief	XgBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
//gListBase<String>Bclass StringŒ`ĂI/O̓o͂Sʓ|Ă̂
//Xgł͎͉ȂłB
class StringList : public List<String>
{
public:
///ftHg̃\[g@
	void sort(FnCompare pFnCompare=compareByPString)	{List<String>::sort(pFnCompare);}
};



/**
	@brief	FILOȃX^bNBMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
class Stack	: 	public List<TYPE>	//Iɂ̓XgƂĎB
{
public:
	void push(TYPE t)	{addTail(t);}
	TYPE pop();
};

/**
	@brief	FIFOȃL[BMonapi2t@XQƁB
	@date	2005/08/20	junjunn 쐬
*/
template<class TYPE>
class Queue	: 	public List<TYPE>	//Iɂ̓XgƂĎB
{
public:
	void push(TYPE t)	{addTail(t);}
	TYPE pop();
};


}	//namespace monapi2

//////////////////////////////////////////////////////////////////////
//ev[g.cppɏĂ͔FȂ̂.hɓĂ
#include "CollectionListInline.h"

#endif
