/*!
    \file   monaOperator.cpp
    \brief  define operator new & delete

    define operator new & delete

    Copyright (c) 2002 HigePon
    WITHOUT ANY WARRANTY

    \author  HigePon
    \version $Revision: 1.5 $
    \date   create:2002/08/08 update:$Date: 2002/12/24 15:02:33 $
*/
#include<IA32MemoryManager.h>
#include<monaOperator.h>
#include<monaTypes.h>

#ifndef BUILD_ON_LINUX
void* operator new(size_t size) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    return mm.allocateMemory(size);
}

void operator delete(void* address) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    mm.freeMemory(address);
    return;
}

void* operator new[](size_t size) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    return mm.allocateMemory(size);
}

void operator delete[](void* address) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    mm.freeMemory(address);
    return;
}

#endif

void* malloc(unsigned long size) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    return mm.allocateMemory(size);
}

void __builtin_delete(void* address) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    mm.freeMemory(address);
    return;
}

void* __builtin_new(unsigned long size) {

    IA32MemoryManager& mm = IA32MemoryManager::instance();
    return mm.allocateMemory(size);
}

void* __builtin_vec_new(unsigned long size) {

    return __builtin_new(size);
}

void __builtin_vec_delete(void* address) {

    __builtin_delete(address);
    return;
}
