#include <monapi.h>
#include "ReversiBoard.h"

using namespace MonAPI;

/**
 * 󥹥ȥ饯
 */
ReversiBoard::ReversiBoard() {
    init();
}

/**
 * ꤵ줿̾ˤĤ뤫
 * @param  piece <code>ReversiBoard.WHITE, ReversiBoard.BLACK, ReversiBoard.EMPTY</code>
 * @return θĿ
 */
int ReversiBoard::countPieces(int piece) {

    int result = 0;

    // θĿ
    for (int x = 0; x < BOARDW; x++) {
        for (int y = 0; y < BOARDH; y++) {
            if (this->board[x][y] == piece) result++;
        }
    }
    return result;
}

/**
 * ꤵ줿֤ζ֤
 * @param  x (x, y) ΰ
 * @param  y (x, y) ΰ
 * @return  ̤ϰϳξ<code>ReversiBoard.EMPTY</code>
 */
int ReversiBoard::getPiece(int x, int y) {

    // x, yϰϤå
    if (!checkRange(x, y)) return EMPTY;

    // ֤
    return board[x][y];
}

/**
 * ꤵ줿֤ζ֤
 * @param  point ΰ
 * @return  ̤ϰϳξ<code>ReversiBoard.EMPTY</code>
 */
int ReversiBoard::getPiece(Point* point) {
    return getPiece(point->x, point->y);
}

/**
 * ߤμ֤Υץ쥤䡼֤<code>ReversiBoard.EMPTY</code>֤ȤϾη夬ĤƤ<BR>
 * @return ߤμ֤Υץ쥤䡼 <code>ReversiBoard.BLACK, WHITE, EMPTY</code>
 */
int ReversiBoard::getCurrentHand() const {
    return this->currentHand;
}

/**
 * ꤵ줿֤˶֤<BR>
 * ֤硢֤򼨤<BR>
 * <code>Point</code>notifyObservers<BR>
 * ƻ븵Τ
 * @param x (x, y) ΰ
 * @param y (x, y) ΰ
 * @param piece ֤
 * @return ֤<code>true</code>, ֤ʤä<code>false</code>
 */
bool ReversiBoard::setPiece(int x, int y, int piece) {

    int numReversiblePieces; // ΢֤ȤΤǤ

    // ߤμȾȹ
    if (currentHand != piece) return false;

    // ꤬˽λɤå
    if (existNotReversedPieces()) return false;

    // ֤뤫ɤĴ٤
    numReversiblePieces = countReversiblePieces(x, y, piece);
    if (numReversiblePieces <= 0) return false;

    // piece(x, y)֤Ȥˡ΢֤򤹤٤Ƶ
    recordReversiblePieces(x, y, piece);

    // ֤
    board[x][y] = piece;

    // 򵭲
    allTurns->add(new Point3D(x, y, piece));

    // ѹObserver
    this->setChanged();
    this->notifyObservers(new Point(x, y));
    this->clearChanged();

    return true;
}

/**
 * <code>setPiece()</code>ˡ΢֤Ƥʤ¸ߤ뤫֤<BR>
 * <pre>
 *    ˡ
 *      board.setPiece(3, 5, OthlloBoard::BLACK);
 *      while (existNotReversedPieces()) {
 *          reverseNext();
 *          // ѽ
 *      }
 * </pre>
 * @return ΢֤Ƥʤ¸ߤ<code>true</code>
 */
bool ReversiBoard::existNotReversedPieces() {
    return allNotReversedPieces->size() > 0;
}

/**
 * ζ΢֤<BR>
 * ΢֤򼨤<code>Point</code>notifyObserversǴƻ븵Τ
 * existNotReversedPieces()λˡ򻲾
 */
void ReversiBoard::reverseNext() {

    // ΢֤֤
    Point* point = allNotReversedPieces->get(0);

    // ΢֤
    reversePiece(point->x, point->y);

    // ѹ
    this->setChanged();
    notifyObservers(new Point(point));
    this->clearChanged();

    // ΢֤Τǰ֤õ
    allNotReversedPieces->removeAt(0);

    return;
}

/**
 * ߥ֤
 * @return ߥ
 */
int ReversiBoard::getTurn() const {
    return this->turn;
}

/**
 * undoǽ
 * 1
 */
void ReversiBoard::undo() {

    // 1ʤ
    if (getTurn() < 1) return;

    // ̽
    initBoard();

    // ¤٤ʤ
    for (int i = 0; i < allTurns->size() -1; i++) {

        // ֤
        Point3D* p = allTurns->get(i);
        setPiece(p->x, p->y, p->z);
        while (existNotReversedPieces()) {
            reverseNext();
        }
    }

    // ǸΥõ
    allTurns->removeAt(allTurns->size() -1);

    return;
}

/**
 * ꤵ줿֤˶֤ȤˡĶ΢֤뤫֤
 * @param x
 * @param y
 * @param piece ֤
 * @return ΢֤
 */
int ReversiBoard::countReversiblePieces(int x, int y, int piece) {

    int result = 0;

    // x, yϰϤå
    if (!checkRange(x, y)) return 0;

    // Ǥ˶֤Ƥ뤫å
    if (board[x][y] != EMPTY) return 0;

    // (x, y)piece֤΢֤ȤΤǤ8õ
    result += countReversiblePieceToOneAngle(x, y,  1,  0, piece, false);
    result += countReversiblePieceToOneAngle(x, y,  1,  1, piece, false);
    result += countReversiblePieceToOneAngle(x, y,  0,  1 ,piece, false);
    result += countReversiblePieceToOneAngle(x, y, -1,  1, piece, false);
    result += countReversiblePieceToOneAngle(x, y, -1,  0, piece, false);
    result += countReversiblePieceToOneAngle(x, y, -1, -1, piece, false);
    result += countReversiblePieceToOneAngle(x, y,  0, -1, piece, false);
    result += countReversiblePieceToOneAngle(x, y,  1, -1, piece, false);

    return result;
}

/**
 * СפꥻåȤ
 */
void ReversiBoard::resetBoard() {

    delete (this->allTurns);
    this->allTurns = new HList<Point3D*>();
    initBoard();

    // ѹ
    this->setChanged();
    this->notifyObservers(NULL);
    this->clearChanged();
    return;
}

/**
 * ReversiBoardȽԤ
 */
void ReversiBoard::init() {

    // ̽
    initBoard();

    // ٤ƤΥ򵭲Vector
    allTurns = new HList<Point3D*>();

    return;
}

/**
 * ̽Ԥ
 */
void ReversiBoard::initBoard() {

    // ߥ
    this->turn = 0;

    // Ϲ
    this->currentHand = BLACK;

    // ̤ˤ
    for (int x = 0; x < BOARDW; x++) {
        for (int y = 0; y < BOARDH; y++) board[x][y] = EMPTY;
    }

    // ֤֤Ƥ򥻥å
    board[3][3] = BLACK;
    board[4][4] = BLACK;
    board[4][3] = WHITE;
    board[3][4] = WHITE;

    // ΢֤٤Τ٤ư֤򵭲List
    allNotReversedPieces = new HList<Point*>();

    return;
}

/**
 * ꤷ΢֤
 */
void ReversiBoard::reversePiece(int x, int y) {

    // x, yϰϤå
    if (!checkRange(x, y)) return;

    // ΢֤⤷ʤ鲿⤷ʤ
    board[x][y] = turnColor(board[x][y]);

    return;
}

/**
 * Ϥ줿ͤ̾¸ߤ뤫å
 */
bool ReversiBoard::checkRange(int x, int y) {

    // ̾ˤȤ
    bool xRange = x >= 0 && x < BOARDW;
    bool yRange = y >= 0 && y < BOARDH;

    // ̾ˤ
    if (xRange && yRange) return true;

    // ̾ˤʤ
    return false;
}

/**
 *  ꤵ줿٥ȥ(toX, toY)΢֤
 *  reordFlagtrueλϰ֤򵭲
 */
int ReversiBoard::countReversiblePieceToOneAngle(int x, int y, int toX,int toY
                                                 , int piece, bool recordFlag) {
    int result = 0;

    // ٤ζذư
    x += toX;
    y += toY;

    // ̤üޤõ³
    while (x >= 0 && y >= 0 && x < BOARDW && y < BOARDH) {

        // õζ΢֤οʤ΢֤
        if (board[x][y] == turnColor(piece)) {

            // ΢֤ΰ֤򵭲
            if (recordFlag) allNotReversedPieces->add(new Point(x, y));

            // 󥯥
            result++;
        }

        // Ʊä顢ޤǤä΢֤΢֤ȤǤ
        else if (board[x][y] == piece) return result;

        // ʤ΢֤ʤ
        else if (board[x][y] == EMPTY) {

            if (recordFlag) {

                // Ƥΰ
                for (int i = 0; i < result; i++) {

                    allNotReversedPieces->removeAt(allNotReversedPieces->size() - 1);
                }
            }
            return 0;
        }

        // ٤ζذư
        x += toX;
        y += toY;
    }

    if (recordFlag) {

        // Ƥΰ
        for (int i = 0; i < result; i++) {

            allNotReversedPieces->removeAt(allNotReversedPieces->size() - 1);
        }
    }
    return 0;
}

/**
 * ΢֤֤
 */
int ReversiBoard::turnColor(int piece) {
    return piece * -1;
}

/**
 * piece(x, y)֤Ȥˡ΢֤򤹤٤Ƶ
 */
bool ReversiBoard::recordReversiblePieces(int x, int y, int piece) {

    // x, yϰϤå
    if (!checkRange(x, y)) return false;

    // Ǥ˶֤Ƥ뤫å
    if (board[x][y] != EMPTY) return false;

    // ֵ֥Ȥ
    delete allNotReversedPieces;
    allNotReversedPieces = new HList<Point*>();

    // ΢֤֤򵭲
    countReversiblePieceToOneAngle(x, y,  1,  0, piece, true);
    countReversiblePieceToOneAngle(x, y,  1,  1, piece, true);
    countReversiblePieceToOneAngle(x, y,  0,  1 ,piece, true);
    countReversiblePieceToOneAngle(x, y, -1,  1, piece, true);
    countReversiblePieceToOneAngle(x, y, -1,  0, piece, true);
    countReversiblePieceToOneAngle(x, y, -1, -1, piece, true);
    countReversiblePieceToOneAngle(x, y,  0, -1, piece, true);
    countReversiblePieceToOneAngle(x, y,  1, -1, piece, true);

    return true;
}

// Υץ쥤䡼Ƚ
void ReversiBoard::setNextHand() {

    if (isTherePlace(turnColor(currentHand))) {
        currentHand = turnColor(currentHand);
    } else if (isTherePlace(currentHand)) {

        // ³Ƥ⤦1
    } else {

        // ξץ쥤䡼֤꤬ʤ
        currentHand = EMPTY;
    }

    return;
}

// ̾˻ꤵ줿piece򤪤ȤǤ뤫Ƚ
bool ReversiBoard::isTherePlace(int piece) {

    int result = 0;

    // θĿ
    for (int x = 0; x < BOARDW; x++) {
        for (int y = 0; y < BOARDH; y++) {
            result += countReversiblePieces(x, y, piece);
        }
    }

    return result > 0;
}
