/*!
    \file  MoEther.h
    \brief C[TlbgNX wb_

    class MoEther

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X Licnese

    \author  Yamami 
    \version $Revision: 1.2 $
    \date   create:2004/08/12 update:$Date: 2004/11/15 15:45:20 $
*/
#ifndef _MONA_MOETHER_
#define _MONA_MOETHER_

#include <sys/types.h>
#include <monapi.h>

#include "MoPacUtl.h"
#include "MonesDefine.h"

#include "AbstractMonic.h"
#include "MoArp.h"


/*! 
 *  \struct ETHER_FRAME
 *  \brief C[Tlbgt[\
 */
typedef struct{
    byte  dstmac[6];   // M MAC ID
    byte  srcmac[6];   // M MAC ID
    word    type;     // t[^Cv Frame type(DIX) or frame length(IEEE)
    byte   data[0x600];// Data
}ETHER_FRAME;


/*!
    MoEther class
*/
class MoEther
{
    
  public:
    
    //RXgN^
    MoEther();
    ~MoEther();
    void etherInit(AbstractMonic*);
    int setEtherFrame(byte* , int);
    int getEtherFrame(ETHER_FRAME* );
    int receiveEther();
    
//    int receiveEther(ETHER_FRAME*); //Iɑd` ڎM(obt@O)
    
    void sendEther(byte* , dword , dword);
    


  private:
    //C[Tlbgt[ێXg
    List<ETHER_FRAME*>* Ether_FrameList_;
    
    //NIChCo
    AbstractMonic* insAbstractNic;
    
};

#endif
