package MojoWiki::YAML;
##
## YAMLファイルからハッシュを生成するクラス
## $Id: YAML.pm 3 2011-06-17 14:51:48Z bobunderson $
##

use strict;
use warnings;

use IO::File;
use YAML;

##
## YAMLファイルを読んでハッシュを生成する
## 引数
##   $path YAMLファイルのパス
## 戻り値
##   YAMLファイルから生成したハッシュ
##
sub load_yaml {
    my ($path) = @_;

    if ( !( -e $path ) ) {
        return undef;
    }

    my $fd = new IO::File();
    $fd->open( $path, 'r' );
    my @lines = $fd->getlines();
    $fd->close();

    my $yaml_str = join( '', @lines );

    my $hash = YAML::Load($yaml_str);

    return $hash;
}

1;
