package MojoWiki::Plugins::font;

use Encode;
use FindBin;
use Time::Local;

use lib join( '/', $FindBin::Bin, '..', '..' );

use base qw(
    MojoWiki::Plugins::AbstractInlinePlugin
);

sub new {
    my ( $class, $controller, @args ) = @_;

    my $self = {};

    bless( $self, $class );

    $self->{'inline_plugins'} = ['color'];
    $self->{'db'}             = $controller->app->db;

    return $self;
}

sub process_inline_plugin {
    my ( $self, $plugin_name, $path, $args_str ) = @_;

    my @args = split( /\s+/, $args_str );

    if ( $plugin_name eq 'color' ) {
        return &_color( $self, @args );
    }
    else {
        die 'unprocessable!!';
    }
}

sub _color {
    my ( $self, $color, @str ) = @_;

    return '<font color=' . $color . '>' . join( ' ', @str ) . '</font>';
}

1;
