package MojoWiki::Plugins::calender;

use Encode;
use FindBin;
use Time::Local;

use lib join( '/', $FindBin::Bin, '..', '..' );

use base qw(
    MojoWiki::Plugins::AbstractBlockPlugin
);

sub new {
    my ( $class, $controller, @args ) = @_;

    my $self = {};

    bless( $self, $class );

    $self->{'block_plugins'} = ['calender'];
    $self->{'db'}            = $controller->app->db;

    return $self;
}

sub process_block_plugin {
    my ( $self, $plugin_name, $path, $args_str ) = @_;

    my @args = split( /\s+/, $args_str );

    if ( $plugin_name eq 'calender' ) {
        return &_calender( $self, @args );
    }
    else {
        die 'unprocessable!!';
    }
}

sub _calender {
    my ( $self, @args ) = @_;

    my ( $sec, $min, $hour, $mday, $month, $year ) = localtime( time() );
    $year  = $year + 1900;
    $month = $month + 1;

    my $link_url;
    my $link_only_passed_days;
    if ( $args[0] =~ /^(\d{4})(\d{2})$/ ) {

        # @args = ( $year_month, $link_url, $link_only_passed_days )
        $year  = $1;
        $month = $2;
        ( undef, $link_url, $link_only_passed_days ) = @args;
    }
    else {

        # @args = ( $link_url, $link_only_passed_days )
        ( $link_url, $link_only_passed_days ) = @args;
    }

    return &_get_month_calender( $self, $year, $month, $link_url,
        $link_only_passed_days );
}

sub _get_month_calender {
    my ( $self, $year, $month, $link_url, $link_only_passed_days ) = @_;

    $year  = $year  || 1970;
    $month = $month || 1;

    # $year年 $month月 1日の曜日を求める
    my $utime = timelocal( 0, 0, 0, 1, $month - 1, $year - 1900 );
    my $start_wday = ( localtime($utime) )[6];

    # 月末日を求める
    my $max_mday = &_get_max_mday( $self, $year, $month );

    # 1ヶ月(6週間分)の空のカレンダーに日付を入れていく
    my @calender;
    my $mday = 1;
    for ( my $i = 0; $i < 42; $i++ ) {
        if ( $i >= $start_wday && $mday <= $max_mday ) {
            $calender[$i] = $mday;
            $mday++;
        }
        else {
            $calender[$i] = '';
        }
    }

    my $html;
    $html = '<table style=\'font-size: 9px\'>';
    $html
        = $html
        . '<tr><th colspan=7>'
        . $year . '.'
        . $month
        . '</th></tr><tr>';
    my @wdays = ( 'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat' );
    foreach my $wday (@wdays) {
        $html = $html . '<th>' . $wday . '</th>';
    }
    $html = $html . '</tr>';

    for ( my $i = 1; $i <= 6; $i++ ) {
        $html = $html . '<tr>';
        for ( my $j = 1; $j <= 7; $j++ ) {
            $mday = $calender[ 7 * ( $i - 1 ) + $j - 1 ];
            my $link = &_make_link( $self, $year, $month, $mday, $link_url,
                $link_only_passed_days );
            $html = $html . '<td>' . $link . '</td>';
        }
        $html = $html . '</tr>';
    }
    $html = $html . '</table>';

    return Encode::decode_utf8($html);
}

sub _get_max_mday {
    my ( $self, $year, $month ) = @_;

    # 翌月の1日 00:00:00 から1秒引いて月末日を求める
    my $year_of_next_month = $year;
    my $next_month;
    if ( $month == 12 ) {
        $next_month         = 1;
        $year_of_next_month = $year + 1;
    }
    else {
        $next_month = $month + 1;
    }
    my $start_utime_of_next_month
        = timelocal( 0, 0, 0, 1, $next_month - 1, $year_of_next_month - 1900 )
        - 1;

    return ( localtime( $start_utime_of_next_month - 1 ) )[3];
}

sub _make_link {
    my ( $self, $year, $month, $mday, $link_url, $link_only_passed_days )
        = @_;

    if ( !defined($year) || $year == 0 || $year eq '' ) {
        return '';
    }
    if ( !defined($month) || $month == 0 || $month eq '' ) {
        return '';
    }
    if ( !defined($mday) || $mday == 0 || $mday eq '' ) {
        return '';
    }

    if ( !defined($link_url) ) {
        return $mday;
    }

    my $link_month = sprintf( "%02d", $month );
    my $link_mday  = sprintf( "%02d", $mday );

    $link_url =~ s/YYYY/$year/g;
    $link_url =~ s/MM/$link_month/g;
    $link_url =~ s/DD/$link_mday/g;

    my $link;
    if ( defined($link_only_passed_days) && $link_only_passed_days == 1 ) {

        # 経過済みの日のみリンクを生成
        my $utime = timelocal( 0, 0, 0, $mday, $month - 1, $year - 1900 );
        if ( $utime <= time() ) {
            $link = "<a href=\"$link_url\" target=\"_blank\">$mday</a>";
        }
        else {
            $link = $mday;
        }
    }
    else {

        # すべての日にリンクを生成
        $link = "<a href=\"$link_url\" target=\"_blank\">$mday</a>";
    }

    return Encode::encode_utf8($link);
}

1;
