package MojoWiki::Plugins::AbstractCommandPlugin;
##
## コマンド型プラグインの抽象クラス
## $Id: AbstractCommandPlugin.pm 8 2011-06-22 08:27:57Z bobunderson $
##

use strict;
use warnings;

use FindBin;
use Mojolicious::Controller;

use lib join( '/', $FindBin::Bin, '..', '..' );

##
## 処理可能なコマンドのリストを返す
##
sub processable_commands {
    my ($self) = @_;

    my $commands = $self->{'commands'};

    return @$commands;
}

##
## 指定されたコマンドが処理可能なら1を返す
## 引数
##   $command コマンド名
## 戻り値
##   1 処理可能
##   0 処理不能
##
sub is_processable_command {
    my ( $self, $command ) = @_;

    my $commands = $self->{'commands'};

    if ( grep( /^$command$/, @$commands ) ) {
        return 1;
    }
    else {
        return 0;
    }
}

##
## コマンドを処理する
## 引数
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
##   $command コマンド名
##
sub process_command {
    my ( $self, $controller, $command ) = @_;

    die 'process_command is not overridden';
}

##
## ページが削除された際に、当該ページに紐づくデータの後始末をする
## 引数
##   $path 削除されたページのパス
##
sub delete_page {
    my ( $self, $path ) = @_;

    #die 'delete_page is not overridden';
}

1;
