package MojoWiki::Plugins;
##
## プラグインを管理するモジュール
## $Id: Plugins.pm 3 2011-06-17 14:51:48Z bobunderson $
##

use strict;
use warnings;

use FindBin;
use IO::Dir;
use UNIVERSAL::require;

use lib join( '/', $FindBin::Bin, '..' );
use MojoWiki::Constants;

##
## インライン型プラグインのインスタンスを返す
## 引数
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
## 戻り値
##   インライン型プラグインのインスタンスの配列
##
sub get_inline_plugins {
    my ($controller) = @_;

    return &_get_plugin_modules( 'MojoWiki::Plugins::AbstractInlinePlugin',
        $controller );
}

##
## ブロック型プラグインのインスタンスを返す
## 引数
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
## 戻り値
##   ブロック型プラグインのインスタンスの配列
##
sub get_block_plugins {
    my ($controller) = @_;

    return &_get_plugin_modules( 'MojoWiki::Plugins::AbstractBlockPlugin',
        $controller );
}

##
## コマンド型プラグインのインスタンスを返す
## 引数
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
## 戻り値
##   コマンド型プラグインのインスタンスの配列
##
sub get_command_plugins {
    my ($controller) = @_;

    return &_get_plugin_modules( 'MojoWiki::Plugins::AbstractCommandPlugin',
        $controller );
}

##
## プラグインのインスタンスを返す
## 引数
##   $abstract_module 各種プラグインの抽象クラス名
##   $controller MojoWiki::MojoDaemon::Page クラスのインスタンス
## 戻り値
##   指定された抽象クラスを継承したプラグインのインスタンスの配列
##
sub _get_plugin_modules {
    my ( $abstract_module, $controller ) = @_;

    my @modules = ();

    my $dir = new IO::Dir();
    $dir->open(PLUGIN_DIR);

    while ( my $file = $dir->read() ) {
        if ( !( $file =~ /^(\w+)\.pm$/ ) ) {
            next;
        }

        if ( $file =~ /^Abstract/ ) {
            next;
        }

        my $module_name = 'MojoWiki::Plugins::' . $1;
        $module_name->use();
        my $module = new $module_name($controller);

        if ( $module->isa($abstract_module) ) {
            push( @modules, $module );
        }
    }

    $dir->close();

    return @modules;
}

1;
