package MojoWiki::Constants;
##
## 定数を定義するモジュール
## $Id: Constants.pm 14 2011-07-07 03:06:41Z bobunderson $
##

use strict;
use warnings;

BEGIN {
    require Exporter;
    our @ISA    = qw(Exporter);
    our @EXPORT = qw(
        MOJOWIKI_HOME
        ETC_DIR
        STATIC_DIR
        VAR_DIR
        TEMPLATE_DIR
        PLUGIN_DIR

        CONFIG_PATH

        URL_PREFIX
        STATIC_URL_PREFIX
    );
}

# ディレクトリ
use constant 'MOJOWIKI_HOME' => '__PREFIX__';
use constant 'ETC_DIR'       => join( '/', MOJOWIKI_HOME, 'etc' );
use constant 'STATIC_DIR'    => join( '/', MOJOWIKI_HOME, 'htdocs' );
use constant 'VAR_DIR'       => join( '/', MOJOWIKI_HOME, 'var' );
use constant 'TEMPLATE_DIR'  => join( '/', VAR_DIR, 'templates' );
use constant 'PLUGIN_DIR' =>
    join( '/', MOJOWIKI_HOME, 'lib', 'perl', 'MojoWiki', 'Plugins' );

# 設定ファイル
use constant 'CONFIG_PATH' => join( '/', ETC_DIR, 'config.yaml' );

# URLのprefix
# http://hostname/mojowiki/ がWikiのトップになる
use constant 'URL_PREFIX' => '/mojowiki/';

# 静的ファイルのURLのprefix
use constant 'STATIC_URL_PREFIX' => join( '', URL_PREFIX, 'static/' );

1;
