/* 既存のDBを削除 */
DROP DATABASE IF EXISTS mojowiki;

/* DB作成 */
CREATE DATABASE mojowiki;
use mojowiki;

/* ユーザ権限追加 */
GRANT ALL PRIVILEGES ON mojowiki.* TO admin@localhost IDENTIFIED BY 'hogehoge' WITH GRANT OPTION;

/* ページテーブルを作成 */
CREATE TABLE PAGE (
    path        VARCHAR(255),
    title       VARCHAR(255),
    body        TEXT,
    revision    INTEGER NOT NULL DEFAULT 0,
    ctime       DATETIME NOT NULL,
    mtime       DATETIME NOT NULL,
    PRIMARY KEY (path),
    index(mtime)
) TYPE=INNODB;

/* プラグイン用が利用する Key-Value Store */
CREATE TABLE KVS_KEY (
    id          INTEGER AUTO_INCREMENT,
    plugin_name VARCHAR(255),
    name        VARCHAR(255),
    PRIMARY KEY (id),
    UNIQUE(plugin_name, name),
    index (plugin_name, name)
) TYPE=INNODB;

CREATE TABLE KVS_VALUE (
    id          INTEGER AUTO_INCREMENT,
    key_id      INTEGER,
    value       VARCHAR(1024),
    PRIMARY KEY (id),
    FOREIGN KEY (key_id) REFERENCES KVS_KEY(id) ON DELETE CASCADE,
    index (key_id, value)
) TYPE=INNODB;
