// MkImgPageCom.cpp : CMkImgPage ̎

#include "stdafx.h"
#include "MkImgPageCom.h"

#include "DocumentParser.h"
#include "error.h"

#include <map>

void CMkImgPage::FinalRelease()
{
	for( CStringList::const_iterator ite = temp_paths.begin();
		ite != temp_paths.end();
		++ite )
	{
		const CString& path = *ite;
		DeleteFile( path );
	}
}

STDMETHODIMP CMkImgPage::QueryStatus(
	const GUID *pguidCmdGroup, // Pointer to command group
	ULONG cCmds,               // Number of commands in prgCmds array
	OLECMD *prgCmds,           // Array of commands
	OLECMDTEXT *pCmdText       // Pointer to name or status of command
)
{
	ATLTRACE(atlTraceCOM, 2, _T("IOleCommandTarget::QueryStatus\n") );
	return S_OK;
}

STDMETHODIMP CMkImgPage::Exec(
	const GUID *pguidCmdGroup,  // Pointer to command group
	DWORD nCmdID,               // Identifier of command to execute
	DWORD nCmdExecOpt,          // Options for executing the command
	VARIANTARG *pvaIn,          // Pointer to input arguments
	VARIANTARG *pvaOut          // Pointer to command output
)
{
	ATLTRACE(atlTraceCOM, 2, _T("IOleCommandTarget::Exec\n") );

	try{
		CComPtr<IServiceProvider> spServiceProvider;
		CheckAndThrow( m_spUnkSite.QueryInterface( &spServiceProvider ) );

		CComPtr<IServiceProvider> spServiceProvider2;
		CheckAndThrow( spServiceProvider->QueryService( SID_STopLevelBrowser, &spServiceProvider2 ) );

		CComPtr<IWebBrowser2> browser;
		CheckAndThrow( spServiceProvider2->QueryService( SID_SWebBrowserApp, &browser ) ) ;

		CComPtr<IDispatch> doc_disp;
		CheckAndThrow( browser->get_Document( &doc_disp ) );

		CComPtr<IHTMLDocument2> doc;
		CheckAndThrow( doc_disp.QueryInterface( &doc ) );

		CComBSTR bstrTitle;
		if( FAILED( doc->get_title( &bstrTitle.m_str ) ) || bstrTitle.m_str == NULL ) {
			bstrTitle = L"unknown";
		}

		CComBSTR bstrURL;
		if( FAILED( doc->get_URL( &bstrURL.m_str ) ) || bstrURL.m_str == NULL ) {
			bstrURL = L"";
		}

		CItemSelectDlg dlg;
		dlg.set_linked_url( CString( (LPCWSTR)(BSTR) bstrURL ) );

		INT_PTR result = dlg.DoModal();
		if( result != IDOK ) {
			return S_OK;
		}

		CComPtr<IStream> buffer;

		CString real_temp_path;
		ExpandEnvironmentStrings( dlg.get_temp_path(), real_temp_path.GetBuffer( MAX_PATH ), MAX_PATH );
		real_temp_path.ReleaseBuffer();

		CString save_path;
		if( dlg.get_save_mode() != 0 ) {
			if( dlg.is_temp_name() ) {
				// e|t@C̎
				CString baseDir( real_temp_path );
				const LPCTSTR tmp = baseDir;
				LPCTSTR p = tmp;
				while(*p)p++;
				const TCHAR lastChr = *CharPrev( tmp, p );
				if( ! ( lastChr == '\\' || lastChr == '/' ) ) {
					// I[\ȂΒǉB
					baseDir += "\\";
				}

				int retry = 0;
				for(;;) {
					SYSTEMTIME systime = { 0 };
					GetLocalTime( &systime );
					CString tempFileName;
					tempFileName.Format( "%smkimgpage-%04d%02d%02d%02d%02d%02d-%04d-%02d.htm",
						baseDir,
						systime.wYear,
						systime.wMonth,
						systime.wDay,
						systime.wHour,
						systime.wMinute,
						systime.wSecond,
						systime.wMilliseconds,
						retry
						);
					HANDLE hTempFile = CreateFile( tempFileName, GENERIC_WRITE, FILE_SHARE_WRITE | FILE_SHARE_READ, NULL, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL );
					if( hTempFile != INVALID_HANDLE_VALUE ) {
						CloseHandle( hTempFile );
						temp_paths.push_back( tempFileName );
						save_path = tempFileName;
						break;
					}
					retry++;
					if( retry >= 100 ) {
						AtlThrow( MAKE_HRESULT( 1, FACILITY_WIN32, ERROR_FILE_NOT_FOUND ) );
					}
				}
			}
			else {
				// [JɃt@C𐶐
				save_path = (LPCWSTR)(BSTR) bstrTitle;
				OPENFILENAME opfn = { 0 };
				opfn.lStructSize = sizeof( OPENFILENAME );
				opfn.lpstrFile = save_path.GetBuffer( MAX_PATH + 1);
				opfn.lpstrInitialDir = real_temp_path;
				opfn.nMaxFile = MAX_PATH;
				opfn.lpstrFilter = "HTML\0*.html;*.htm\0all files\0*.*\0\0";
				opfn.lpstrDefExt = "html";
				opfn.Flags = OFN_DONTADDTORECENT | OFN_OVERWRITEPROMPT;
				if( ! GetSaveFileName( &opfn ) ) {
					return S_OK;
				}
				save_path.ReleaseBuffer(-1);
			}

			// t@CXg[𐶐
			CheckAndThrow( SHCreateStreamOnFile( save_path, STGM_READWRITE | STGM_SHARE_DENY_NONE | STGM_CREATE, &buffer ) );
		}
		else {
			// zy[W̐(̃Xg[𐶐)
			CheckAndThrow( CreateStreamOnHGlobal( NULL, TRUE, &buffer ) );
		}

		CDocumentParser parser( dlg );
		CheckAndThrow( parser.parse( doc ) );

		typedef std::map<CString, bool> CStringMap;
		CStringMap usedItemMap;

		// HTMLJn
		CStringA head( "<html><head><title>");
		head += CString( (LPCWSTR)(BSTR) bstrTitle );
		head += "</title></head><body>\r\n";

		buffer->Write( (LPCSTR) head, (ULONG) head.GetLength(), NULL );

		int item_count = 0;
		for( CDocumentParser::const_iterator ite = parser.begin();
			ite != parser.end();
			++ite, item_count++ )
		{
			const ItemInfo& itemInfo = *ite;

			// ACẽ`FbN
			if( dlg.is_use_item_limit() ) {
				const range = (item_count >= ( dlg.get_item_start() - 1 ) ) && 
					( item_count < dlg.get_item_start() + dlg.get_item_limit() - 1 );
				if( ! range ) {
					continue;
				}
			}

			// ACẽ`FbN
			CStringMap::iterator usedItemIte = usedItemMap.find( itemInfo.getItem() );
			if( usedItemIte != usedItemMap.end() ) {
				continue;
			}
			usedItemMap.insert( CStringMap::value_type( itemInfo.getItem(), true ) );

			// ACẽ_O
			switch( itemInfo.getItemType() )
			{
			case ItemInfo::ITEMTYPE_NONE:
				break;

			case ItemInfo::ITEMTYPE_IMAGE:
			case ItemInfo::ITEMTYPE_LINKED_IMAGE:
				{
					CStringA img( "<img src=\"" );
					img += itemInfo.getItem();
					img += CString( "\"><br>\r\n" );
					buffer->Write( (LPCSTR) img, img.GetLength(), NULL );
				}
				break;

			case ItemInfo::ITEMTYPE_LINKED_HTML:
				{
					CStringA a( "<iframe src=\"" );
					a += itemInfo.getItem();
					a += CString( "\"></iframe><br>\r\n" );
					buffer->Write( (LPCSTR) a, a.GetLength(), NULL );
				}
				break;

			default:
				AtlThrow( MAKE_HRESULT( 1, FACILITY_WIN32, ERROR_INVALID_FUNCTION ) );
			}
		}

		// HTML
		CStringA tail( "</body></html>\r\n" );
		buffer->Write( (LPCSTR) tail, (ULONG) tail.GetLength(), NULL );

		// HTMLJ
		if( dlg.get_save_mode() == 0 ) {
			LARGE_INTEGER offset = { 0 };
			buffer->Seek( offset, STREAM_SEEK_SET, NULL);

			CComPtr<IPersistStreamInit> doc_persist;
			CheckAndThrow( doc.QueryInterface( &doc_persist ) );
			doc_persist->InitNew();
			doc_persist->Load( buffer );
		}
		else {
			if( dlg.get_open_mode() != 2 ) {
				CComVariant target( L"_top" );
				CComVariant flag( 0 );

				if( dlg.get_open_mode() == 1 ) {
					target = L"_blank";
					flag = navOpenInNewWindow;
				}

				CComVariant fname( save_path );
				CComVariant postdata;
				CComVariant header;

				CheckAndThrow( browser->Navigate2( &fname, &flag, &target, &postdata, &header ) );
			}
		}

		return S_OK;
	}
	catch( const CAtlException& e ) {
		CString message;
		message.Format("Ɏs܂B(HRESULT=%08lx)", (HRESULT) e );
		::MessageBox( NULL, message, "MkImgPage Error", MB_ICONERROR | MB_OK );
		return E_FAIL;
	}
	catch( ... ) {
		::MessageBox( NULL, "sȗO܂B", "MkImgPage Error", MB_ICONERROR | MB_OK );
		return E_FAIL;
	}
}

// CMkImgPage

