// -*- mode: C++ -*-
#ifndef MIX_TEST_TOKENIZER_H_
#define MIX_TEST_TOKENIZER_H_

#include <Tokenizer.h>
#include <misc.h>

#include "MBC.h"

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>

class TokenizerTest : public CppUnit::TestCase{
  static MiX::Tokenizer<char>* tokenizer_;
  static MiX::Tokenizer<MBChar::MBChar,MBChar::MBCharTraits,
			MBChar::MBCXMLTraits>* tokenizer_mbc_;
  static const char teststring_[];
  static const char teststring_mbc_[];
  static const MiX::TokenType tt_seq_[];

  virtual void testConstruct();
  virtual void testInject();
  virtual void testEjectPush();
  virtual void testDestruct();
public:
  virtual void setUp();
  virtual void tearDown();
  static CppUnit::TestSuite* suite();
};

#endif
