#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <cstring> // strcmp

#include <DefaultXMLTraits.h>
#include <Tokenizer.h>
#include <misc.h>
#include "Tokenizer.test.h"

MiX::Tokenizer<char>* TokenizerTest::tokenizer_ = 0;
MiX::Tokenizer<MBChar::MBChar,MBChar::MBCharTraits,
	       MBChar::MBCXMLTraits>* TokenizerTest::tokenizer_mbc_ = 0;

const char TokenizerTest::teststring_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<!Decralation>"
  "<TestDocument Attribute=\"Attribute\">"
  "<TestElement>ThisIsTest</TestElement>"
  "<TestElement/>"
  "<!-- ThisIsComment -->"
  "</TestDocument>"
};

const char TokenizerTest::teststring_mbc_[] = {
  "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>"
  "<!>"
  "<ƤȤɤ °̾=\"\">"
  "<>Ƥ</>"
  "</>"
  "<!-- ϥȤǤ -->"
  "</ƤȤɤ>"
};

const MiX::TokenType TokenizerTest::tt_seq_[] = {
  //"<?xml "
  MiX::Token_lt,MiX::Token_question,MiX::Token_text,MiX::Token_space,
  //"version=\""
  MiX::Token_text,MiX::Token_eq,MiX::Token_dblquote,
  //"1.0\" "
  MiX::Token_text,MiX::Token_dblquote,MiX::Token_space,
  //"encoding=\"UTF"
  MiX::Token_text,MiX::Token_eq,MiX::Token_dblquote,MiX::Token_text,
  //"-8\""
  MiX::Token_hyphen,MiX::Token_text,MiX::Token_dblquote,
  //"?><"
  MiX::Token_question,MiX::Token_gt,MiX::Token_lt,
  //"!>"
  MiX::Token_exclamation,MiX::Token_text,MiX::Token_gt,
  //"<ƤȤɤ °̾"
  MiX::Token_lt,MiX::Token_text,MiX::Token_space,MiX::Token_text,
  //"=\""
  MiX::Token_eq,MiX::Token_dblquote,MiX::Token_text,
  //"\"><"
  MiX::Token_dblquote,MiX::Token_gt,MiX::Token_lt,MiX::Token_text,
  //">Ƥ</"
  MiX::Token_gt,MiX::Token_text,MiX::Token_lt,MiX::Token_slash,
  //"><"
  MiX::Token_text,MiX::Token_gt,MiX::Token_lt,MiX::Token_text,
  //"/><!"
  MiX::Token_slash,MiX::Token_gt,MiX::Token_lt,MiX::Token_exclamation,
  //"-- "
  MiX::Token_hyphen,MiX::Token_hyphen,MiX::Token_space,
  //"ϥȤǤ -"
  MiX::Token_text,MiX::Token_space,MiX::Token_hyphen,
  //"-></"
  MiX::Token_hyphen,MiX::Token_gt,MiX::Token_lt,MiX::Token_slash,
  //"ƤȤɤ>"
  MiX::Token_text,MiX::Token_gt,MiX::Token_null,
};

void TokenizerTest::testConstruct(){
  tokenizer_ = new MiX::Tokenizer<char>();
  tokenizer_mbc_ = new MiX::Tokenizer<MBChar::MBChar,
    MBChar::MBCharTraits,MBChar::MBCXMLTraits>();
}

void TokenizerTest::testInject(){
  tokenizer_->injectString(teststring_);
  tokenizer_mbc_->injectString(MBChar::to_MBCS(teststring_mbc_).c_str());
}

void TokenizerTest::testEjectPush(){
  MiX::XMLToken<char> tok;
  MiX::XMLToken<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> tok_mbc;
  MiX::XMLToken<char> tok2;
  MiX::XMLToken<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> tok_mbc2;
  size_t n=0;
  long l=-1;
  do{
    tokenizer_->ejectToken(tok);
    tokenizer_mbc_->ejectToken(tok_mbc);
    //std::cout << tt_seq_[n] << "==" << tok_mbc.getType() << std::endl;
    CPPUNIT_ASSERT(tt_seq_[n]==tok.getType());
    CPPUNIT_ASSERT(tt_seq_[n]==tok_mbc.getType());
    CPPUNIT_ASSERT(l<tok_mbc.getIndex());
    l=tok_mbc.getIndex();
    tokenizer_->pushToken(tok);
    tokenizer_mbc_->pushToken(tok_mbc);
    tokenizer_->ejectToken(tok2);
    tokenizer_mbc_->ejectToken(tok_mbc2);
    CPPUNIT_ASSERT(tok2.getData()==tok.getData());
    CPPUNIT_ASSERT(tok_mbc2.getData()==tok_mbc.getData());
    ++n;
  }while(tok.getType()!=MiX::Token_null);
}

void TokenizerTest::testDestruct(){
  delete tokenizer_;
  delete tokenizer_mbc_;
}


void TokenizerTest::setUp(){
}

void TokenizerTest::tearDown(){
}

CppUnit::TestSuite* TokenizerTest::suite(){
  CppUnit::TestSuiteBuilder<TokenizerTest> builder("MultiByteChar");
  builder.addTestCaller("Construct",&TokenizerTest::testConstruct);
  builder.addTestCaller("Inject",&TokenizerTest::testInject);
  builder.addTestCaller("Eject&Push",&TokenizerTest::testEjectPush);
  builder.addTestCaller("Destruct",&TokenizerTest::testDestruct);
  return builder.takeSuite();
}

