#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <sstream>
#include <cmath> // rand
#include "Stress.test.h"

int* StressTest::data_ = 0;
std::string doc_str_ = "";
MBChar::MBCString doc_mbcs_ = MBChar::to_MBCS("");

void DomObjectsTest::testCreate(){
  data_ = new int[MiX_Test_STRESS];

  Document& doc = Document::create("TestDocument");
  DocumentMBC& doc_mbc = DocumentMBC::create(MBChar::to_MBCS("ƥ"));

  for(int i=0;i<MiX_Test_STRESS;++i){
    Element* el = &(doc.getRoot());
    ElementMBC* el_mbc = &(doc_mbc.getRoot());

    data_[i] = rand();
    for(int j=0;j<i+1;++j){
      el = &(Element::Create("Data",*el));
      el_mbc = &(ElementMBC::Create(MBChar::to_MBCS("ǡ"),*el_mbc));
      std::ostringstream so;
      so << data_[i] << std::ends;
      std::string s = so.str();
      MBChar::MBCString mbcs = MBChar::to_MBCS(so.str());
      el->setText(s);
      el_mbc->setText(mbcs);
      CPPUNIT_ASSERT(s==el->getText());
      CPPUNIT_ASSERT(mbcs==el_mbc->getText());
    }
  }
  doc_str_ = doc_->toString();
  doc_mbcs_ = doc_mbc_->toString();
}

void DomObjectsTest::testVerify(){
  DomParser parser;
  DomParserMBC parser_mbc; 
  Document& doc = parser.parse(doc_str_);
  DocumentMBC& doc_mbc = parser_mbc.parse(doc_mbcs_);
}

void DomObjectsTest::testDestroy(){
  delete data_;
}}


CppUnit::TestSuite* DomObjectsTest::suite(){
  CppUnit::TestSuiteBuilder<DomObjectsTest> builder("Stress");
  builder.addTestCaller("Create",&DomObjectsTest::testCreate);
  builder.addTestCaller("Verify",&DomObjectsTest::testVerify);
  builder.addTestCaller("Destroy",&DomObjectsTest::testDestroy);
  return builder.takeSuite();
}

