// -*- mode: C++ -*-
#ifndef MIX_TEST_SAXPARSER_H_
#define MIX_TEST_SAXPARSER_H_

#include <SAX_Parser.h>
#include <misc.h>

#include "MBC.h"

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>

enum EventType{
  Start,
  End,
  Text,
  Comment,
  XMLDecl,
  Attr
};

struct Event{
  EventType ev;
  const std::string name;
  const std::string name_mbc_;
  const std::string val;
  const std::string val_mbc_;
};

struct EventHandler_char : public MiX::SAX_EventHandler<char>{
  typedef MiX::AttrMap<char>AttrMap;
  typedef MiX::XMLString<char> XMLString;
  virtual void onXMLDeclaration(AttrMap attr);
  virtual void onStart(XMLString name,AttrMap attr);
  virtual void onEnd(XMLString name);
  virtual void onText(XMLString text);
  virtual void onComment(XMLString text);
  static int where_;
};

struct EventHandler_MBC
  : public MiX::SAX_EventHandler<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits>{
  typedef MiX::AttrMap<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> AttrMap;
  typedef MiX::XMLString<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> XMLString;
  virtual void onXMLDeclaration(AttrMap attr);
  virtual void onStart(XMLString sName,AttrMap attr);
  virtual void onEnd(XMLString sName);
  virtual void onText(XMLString sText);
  virtual void onComment(XMLString sText);
  static int where_;
};

class SAX_ParserTest : public CppUnit::TestCase{
  static MiX::SAX_Parser<char>* parser_;
  static MiX::SAX_Parser<MBChar::MBChar,MBChar::MBCharTraits,
			 MBChar::MBCXMLTraits>* parser_mbc_;
  
  static const char teststring_[];
  static const char teststring_mbc_[];

  void testConstruct();
  void testParse();
  void testDestruct();
public:
  static CppUnit::TestSuite* suite();
  static const Event ev_[];

};

#endif
