#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <cstring> // strcmp

#include <DefaultXMLTraits.h>
#include <SAX_Parser.h>
#include <misc.h>
#include "SAX_Parser.test.h"
#include "testutil.h"

MiX::SAX_Parser<char>* SAX_ParserTest::parser_ = 0;
MiX::SAX_Parser<MBChar::MBChar,MBChar::MBCharTraits,
	       MBChar::MBCXMLTraits>* SAX_ParserTest::parser_mbc_ = 0;

int EventHandler_char::where_ = 0;
int EventHandler_MBC::where_ = 0;

const char SAX_ParserTest::teststring_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<!Decralation>"
  "<TestDocument Attribute=\"Attribute\">"
  "<TestElement>ThisIsTest</TestElement>"
  "<TestElement/>"
  "<!-- ThisIsComment -->"
  "</TestDocument>"
};

const char SAX_ParserTest::teststring_mbc_[] = {
  "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>"
  "<!>"
  "<ƤȤɤ °̾=\"\">"
  "<>Ƥ</>"
  "</>"
  "<!-- ϥȤǤ -->"
  "</ƤȤɤ>"
};

const Event SAX_ParserTest::ev_[] = {
  { XMLDecl, "", "", "", ""},
  { Attr, "version", "version", "1.0", "1.0"},
  { Attr, "encoding", "encoding", "UTF-8", "EUC-JP"},
  { Start, "TestDocument", "ƤȤɤ", "", ""},
  { Attr, "Attribute", "°̾", "Attribute", ""},
  { Start, "TestElement", "", "", ""},
  { Text, "", "", "ThisIsTest", "Ƥ"},
  { End, "TestElement", "", "", ""},
  { Start, "TestElement", "", "", ""},
  { End, "TestElement", "", "", ""},
  { Comment, "", "", " ThisIsComment ", " ϥȤǤ "},
  { End, "TestDocument", "ƤȤɤ", "", ""}
};

void EventHandler_char::onXMLDeclaration(EventHandler_char::AttrMap attr){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,XMLDecl);
  ++where_;

  while(SAX_ParserTest::ev_[where_].ev==Attr){
    //std::cout << SAX_ParserTest::ev_[where_].name << std::endl;
    CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,SAX_ParserTest::ev_[where_].val,attr[SAX_ParserTest::ev_[where_].name]);
    ++where_;
  }
}
void EventHandler_char::onStart(EventHandler_char::XMLString name,EventHandler_char::AttrMap attr){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Start);
  CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,SAX_ParserTest::ev_[where_].name,name);
  ++where_;
  while(SAX_ParserTest::ev_[where_].ev==Attr){
    CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,attr[SAX_ParserTest::ev_[where_].name],SAX_ParserTest::ev_[where_].val);
    ++where_;
  }
}
void EventHandler_char::onEnd(EventHandler_char::XMLString name){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,End);
  CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,SAX_ParserTest::ev_[where_].name,name);
  ++where_;
}
void EventHandler_char::onText(EventHandler_char::XMLString text){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Text);
  CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,SAX_ParserTest::ev_[where_].val,text);
  ++where_;
}
void EventHandler_char::onComment(EventHandler_char::XMLString text){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Comment);
  CPPUNIT_ASSERT_EQUAL_WITH_CAST(std::string,SAX_ParserTest::ev_[where_].val,text);
  ++where_;
}

void EventHandler_MBC::onXMLDeclaration(EventHandler_MBC::AttrMap attr){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,XMLDecl);
  ++where_;

  while(SAX_ParserTest::ev_[where_].ev==Attr){
    CPPUNIT_ASSERT_EQUAL(MBChar::to_str(attr[MBChar::to_MBCS(SAX_ParserTest::ev_[where_].name_mbc_.c_str())].c_str()),
			 SAX_ParserTest::ev_[where_].val_mbc_);
    ++where_;
  }
}
void EventHandler_MBC::onStart(EventHandler_MBC::XMLString name,EventHandler_MBC::AttrMap attr){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Start);
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].name_mbc_,
		       MBChar::to_str(name.c_str()));
  ++where_;
  while(SAX_ParserTest::ev_[where_].ev==Attr){
    CPPUNIT_ASSERT_EQUAL(MBChar::to_str(attr[MBChar::to_MBCS(SAX_ParserTest::ev_[where_].name_mbc_.c_str())].c_str()),
			 SAX_ParserTest::ev_[where_].val_mbc_);
    ++where_;
  } 
}
void EventHandler_MBC::onEnd(EventHandler_MBC::XMLString name){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,End);
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].name_mbc_,
		       MBChar::to_str(name.c_str()));
  ++where_;
}
void EventHandler_MBC::onText(EventHandler_MBC::XMLString text){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Text);
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].val_mbc_,
		       MBChar::to_str(text.c_str()));
  ++where_;
}
void EventHandler_MBC::onComment(EventHandler_MBC::XMLString text){
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].ev,Comment);
  CPPUNIT_ASSERT_EQUAL(SAX_ParserTest::ev_[where_].val_mbc_,
		       MBChar::to_str(text.c_str()));
  ++where_;
}


void SAX_ParserTest::testConstruct(){
  parser_ = new MiX::SAX_Parser<char>;
  parser_mbc_ = new MiX::SAX_Parser<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits>;
}

void SAX_ParserTest::testParse(){
  EventHandler_char ev_hdl;
  EventHandler_MBC ev_hdl_MBC;
  
  parser_->setEventHandler(&ev_hdl);
  parser_mbc_->setEventHandler(&ev_hdl_MBC);
  parser_->parse(teststring_);
  //try{
  MBChar::MBCString str = MBChar::to_MBCS(teststring_mbc_);
  parser_mbc_->parse(str.c_str());
    //}catch(const std::exception& e){
    //std::cout << "MBC" << std::endl << e.what() << std::endl;
    //}
}

void SAX_ParserTest::testDestruct(){
  delete parser_;
  delete parser_mbc_;
}

CppUnit::TestSuite* SAX_ParserTest::suite(){
  CppUnit::TestSuiteBuilder<SAX_ParserTest> builder("SAX_Parser");
  builder.addTestCaller("Construct",&SAX_ParserTest::testConstruct);
  builder.addTestCaller("Parse",&SAX_ParserTest::testParse);
  builder.addTestCaller("Destruct",&SAX_ParserTest::testDestruct);
  return builder.takeSuite();
}

