#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <cstring> // strcmp

#include "MBC.h"
#include "MBC.test.h"

void MBCTest::testConstruct(){
  const char str[] = "ˤ(Hello World)";
  MBChar::MBCString s1=MBChar::to_MBCS(str);
  CPPUNIT_ASSERT(!std::strcmp(to_str(s1.c_str()).c_str(),str));
  CPPUNIT_ASSERT(s1.length()==21);
}

void MBCTest::testIterator(){
  const char str[] = "꡼˾";
  MBChar::MBCString s1=MBChar::to_MBCS(str);
  MBChar::MBCString::iterator it = s1.begin();
  MBChar::MBCString::iterator last = s1.end();
  size_t n=0;
  for( ;it!=last;++it){
    const char* d=it->getData();
    CPPUNIT_ASSERT(d[0]==str[n]);
    CPPUNIT_ASSERT(d[1]==str[n+1]);
    n+=2;
  }
}

void MBCTest::testOperation(){
  const char str[] = "ҤεԤ֤ǵҤޤ";
  MBChar::MBCString s1=MBChar::to_MBCS(str);

  CPPUNIT_ASSERT(MBChar::to_str(s1.substr( 0,2).c_str())=="");
  CPPUNIT_ASSERT(MBChar::to_str(s1.substr( 3,2).c_str())=="");
  CPPUNIT_ASSERT(MBChar::to_str(s1.substr( 6,2).c_str())=="");
  CPPUNIT_ASSERT(MBChar::to_str(s1.substr( 9,2).c_str())=="");
}

void MBCTest::setUp(){
}

void MBCTest::tearDown(){
}

CppUnit::TestSuite* MBCTest::suite(){
  CppUnit::TestSuiteBuilder<MBCTest> builder("MultiByteChar");
  builder.addTestCaller("Construct",&MBCTest::testConstruct);
  builder.addTestCaller("Iterator",&MBCTest::testIterator);
  builder.addTestCaller("Operation",&MBCTest::testOperation);
  return builder.takeSuite();
}
