// -*- mode:C++ -*-
#ifndef MIX_TEST_MBC_H_
#define MIX_TEST_MBC_H_

#include <iostream>
#include <iterator>

namespace MBChar{

/**
 * 桼ʸ饹
 */
class MBChar{
  char data_[2];
public:
  bool isKanji()const;
  MBChar();
  MBChar(char c);
  MBChar(char c1,char c2);
  MBChar(const MBChar& src);
  operator unsigned long()const;
  bool operator==(const char* s)const;
  const char* getData()const;
  char* getData();
  static bool isKanji1stByte(char c);
  friend std::ostream& operator<<(std::ostream& os,const MBChar& c);
};

/**
 * 桼ʸ饹Traits
 */
struct MBCharTraits{
  typedef MBChar char_type;
  typedef unsigned long int_type;
  //typedef streampos pos_type;
  //typedef streamoff off_type;
  //typedef mb_state_t state_type;

  static int_type to_int_type(const char_type& c);
  static void assign(char_type& c1,const char_type& c2);
  static bool eq(const char_type& c1,const char_type& c2);
  static bool lt(const char_type& c1,const char_type& c2);
  static int compare(const char_type* s1,const char_type* s2,size_t n);
  static size_t length(const char_type* s);
  static const char_type* find(const char_type* s,size_t n,
			       const char_type& a);
  static char_type* move(char_type* s1,const char_type* s2,size_t n);
  static char_type* copy(char_type* s1,const char_type* s2,size_t n);
  static char_type* assign(char_type* s,size_t n,char_type a);
  static char_type to_char_type(const int_type& c);
  static bool eq_int_type(const int_type& c1,const int_type& c2);
  static int_type eof();
  static int_type not_eof(const int_type& c);
};

/**
 * 桼ʸ饹XMLTraits
 */
class MBCXMLTraits{
public:
  typedef MBChar char_type;
  typedef MBCharTraits traits_type;
public:
  static char_type null();
  static char_type crlf();
  static char_type sp();
  static char_type tab();

  static char_type lt();
  static char_type gt();
  static char_type eq();

  static char_type slash();
  static char_type hyphen();
  static char_type colon();
  static char_type semicolon();

  static char_type exclamation();
  static char_type question();
  static char_type amp();
  static char_type dblquote();
  static char_type quote();

  static std::basic_string<char_type,traits_type> xml();
  static std::basic_string<char_type,traits_type> cdata();
  static std::basic_string<char_type,traits_type> str_lt();
  static std::basic_string<char_type,traits_type> str_gt();
  static std::basic_string<char_type,traits_type> str_amp();
  static std::basic_string<char_type,traits_type> str_quot();
  static std::basic_string<char_type,traits_type> str_apos();
  static int ci_compare(const char_type* s1,const char_type* s2,
			size_t n);
};

//MBCharstring
typedef std::basic_string<MBChar,MBCharTraits> MBCString;

//MBCharʸstd::string
std::string to_str(const MBChar* src);
void to_str(const MBChar* src,char* buf,size_t size);
MBCString to_MBCS(const char* src);
void to_MBCS(const char* src,MBChar* buf,size_t size);

std::ostream& operator <<(std::ostream& os,const MBCString& str);

}
#endif
