// -*- mode: C++ -*-
#ifndef MIX_TEST_DOMOBJECTS_H_
#define MIX_TEST_DOMOBJECTS_H_

#include <DefaultXMLTraits.h>
#include <Document.h>
#include <Element.h>
#include <Attribute.h>
#include <Text.h>
#include <Comment.h>

#include "MBC.h"

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>

class DOM_ObjectsTest : public CppUnit::TestCase{
  typedef MiX::Document<char> Document;
  typedef MiX::Document<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> DocumentMBC;
  typedef MiX::Element<char> Element;
  typedef MiX::Element<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> ElementMBC;
  typedef MiX::Attribute<char> Attribute;
  typedef MiX::Attribute<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> AttributeMBC;
  typedef MiX::Text<char> Text;
  typedef MiX::Text<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> TextMBC;
  typedef MiX::Comment<char> Comment;
  typedef MiX::Comment<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> CommentMBC;

  static Document* doc_;
  static DocumentMBC* doc_mbc_;
  void testDocument();
  void testElement();
  void testAttribute();
  void testText();
  void testComment();
  void testDestroy();
  void testOperation();
public:
  static CppUnit::TestSuite* suite();

};

#endif
