#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <cstring> // strcmp

#include "DOM_Objects.test.h"

DOM_ObjectsTest::Document* DOM_ObjectsTest::doc_ = 0;
DOM_ObjectsTest::DocumentMBC* DOM_ObjectsTest::doc_mbc_ = 0;


void DOM_ObjectsTest::testDocument(){
  doc_ = &Document::create("TestDocument");
  doc_mbc_ = &DocumentMBC::create(MBChar::to_MBCS("ƥ"));
  CPPUNIT_ASSERT(doc_->getType()==MiX::Node_Document);
  CPPUNIT_ASSERT(doc_mbc_->getType()==MiX::Node_Document);
  //ñ˴Υƥ(˴testDestroyǡ)
  doc_->destroy();
  doc_mbc_->destroy();
  //褵롣ǻȤ顣
  doc_ = &Document::create("TestDocument");
  doc_mbc_ = &DocumentMBC::create(MBChar::to_MBCS("ƥ"));
}


void DOM_ObjectsTest::testElement(){
  CPPUNIT_ASSERT(doc_->getRoot().getName()=="TestDocument");
  CPPUNIT_ASSERT(doc_mbc_->getRoot().getName()==MBChar::to_MBCS("ƥ"));
  CPPUNIT_ASSERT(doc_->getRoot().getType()==MiX::Node_Element);
  CPPUNIT_ASSERT(doc_mbc_->getRoot().getType()==MiX::Node_Element);
  Element& el = Element::create("TempElement",doc_->getRoot());
  ElementMBC& elMBC=ElementMBC::create(MBChar::to_MBCS("ƥݥ"),doc_mbc_->getRoot());
  //elȻҤɤˤʤäƤ뤫ɤå
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&el)
		 != doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&elMBC)
		 != doc_mbc_->getRoot().getChildren().end());
  //⤦Ȥʤ
  el.destroy();
  elMBC.destroy();
  //el˴줿
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&el)
		 == doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&elMBC)
		 == doc_mbc_->getRoot().getChildren().end());
}

void DOM_ObjectsTest::testAttribute(){
  Attribute& att=Attribute::create("name","val",doc_->getRoot());
  AttributeMBC& attMBC=AttributeMBC::create(MBChar::to_MBCS("°̾"),MBChar::to_MBCS(""),doc_mbc_->getRoot());
  CPPUNIT_ASSERT(att.getType()==MiX::Node_Attribute);
  CPPUNIT_ASSERT(attMBC.getType()==MiX::Node_Attribute);
  //Document°򤯤äĤ
  Attribute::create("encoding","UTF-8",*doc_);
  Attribute::create("version","1.0",*doc_);
  AttributeMBC::create(MBChar::to_MBCS("encoding"),MBChar::to_MBCS("EUC-JP"),*doc_mbc_);
  AttributeMBC::create(MBChar::to_MBCS("version"),MBChar::to_MBCS("1.0"),*doc_mbc_);
  //attȻҤɤˤʤäƤ뤫ɤå
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&att)
		 != doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&attMBC)
		 != doc_mbc_->getRoot().getChildren().end());
  //ͤ̾Υå
  CPPUNIT_ASSERT(att.getName()=="name");
  CPPUNIT_ASSERT(att.getValue()=="val");
  CPPUNIT_ASSERT(attMBC.getName()==MBChar::to_MBCS("°̾"));
  CPPUNIT_ASSERT(attMBC.getValue()==MBChar::to_MBCS(""));
  //˴å
  att.destroy();
  attMBC.destroy();
  //att˴줿
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&att)
		 == doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&attMBC)
		 == doc_mbc_->getRoot().getChildren().end());
  //ޤȤ
  Attribute::create("name","val",doc_->getRoot());
  AttributeMBC::create(MBChar::to_MBCS("°̾"),MBChar::to_MBCS(""),doc_mbc_->getRoot());
}

void DOM_ObjectsTest::testText(){
  //std::cout << "+testText" << std::endl;
  Text& txt=Text::create("TestText",doc_->getRoot());
  TextMBC& txtMBC=TextMBC::create(MBChar::to_MBCS("ƥText"),doc_mbc_->getRoot());
  //txtȻҤɤˤʤäƤa뤫ɤå
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&txt)
		 != doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&txtMBC)
		 != doc_mbc_->getRoot().getChildren().end());
  //ͤ̾Υå
  CPPUNIT_ASSERT(txt.getValue()=="TestText");
  CPPUNIT_ASSERT(txtMBC.getValue()==MBChar::to_MBCS("ƥText"));
  //˴å
  txt.destroy();
  txtMBC.destroy();
  //txt˴줿
  //CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
  //			   doc_->getRoot().getChildren().end(),&txt)
  //		 == doc_->getRoot().getChildren().end());
//  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
//			   doc_mbc_->getRoot().getChildren().end()
//			   ,&txtMBC)
//		 == doc_mbc_->getRoot().getChildren().end());
  //ޤȤ
  Text::create("TestText",doc_->getRoot());
  TextMBC::create(MBChar::to_MBCS("ƥText"),doc_mbc_->getRoot());
  //std::cout << "-testText" << std::endl;
}

void DOM_ObjectsTest::testComment(){
  //std::cout << "+testComment" << std::endl;
  Comment& com=Comment::create("comment",doc_->getRoot());
  CommentMBC& comMBC=CommentMBC::create(MBChar::to_MBCS(""),doc_mbc_->getRoot());
  //comȻҤɤˤʤäƤ뤫ɤå
  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
			   doc_->getRoot().getChildren().end(),&com)
		 != doc_->getRoot().getChildren().end());
  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
			   doc_mbc_->getRoot().getChildren().end()
			   ,&comMBC)
		 != doc_mbc_->getRoot().getChildren().end());
  //ͤ̾Υå
  CPPUNIT_ASSERT(com.getValue()=="comment");
  CPPUNIT_ASSERT(comMBC.getValue()==MBChar::to_MBCS(""));
  //˴å
  com.destroy();
  comMBC.destroy();
  //com˴줿
//  CPPUNIT_ASSERT(std::find(doc_->getRoot().getChildren().begin(),
//			   doc_->getRoot().getChildren().end(),&com)
//		 == doc_->getRoot().getChildren().end());
//  CPPUNIT_ASSERT(std::find(doc_mbc_->getRoot().getChildren().begin(),
//			   doc_mbc_->getRoot().getChildren().end()
//			   ,&comMBC)
//		 == doc_mbc_->getRoot().getChildren().end());
  //ޤȤ
  Comment::create("comment",doc_->getRoot());
  CommentMBC::create(MBChar::to_MBCS(""),doc_mbc_->getRoot());
  //std::cout << "-testComment" << std::endl;
}

void DOM_ObjectsTest::testOperation(){
  //Element
  CPPUNIT_ASSERT(doc_->getRoot().getText()=="TestText");
  CPPUNIT_ASSERT(doc_mbc_->getRoot().getText()==MBChar::to_MBCS("ƥText"));
  doc_->getRoot().setText("2ndTestText");
  doc_mbc_->getRoot().setText(MBChar::to_MBCS("ܤľ"));
  CPPUNIT_ASSERT(doc_->getRoot().getText()=="2ndTestText");
  CPPUNIT_ASSERT(doc_mbc_->getRoot().getText()==MBChar::to_MBCS("ܤľ"));
  CPPUNIT_ASSERT(doc_->getRoot()["name"].getValue()=="val");
  CPPUNIT_ASSERT(doc_mbc_->getRoot()[MBChar::to_MBCS("°̾")].getValue()==MBChar::to_MBCS(""));

  CPPUNIT_ASSERT(doc_->getRoot().hasAttribute("name"));
  CPPUNIT_ASSERT(!doc_->getRoot().hasAttribute("tekito"));
  CPPUNIT_ASSERT(doc_mbc_->getRoot().hasAttribute(MBChar::to_MBCS("°̾")));
  CPPUNIT_ASSERT(!doc_mbc_->getRoot().hasAttribute(MBChar::to_MBCS("Ŭ")));
  //Document
  CPPUNIT_ASSERT(doc_->hasAttribute("encoding"));
  CPPUNIT_ASSERT(!doc_->hasAttribute("nomean"));
  CPPUNIT_ASSERT(doc_mbc_->hasAttribute(MBChar::to_MBCS("version")));
  CPPUNIT_ASSERT(!doc_mbc_->hasAttribute(MBChar::to_MBCS("")));
  //Attribute
  //Text
  //Comment
}


void DOM_ObjectsTest::testDestroy(){
  doc_->destroy();
  doc_mbc_->destroy();
}


CppUnit::TestSuite* DOM_ObjectsTest::suite(){
  CppUnit::TestSuiteBuilder<DOM_ObjectsTest> builder("DOMObjects");
  builder.addTestCaller("Document",&DOM_ObjectsTest::testDocument);
  builder.addTestCaller("Element",&DOM_ObjectsTest::testElement);
  builder.addTestCaller("Attribute",&DOM_ObjectsTest::testAttribute);
  builder.addTestCaller("Text",&DOM_ObjectsTest::testText);
  builder.addTestCaller("Comment",&DOM_ObjectsTest::testComment);
  builder.addTestCaller("Operation",&DOM_ObjectsTest::testOperation);
  builder.addTestCaller("Destroy",&DOM_ObjectsTest::testDestroy);
  return builder.takeSuite();
}

