// -*- mode: c++ -*-

#ifndef MIX_XMLTOKEN_H_
#define MIX_XMLTOKEN_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"

namespace MiX{
  enum TokenType{
    Token_null = 0,
    Token_crlf,
    Token_space,
    Token_tab,
    Token_lt,
    Token_eq,
    Token_gt,
    Token_slash,
    Token_hyphen,
    Token_semicolon,
    Token_exclamation,
    Token_question,
    Token_amp,
    Token_dblquote,
    Token_quote,
    Token_text = 100
  };
  /**
   * TokenizerϤȡ򤢤魯饹 (ѥ饹Ǥ)
   *
   * ʸȼȤΰ־äƤޤ
   * ־ϥ顼λ˻Ȥޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class XMLToken {
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef XMLToken<Char,Traits,XMLTraits> this_type;
  private:
    XMLString<Char,Traits,XMLTraits> str_;
    TokenType type_;
    long index_;
  public:
    ///󥹥ȥ饯
    XMLToken()
      : type_(Token_null),index_(-1){ };
    ///󥹥ȥ饯
    XMLToken(const Char* first,const Char* last,TokenType type,long index);
    ///ʸޤ
    string_type& getData() { return str_; };
    ///ȡ󥿥פޤ
    TokenType getType() { return type_; };
    ///֤ޤ
    long getIndex() { return index_; };
  };
}

#ifndef MIX_XMLTOKEN_CPP_
#include "XMLToken.cpp"
#endif

#endif
