// -*- mode: c++ -*-

#ifndef MIX_TOKENIZER_H_
#define MIX_TOKENIZER_H_


#include "classes.h"
#include "misc.h"
#include "XMLToken.h"

#include <stack>
#include <string>

namespace MiX{
  /**
   * $BFbIt$GMxMQ$9$k%H!<%/%J%$%6(B
   *
   * $B%H!<%/%s$N0UL#$r9M$($:$K$H$K$+$/:Y$+$/@Z$jJ,$1$F$$$/(B
   * $B0UL#$r9M$($J$$$N$G!"IaDL$NJ8;zNsCf$K=P$F$/$k(B'-'$B$H!"(B"<!--"$BFb$N(B
   * '-'$B$rF1$8%H!<%/%s$H$7$F=PNO$9$k(B
   * SAX_Parser$B$,$3$N4JC1$J=PNO$+$i0UL#$r2r<a$7%$%Y%s%H$r5/$3$9(B
   */
  template <class Char,class Traits,class XMLTraits>
  class Tokenizer{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef Tokenizer<Char,Traits,XMLTraits> this_type;
    typedef XMLToken<Char,Traits,XMLTraits> token_type;
  private:
    const Char* data_;
    const Char* start_;
    const Char* current_;
    long len_;
    static const Char tokens_[];//m_pTokens[];
    MiX_STD::stack<token_type> stack_;
    static TokenType isToken(Char);
  public:
    ///$B%3%s%9%H%i%/%?(B
    Tokenizer(){ };
    ///$B%H!<%/%J%$%6$KJ8;zNs$rF~$l$k(B
    bool injectString(const Char* text)
      { current_ = start_ = data_ = text; return true; };
    ///$B%H!<%/%J%$%6$N@hF,$K$"$k%H!<%/%s$r<h$j=P$9(B
    bool ejectToken(XMLToken<Char,Traits,XMLTraits>& dest);
    ///$B%H!<%/%J%$%6$N@hF,$K;XDj$7$?%H!<%/%s$r2!$79~$`(B
    void pushToken(const XMLToken<Char,Traits,XMLTraits>& tok){
      stack_.push(tok);
    }
  };

}

#ifndef MIX_TOKENIZER_CPP_
#include "Tokenizer.cpp"
#endif

#endif
