#define MIX_SAXPARSER_CPP_
#include <queue>
#include <cstring>
#include <strstream>

#include "SAX_Parser.h"
#include "misc.h"
#include "ParsingException.h"

#include <ctype.h>


namespace MiX{
  template <class Char,class Traits,class XMLTraits>
  bool SAX_Parser<Char,Traits,XMLTraits>::parse(const Char* szText){
    if(handler_==NULL){
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Invalid Handler" << MiX_STD::endl << MiX_STD::ends;
      throw ParsingException(-1,InvalidHandler,sout.str());
      return false;
    }
    tokenizer_.injectString(szText);

    state_ = STATE_Text;
    while(state_!=STATE_Complete && state_!=STATE_Exception){
      if(state_==STATE_Text)
	state_ = parseText();
      else if(state_==STATE_Tag)
	state_ = parseTag();
      else if(state_==STATE_Comment)
	state_ = parseComment();
      else if(state_==STATE_Declaration)
	state_ = parseDeclaration();
      else if(state_==STATE_XMLDeclaration)
	state_ = parseXMLDeclaration();
    }
    if(state_ == STATE_Exception) return false;
    return true;
  }
  
  
  template <class Char,class Traits,class XMLTraits>
  void SAX_Parser<Char,Traits,XMLTraits>::skipSpaceTokens(){
    XMLToken<Char,Traits,XMLTraits> tok;
    tokenizer_.ejectToken(tok);
    while(tok.getType()==Token_crlf ||
	  tok.getType()==Token_space ||
	  tok.getType()==Token_tab){
      tokenizer_.ejectToken(tok);
    }
    //Ǹ˰Ф򤸤ʤȡ򲡤᤹
    tokenizer_.pushToken(tok);
  }
  
  template <class Char,class Traits,class XMLTraits>
  SAX_Parser<Char,Traits,XMLTraits>::State SAX_Parser<Char,Traits,XMLTraits>::parseText(){
    XMLToken<Char,Traits,XMLTraits> tok;
    XMLString<Char,Traits,XMLTraits> sText;
    State ret = STATE_Complete; 
    
    if(ignore_space_) skipSpaceTokens();
    
    while(tokenizer_.ejectToken(tok)){
      if(tok.getType()==Token_lt){
	// "<"򸫤ĤTagϥ⡼ɤ
	ret = STATE_Tag;
	break;
      }else if(tok.getType()==Token_amp){
	// "&"򸫤ĤλȲϥ⡼ɤ
	sText += parseReference();
      }else if(tok.getType()==Token_gt){
	// ">"򸫤Ĥ饨顼
	std::ostringstream sout;
	sout << "ParsingException" << MiX_STD::endl
	     << "Unexpected token in " << tok.getIndex() 
	     << MiX_STD::endl << MiX_STD::ends;
	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	  return STATE_Exception;
	}
      }else{
	//ʳΥȡϤǤ̵̣ʤΤǡʸɲá
	sText += tok.getData();
      }
    }
    trimRight(sText);
    if(sText.length()!=0) handler_->onText(sText);
    return ret;
  }
  
  template <class Char,class Traits,class XMLTraits>
  SAX_Parser<Char,Traits,XMLTraits>::State SAX_Parser<Char,Traits,XMLTraits>::parseTag(){
    XMLToken<Char,Traits,XMLTraits> tok;
    bool bEnd = false;
    
    skipSpaceTokens();
    tokenizer_.ejectToken(tok);  
    if(tok.getType()==Token_text){
      
      tokenizer_.pushToken(tok);
    }else if(tok.getType()==Token_slash){
      //å夫Ϥޤ륿ʤ顢λ
      bEnd = true;
    }else if(tok.getType()==Token_exclamation){
      //"!"Ϥޤ
      return STATE_Declaration;
    }else if(tok.getType()==Token_question){
      //"?"ϤޤXML
      return STATE_XMLDeclaration;
    }else{
      //λϤޤ꤬
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Invalid Tag in " << tok.getIndex() << MiX_STD::endl
	   << "(expected !,?,/ or text)"<< MiX_STD::endl << MiX_STD::ends;
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	return STATE_Exception;
      }
    }
    
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_text){
      //̾ʤХ
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "TagName not found in " << tok.getIndex() 
	   << MiX_STD::endl << MiX_STD::ends;
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	return STATE_Exception;
      }
    }
    XMLString<Char,Traits,XMLTraits> sName = tok.getData();
    
    if(bEnd){
      skipSpaceTokens();
      tokenizer_.ejectToken(tok);
      if(tok.getType()!=Token_gt){
	//">"ʤ㥨顼
	std::ostringstream sout;
	sout << "ParsingException" << MiX_STD::endl
	     << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	     << "(Expected \'>\')" << MiX_STD::endl << MiX_STD::ends;

	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	  return STATE_Exception;
	}
      }
      if(validator_.top()!=sName){
	std::ostringstream sout;
	sout << "Element mismatch Element in " 
	     << tok.getIndex() << MiX_STD::endl << MiX_STD::ends;
	
	if(handler_->onException(ParsingException(tok.getIndex(),MismatchElement,sout.str()))){	
	  return STATE_Exception;
	}
      }
      validator_.pop();
      handler_->onEnd(sName);
      if(validator_.empty()){
	skipSpaceTokens();
	tokenizer_.ejectToken(tok);
	if(tok.getType()!=Token_null){
	  //ɥȥ롼Ȥäˤʤ󤫤
	  std::ostringstream sout;
	  sout << "ParsingException" << MiX_STD::endl
	       << "Unexpected token in " 
	       << tok.getIndex() << MiX_STD::endl
	       << "(Expected \'(null)\')" << MiX_STD::endl << MiX_STD::ends; 
	  if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	    return STATE_Exception;
	  }
	}
	return STATE_Complete;
      }
    }else{
      AttrMap<Char,Traits,XMLTraits> atts = parseAttributes();
      skipSpaceTokens();
      tokenizer_.ejectToken(tok);
      if(tok.getType()==Token_slash){
      //"/"齪λά륿
	bEnd = true;
	skipSpaceTokens();
	tokenizer_.ejectToken(tok);
      }
      if(tok.getType()!=Token_gt){
	//">"ʤ㥨顼
	std::ostringstream sout;
	sout << "ParsingException" << MiX_STD::endl
	     << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	     << "(Expected \'>\')" << MiX_STD::endl << MiX_STD::ends; 
	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	  return STATE_Exception;
	}
      }
      if(!bEnd) validator_.push(sName);
      handler_->onStart(sName,atts);
      if(bEnd) handler_->onEnd(sName);
      if(validator_.empty()){
	skipSpaceTokens();
	tokenizer_.ejectToken(tok);
	if(tok.getType()!=Token_null){
	  //ɥȥ롼Ȥäˤʤ󤫤롪
	  std::ostringstream sout;
	  sout << "ParsingException" << MiX_STD::endl
	       << "Unexpected token in " <<tok.getIndex()<< MiX_STD::endl
	       << "(Expected \'(null)\')" << MiX_STD::endl << MiX_STD::ends;
	  
	  if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	    return STATE_Exception;
	  }
	}
	return STATE_Complete;
      }
    }
    return STATE_Text;
    
  }
  
  
  template <class Char,class Traits,class XMLTraits>
  AttrMap<Char,Traits,XMLTraits> SAX_Parser<Char,Traits,XMLTraits>::parseAttributes(){
    
    XMLToken<Char,Traits,XMLTraits> tok;
    
    skipSpaceTokens();
    AttrMap<Char,Traits,XMLTraits> mapRet;
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_text){
      
      tokenizer_.pushToken(tok);
      return mapRet;
    }
    while(tok.getType()==Token_text){
      XMLString<Char,Traits,XMLTraits> sName(tok.getData());
      skipSpaceTokens();
      tokenizer_.ejectToken(tok);
      if(tok.getType()!=Token_eq) {
	std::ostringstream sout;
	sout << "ParsingException" << MiX_STD::endl
	     << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	     << "(Expected \'=\')" << MiX_STD::endl << MiX_STD::ends; 
	
	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	  state_ = STATE_Exception;
	  return AttrMap<Char,Traits,XMLTraits>();
	}
	////ߺ(Attribute=ʤ̾ΤߤAttributeȤ)
	////ΤȤȥ
	//mapRet.insert(pair<XMLString<Char,Traits,XMLTraits>,
	//XMLString<Char,Traits,XMLTraits> >
	//(sName,XMLString<Char,Traits,XMLTraits>()));
	continue;
      }
      skipSpaceTokens();
      tokenizer_.ejectToken(tok);
      TokenType quote = tok.getType();
      if(quote!=Token_dblquote && quote!=Token_quote){
	std::ostringstream sout;
	sout << "ParsingException" << MiX_STD::endl
	     << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	     << "(Expected \' or \" )" << MiX_STD::endl << MiX_STD::ends; 
	
	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	  state_ = STATE_Exception;
	  return AttrMap<Char,Traits,XMLTraits>();
	}
	////ߺ(quote̵ʾϤ뤳ȤȤ)
	//XMLToken<Char,Traits,XMLTraits> tokquote(0,0,Token_quote,-1);
	//quote = Token_quote;
	//stack<XMLToken<Char,Traits,XMLTraits> > buf;
	////buf.push(tok);
	//tokenizer_.ejectToken(tok);
	//while(tok.getType()!=Token_crlf &&
	//    tok.getType()!=Token_space &&
	//    tok.getType()!=Token_tab){
	//buf.push(tok);
	//tokenizer_.ejectToken(tok);
	//}
	//tokenizer_.pushToken(tok);
	//tokenizer_.pushToken(tokquote);
	//while(!buf.empty()){
	//tokenizer_.pushToken(buf.top());
	//buf.pop();
	//}
	//ߺֽ
      }
      XMLString<Char,Traits,XMLTraits> sVal;
      tokenizer_.ejectToken(tok);
      while(tok.getType()!=quote){
	sVal += tok.getData();
	tokenizer_.ejectToken(tok);
      }
      mapRet.insert(MiX_STD::pair<XMLString<Char,Traits,XMLTraits>,XMLString<Char,Traits,XMLTraits> >(sName,sVal));
      skipSpaceTokens();
      tokenizer_.ejectToken(tok);
    }
    tokenizer_.pushToken(tok);
    return mapRet;
  }
  
  template <class Char,class Traits,class XMLTraits>
  SAX_Parser<Char,Traits,XMLTraits>::State SAX_Parser<Char,Traits,XMLTraits>::parseDeclaration(){
    XMLToken<Char,Traits,XMLTraits> tok;
    tokenizer_.ejectToken(tok);
    if(tok.getType()==Token_hyphen){
      tokenizer_.ejectToken(tok);
      if(tok.getType()==Token_hyphen) return STATE_Comment;
    }
    do{
      tokenizer_.ejectToken(tok);
      if(tok.getType()==Token_null){
	std::ostringstream sout;
	sout<< "ParsingException" << MiX_STD::endl
	    << "Unexpected end of document" << MiX_STD::endl << MiX_STD::ends;
	
	if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedEOD,sout.str()))){
	  return STATE_Exception;
	}
      }
    }while(tok.getType()!=Token_gt);
    return STATE_Text;
  }
  
  template <class Char,class Traits,class XMLTraits>
  SAX_Parser<Char,Traits,XMLTraits>::State SAX_Parser<Char,Traits,XMLTraits>::parseXMLDeclaration(){
    
    skipSpaceTokens();
    XMLToken<Char,Traits,XMLTraits> tok;
    tokenizer_.ejectToken(tok);
    if(0!=XMLTraits::ci_compare(tok.getData().c_str(),
				XMLTraits::xml().c_str(),
				/*strlen("xml")+1*/4)){
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	   << "(Expected \"xml\")" << MiX_STD::endl << MiX_STD::ends;  
      
      if(handler_->onException(ParsingException(tok.getIndex(),InvalidDeclaration,sout.str()))){
	return STATE_Exception;
      }
    }
    AttrMap<Char,Traits,XMLTraits> atts=parseAttributes();
    handler_->onXMLDeclaration(atts);
    skipSpaceTokens();
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_question){
      
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	   << "(Expected \'?\' )" << MiX_STD::endl << MiX_STD::ends; 
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	return STATE_Exception;
      }
      tokenizer_.pushToken(tok);
    }
    skipSpaceTokens();
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_gt){
      
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " << tok.getIndex() 
	   << ':' << tok.getType() << MiX_STD::endl
	   << "(Expected \'>\' )" << MiX_STD::endl << MiX_STD::ends; 
      
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	return STATE_Exception;
      }
    }
    
    
    return STATE_Text;
  }
  
  template <class Char,class Traits,class XMLTraits>
  XMLString<Char,Traits,XMLTraits> SAX_Parser<Char,Traits,XMLTraits>::parseReference(){
    XMLToken<Char,Traits,XMLTraits> tok;
    XMLString<Char,Traits,XMLTraits> sRet;
    skipSpaceTokens();
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_text){
      //"&"μʸΤߡ
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " << tok.getIndex() << MiX_STD::endl
	   << "(Expected text)" << MiX_STD::endl << MiX_STD::ends;
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	state_=STATE_Exception;
	return XMLString<Char,Traits,XMLTraits>();
      }
    }
    
    if(0==XMLTraits::ci_compare(tok.getData().c_str(),
				XMLTraits::str_lt().c_str(),
				/*strlen("lt")+1*/3)){
      sRet+=XMLTraits::lt();
    }else if(0==XMLTraits::ci_compare(tok.getData().c_str(),
				      XMLTraits::str_gt().c_str(),
				      /*strlen("gt")+1*/3)){
      sRet+=XMLTraits::gt();
    }else if(0==XMLTraits::ci_compare(tok.getData().c_str(),
				      XMLTraits::str_amp().c_str(),
				      /*strlen("amp")+1*/4)){
      sRet+=XMLTraits::amp();
    }else if(0==XMLTraits::ci_compare(tok.getData().c_str(),
				      XMLTraits::str_quot().c_str(),
				      /*strlen("quot")+1*/5)){
      sRet+=XMLTraits::dblquote();
    }else if(0==XMLTraits::ci_compare(tok.getData().c_str(),
				      XMLTraits::str_apos().c_str(),
				      /*strlen("apos")+1*/5)){
      sRet+=XMLTraits::quote();
    }else{
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " 
	   << tok.getIndex() << MiX_STD::endl
	   << "(not supported refference)" << MiX_STD::endl << MiX_STD::ends;
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	state_=STATE_Exception;
	return XMLString<Char,Traits,XMLTraits>();
      }
    }
    tokenizer_.ejectToken(tok);
    if(tok.getType()!=Token_semicolon){
      //&hogeפΤȤɬ;
      std::ostringstream sout;
      sout << "ParsingException" << MiX_STD::endl
	   << "Unexpected token in " 
	   << tok.getIndex() << MiX_STD::endl
	   << "(expected \';\')" << MiX_STD::endl << MiX_STD::ends;
      if(handler_->onException(ParsingException(tok.getIndex(),UnexpectedToken,sout.str()))){
	state_=STATE_Exception;
	return XMLString<Char,Traits,XMLTraits>();
      }
    }
    return sRet;
  }

  template <class Char,class Traits,class XMLTraits>
  SAX_Parser<Char,Traits,XMLTraits>::State SAX_Parser<Char,Traits,XMLTraits>::parseComment(){
    
    XMLString<Char,Traits,XMLTraits> sText;
    XMLToken<Char,Traits,XMLTraits> tok;
    tokenizer_.ejectToken(tok);
    while(tok.getType()!=Token_null){
      if(tok.getType()==Token_hyphen){
	XMLToken<Char,Traits,XMLTraits> hyphen,gt;
	tokenizer_.ejectToken(hyphen);
	tokenizer_.ejectToken(gt);
	if(hyphen.getType()==Token_hyphen && gt.getType()==Token_gt){
	  handler_->onComment(sText);
	  return STATE_Text;
	}else{
	  tokenizer_.pushToken(gt);
	  tokenizer_.pushToken(hyphen);
	}
      }
      sText+=tok.getData();
      tokenizer_.ejectToken(tok);
    }
    
    return STATE_Complete;
  }
  
  
  template <class Char,class Traits,class XMLTraits>
  void SAX_Parser<Char,Traits,XMLTraits>::trimRight(XMLString<Char,Traits,XMLTraits>& str){
    //ʸ
    Char sp[] = {
      XMLTraits::crlf(),
      XMLTraits::sp(),
      XMLTraits::tab(),
      XMLTraits::null()
    };
    size_t pos = str.find_last_not_of(sp);
    str.assign(str,0,pos+1);
  }
}
