// -*- mode: c++ -*- 
#ifndef __MIX_PARSINGEXCEPTION_H_
#define __MIX_PARSINGEXCEPTION_H_

#include <exception>
#include "misc.h"

namespace MiX{
  /**
   * DOM/SAXѤParsing㳰ɽ饹
   *
   * 顼εäǥåȡ顼ξܺʸȡ顼פ
   * 
   */
  class ParsingException : public MiX_STD::exception{
    long index_;
    ErrorType type_;
    MiX_STD::string data_;
  public:
    ///󥹥ȥ饯
    ParsingException(long index,ErrorType type,const std::string& data) : index_(index),type_(type),data_(data){ };
    ///ǥȥ饯
    virtual ~ParsingException() throw(){ };
    ///顼ξܺ٤򤢤魯ʸ֤
    const char* what()const throw(){ return data_.c_str(); };
    ///顼εäʸƬΥǥå֤
    long getIndex()const{ return index_; };
    ///顼פ֤
    ErrorType getType()const{
      return type_;
    };
  };
}

#ifndef MIX_PARSINGEXCEPTION_CPP_
#include "ParsingException.cpp"
#endif

#endif
