// -*- mode: C++ -*-
#ifndef __MIX_NODELIST_H_
#define __MIX_NODELIST_H_

#include "classes.h"

#include <list>
 
namespace MiX{
  /**
   * NodeǼꥹ
   *
   * Ѥäƥ졼ʳlist\<Node\<...\>*\>
   * Ʊ
   */
  template <class Char,class Traits,class XMLTraits>
  class NodeList : public MiX_STD::list<Node<Char,Traits,XMLTraits>* >{
  public:
    typedef MiX_STD::list<Node<Char,Traits,XMLTraits>* >::iterator iterator;
    typedef MiX_STD::list<Node<Char,Traits,XMLTraits>* >::const_iterator const_iterator;
#ifdef MiX_COMPILER_SUPPORT_MEMBER_TEMPLATE

    /**
     * NodeListѤηꥤƥ졼
     *
     * ƥ졼˷Ϳ뤳Ȥǥ㥹ȤʤǥΡɤ˥Ǥޤ
     * NodeList\<...\>::Iterator\<Element\<...\> \>
     * NodeListElementǤˤ륤ƥ졼ǡ
     * (*it)Node\<...\>*ǤϤʤElement\<...\>&ؤޤ
     * ˤäƥ󥭥㥹Ȥɬפʤʤޤ
     */
    template <class NodeT>
    class Iterator{
      typedef NodeT* pointer;
      typedef NodeT& reference;

      typedef NodeList<Char,Traits,XMLTraits> container_type;
      typedef container_type::iterator basic_iterator;
      typedef Iterator<NodeT> this_type;

      basic_iterator it_;
      this_type* container_;
      
      ///󥹥ȥ饯
      Iterator(container_type* container,basic_iterator it){
	container_ = container;
	it_ = it;
      };
    public:
      /**
       * 󥹥ȥ饯
       *
       * ̵Iteratorޤ
       */
      Iterator(){
	container_ = NULL;
      };
      ///ȳ
      reference operator*(){
	return dynamic_cast<NodeT&>(**it_);
      };
      ///Ф˥ޤ
      pointer operator->(){
	return dynamic_cast<NodeT*>(*it_);
      };
      ///ƥ졼Ŀʤޤ(֥󥯥)
      this_type operator++(){
	basic_iterator itEnd=container_->end();
	++it_;
	while(it_!=itEnd){
	  if((*it_)->getType()==NodeT::type()) break;
	  ++it_;
	}
	return *this;
      };
      ///ƥ졼ᤷޤ(֥ǥ)
      this_type operator--(){
	basic_iterator itBegin=container_->begin();
	while(it_!=itBegin){
	  --it_;
	  if((*it_)->getType()==NodeT::type()) break;
	}
	return *this;
      };
      /**
       * ƥ졼Ŀʤޤ(֥󥯥)
       *
       * ֥󥯥Ȥ֥󥯥ȤˤäƼƤޤ
       * ΤǡͤѤʤ֤ѤۤΨŪǤ
       */
      this_type operator++(int dmy){
	this_type ret = *this;
	++(*this);
	return ret;
      };
      /**
       * ݥ󥿤ᤷޤ(֥ǥ)
       *
       * ֥ǥȤ֥ǥȤˤäƼƤޤ
       * ΤǡͤѤʤ֤ѤۤΨŪǤ
       */
      this_type operator--(int dmy){
	this_type ret = *this;
	--(*this);
	return ret;
      };
      //ƥ졼Ӥޤ
      bool operator==(this_type& r)const{
	return it_==r.it_;
      };
      //ƥ졼Ӥޤ
      bool operator!=(this_type& r)const{
	return !(*this==r);
      };
     
      friend class NodeList<Char,Traits,XMLTraits>;
    };
    /**
     * NodeListѤηꥤƥ졼(const)
     */
    template <class NodeT>
    class ConstIterator{
      typedef const NodeT* pointer;
      typedef const NodeT& reference;

      typedef NodeList<Char,Traits,XMLTraits> container_type;
      typedef container_type::const_iterator basic_iterator;
      typedef ConstIterator<NodeT> this_type;

      basic_iterator it_;
      this_type* container_;
      
      ///󥹥ȥ饯
      ConstIterator(container_type* container,basic_iterator it){
	container_ = container;
	it_ = it;
      };
    public:
      /**
       * 󥹥ȥ饯
       *
       * ̵Iteratorޤ
       */
      ConstIterator(){ container_ = NULL; };
      ///Ф˥ޤ
      pointer operator->(){return dynamic_cast<pointer>(*it_); };
      ///ȳ
      reference operator*(){return dynamic_cast<reference>(**it_);};
      ///ƥ졼Ŀʤޤ(֥󥯥)
      this_type operator++(){
	basic_iterator itEnd=container_->end();
	++it_;
	while(it_!=itEnd){
	  if((*it_)->getType()==NodeT::type()) break;
	  ++it_;
	}
	return *this;
      };
      ///ƥ졼ᤷޤ(֥ǥ)
      this_type operator--(){
	basic_iterator itBegin=container_->begin();
	while(it_!=itBegin){
	  --it_;
	  if((*it_)->getType()==NodeT::type()) break;
	}
	return *this;
      };
      /**
       * ƥ졼Ŀʤޤ(֥󥯥)
       *
       * ֥󥯥Ȥ֥󥯥ȤˤäƼƤޤ
       * ΤǡͤѤʤ֤ѤۤΨŪǤ
       */
      this_type operator++(int dmy){
	this_type ret = *this;
	++(*this);
	return ret;
      };
      /**
       * ݥ󥿤ᤷޤ(֥ǥ)
       *
       * ֥ǥȤ֥ǥȤˤäƼƤޤ
       * ΤǡͤѤʤ֤ѤۤΨŪǤ
       */
      this_type operator--(int dmy){
	this_type ret = *this;
	--(*this);
	return ret;
      };
      //ƥ졼Ӥޤ
      bool operator==(this_type& r)const{
	return it_==r.it_;
      };
      //ƥ졼Ӥޤ
      bool operator!=(this_type& r)const{
	return !(*this==r);
      };
     
      friend class NodeList<Char,Traits,XMLTraits>;
    };

  public:
    ///ǽǤ򼨤ꥤƥ졼ޤ
    template <class NodeT>
    Iterator<NodeT> Begin(){
      NodeList<Char,Traits,XMLTraits>::Iterator<NodeT> ret = NodeList<Char,Traits,XMLTraits>::Iterator<NodeT>(this,begin());
      if((*(ret.m_it))->getType()!=NodeT::type()) ++ret;
      return ret;
    };
    ///ǽǤ򼨤ꥤƥ졼ޤ(const)
    template <class NodeT>
    ConstIterator<NodeT> Begin()const{
      NodeList<Char,Traits,XMLTraits>::ConstIterator<NodeT> ret = NodeList<Char,Traits,XMLTraits>::ConstIterator<NodeT>(this,begin());
      if((*(ret.m_it))->getType()!=NodeT::type()) ++ret;
      return ret;
    };
    ///ǸǤΰĸ򼨤ꥤƥ졼ޤ
    template <class NodeT>
    Iterator<NodeT> End(){
      return NodeList<Char,Traits,XMLTraits>::Iterator<NodeT>(this,end());
    };
    ///ǸǤΰĸ򼨤ꥤƥ졼ޤ(const)
    template <class NodeT>
    ConstIterator<NodeT> End()const{
      return NodeList<Char,Traits,XMLTraits>::ConstIterator<NodeT>(this,end());
    };
#endif
  };
}

#ifndef MIX_NODELIST_CPP_
#include "NodeList.cpp"
#endif

#endif
