#define MIX_NODECONTAINER_CPP_

#include "NodeContainer.h"
#include "NodeList.h"
#include "Functions.h"

#include <algorithm>
#include <functional>

namespace MiX{
  template <class Char,class Traits,class XMLTraits>
  NodeContainer<Char,Traits,XMLTraits>::~NodeContainer()throw(){
    try{
      NodeList<Char,Traits,XMLTraits> lst(getChildren());
      for(nodelist_type::iterator it = lst.begin();
	  it!=lst.end() ; ++it)
	delete (*it);
    }catch(...){
      //㳰äƤޤä̵뤹롣
    }
  }
  
  template <class Char,class Traits,class XMLTraits>
  void NodeContainer<Char,Traits,XMLTraits>::addChild(Node<Char,Traits,XMLTraits>* node){
    nodelist_type::iterator it = MiX_STD::find(getChildren().begin(),getChildren().end(),node);
    if(it!=children_.end()){ 
      std::ostringstream sout;
      sout << "DOM_Exception" << MiX_STD::endl
	   << "Pointer duplication"<<MiX_STD::endl<<MiX_STD::ends;
      throw DOM_Exception<Char,Traits,XMLTraits>(this,NodeDuplication,sout.str());
    }
    children_.push_back(node);
    node->setParent(*this);
  };

  template <class Char,class Traits,class XMLTraits>
  Element<Char,Traits,XMLTraits>& NodeContainer<Char,Traits,XMLTraits>::getElement(const XMLString<Char,Traits,XMLTraits>& name,int index){
    int i = 0;
    NamedNodeFinder<Char,Traits,XMLTraits> pred(Node_Element,name);
    NodeList<Char,Traits,XMLTraits>::iterator first=getChildren().begin();
    NodeList<Char,Traits,XMLTraits>::iterator last=getChildren().end();
    while(1){
      NodeList<Char,Traits,XMLTraits>::iterator it;
      it=MiX_STD::find_if(first,last,pred);
      if(it==getChildren().end()) break;
      if(index==i) 
	return dynamic_cast<Element<Char,Traits,XMLTraits>&>(**it);
      else{
	first=++it;
      }
      i++;
    };
    std::ostringstream sout;
    sout << "DomException" << MiX_STD::endl
	 << "Element not found. (" << name << ',' << index 
	 << ')' << MiX_STD::endl << MiX_STD::ends;
    throw DOM_Exception<Char,Traits,XMLTraits>(static_cast<Node<Char,Traits,XMLTraits>*>(this),NodeNotFound,sout.str());
  }
  
  template <class Char,class Traits,class XMLTraits>
  Attribute<Char,Traits,XMLTraits>& NodeContainer<Char,Traits,XMLTraits>::getAttribute(const XMLString<Char,Traits,XMLTraits>& name){
    NamedNodeFinder<Char,Traits,XMLTraits> pred(Node_Attribute,name);
    nodelist_type::iterator it = MiX_STD::find_if(getChildren().begin(),getChildren().end(),pred);
    if(it==getChildren().end()){
      std::ostringstream sout;
      sout << "DOM_Exception" << MiX_STD::endl
	   << "Attribute not found(" << name << ")" 
	     << MiX_STD::endl << MiX_STD::ends;
      throw DOM_Exception<Char,Traits,XMLTraits>(this,NodeNotFound,sout.str());
      }
    return dynamic_cast<Attribute<Char,Traits,XMLTraits>&>(**it);
  }

  template <class Char,class Traits,class XMLTraits>
  bool NodeContainer<Char,Traits,XMLTraits>::hasAttribute(const XMLString<Char,Traits,XMLTraits>& name){
    NamedNodeFinder<Char,Traits,XMLTraits> pred(Node_Attribute,name);
    NodeList<Char,Traits,XMLTraits>::iterator it;
    it = MiX_STD::find_if(getChildren().begin(),getChildren().end(),pred);
    return it!=getChildren().end();
  }
}
