 #define MIX_NODE_CPP_

#include <algorithm>
#include "XMLString.h"
#include "NodeList.h"
#include "Node.h"
#include "DOM_Exception.h"

namespace MiX{
  template <class Char,class Traits,class XMLTraits>
  Node<Char,Traits,XMLTraits>::~Node()throw(){
    if(parent_){
      nodelist_type& l=parent_->getChildren();
      nodelist_type::iterator it = MiX_STD::find(l.begin(),l.end(),this);
      if(it != l.end()){
	parent_->getChildren().erase(it);
      }
      parent_ = 0;
    }
  };
  
  template <class Char,class Traits,class XMLTraits>
  const NodeContainer<Char,Traits,XMLTraits>& Node<Char,Traits,XMLTraits>::getParent()const{
    if(parent_ == 0){
      std::ostringstream sout;
      sout << "DOM_Exception" << MiX_STD::endl
	   << "Parent not found." << MiX_STD::endl << MiX_STD::ends;
      throw DOM_Exception<Char,Traits,XMLTraits>(this,NullException,sout.str());
    }
    return *parent_;
  };
  
  template <class Char,class Traits,class XMLTraits>
  NodeContainer<Char,Traits,XMLTraits>& Node<Char,Traits,XMLTraits>::getParent(){
    if(parent_ == 0){
      std::ostringstream sout;
      sout << "DOM_Exception" << MiX_STD::endl
	   << "Parent not found." << MiX_STD::endl << MiX_STD::ends;
      throw DOM_Exception<Char,Traits,XMLTraits>(this,NullException,sout.str());
    }
    return *parent_;
  };
}
