// -*- mode: c++ -*-

#ifndef MIX_DOCUMENT_H_
#define MIX_DOCUMENT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"

namespace MiX{
  /**
   * XMLɥΤɽ饹
   *
   * ĤλElementȡĤAttributeޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class Document : public NodeContainer<Char,Traits,XMLTraits>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef Document<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  protected:
    /**
     * 󥹥ȥ饯
     *
     * DocumentΥ󥹥ȥ饯ľܸƤ٤ޤ<br>
     * Document<...>::createƤ
     */
    Document() { };
    /**
     * ԡ󥹥ȥ饯
     *
     * DocumentϥԡǤޤ
     */
    Document(const Document<Char,Traits,XMLTraits>& src){ };
  public:
    ///ǥȥ饯
    virtual ~Document()throw() { };
    ///ΥΡɤΥפޤ
    virtual NodeType getType() const{ return Node_Document; };
    /**
     * Ū˥饹NodeTypeޤ
     *
     * Node_Document֤ޤ
     */
    static NodeType type(){ return Node_Document; } ;
    ///ͣλElement֤ޤ
    Element<Char,Traits,XMLTraits>& getRoot()const;
    /**
     * Documentʸɽޤ
     *
     * XMLʸϤƤӤޤ<br>
     * bIndentλǥȤɲäޤ
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * Attribute˥ޤ
     *
     * szNameͿ줿̾AttributeؤλȤ֤ޤ<br>
     * ĤʤäDomException<...>ꤲޤ
     */
    attribute_type& operator[](const string_type& name){
      return getAttribute(name);
    }
    /**
     * Documentޤ
     *
     * DocumentƱͣλElementޤ
     * <dl>
     *  <dt>rootname</dt><dd>ƱElement̾</dd>
     * </dl>
     */
    static this_type& create(const string_type& rootname);
    
    friend class DOM_Parser<Char,Traits,XMLTraits>;
  };
}

#ifndef MIX_DOCUMENT_CPP_
#include "Document.cpp"
#endif

#endif
