// -*- mode: c++ -*-

#ifndef MIX_DOMPARSER_H_
#define MIX_DOMPARSER_H_

#include "classes.h"
#include "DefaultXMLTraits.h"
#include "SAX_Parser.h"

namespace MiX{
  /**
   * Ϳ줿ʸϤDOMĥ꡼ۤ륯饹
   *
   * ˤSaxParserѤƤ
   */
  template <class Char,class Traits,class XMLTraits>
  class DOM_Parser : public SAX_EventHandler<Char,Traits,XMLTraits>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef DOM_Parser<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  private:
    ///ºݤ˥ѡ󥰤򤹤SaxParser
    SAX_Parser<Char,Traits,XMLTraits> parser_;
    ///߹ΥΡ
    NodeContainer<Char,Traits,XMLTraits>* current_;
  public:
    ///ǥȥ饯
    virtual ~DOM_Parser(){ };
    ///SaxParserΤΥϥɥ(ѤΤ)
    virtual void onXMLDeclaration(attrmap_type attr);
    ///SaxParserΤΥϥɥ(ѤΤ)
    virtual void onStart(string_type name,attrmap_type attr);
    ///SaxParserΤΥϥɥ(ѤΤ)
    virtual void onEnd(string_type name);
    ///SaxParserΤΥϥɥ(ѤΤ)
    virtual void onText(string_type text);
    ///SaxParserΤΥϥɥ(ѤΤ)
    virtual void onComment(string_type text);

    ///Ϳ줿ʸȤDOMĥ꡼ۤޤ
    document_type& parse(const Char* text);
    /**
     * ʸˤ(ǥ)̵뤹뤫ɤꤷޤ
     *
     * setIgnoreSpace(true)򤷤硢ǥˤä줿
     * XMLɥȤñ˽뤳ȤǤޤ
     */
    void setIgnoreSpace(bool flag){
      parser_.setIgnoreSpace(flag);
    };
  };
}

#ifndef MIX_DOMPARSER_CPP_
#include "DOM_Parser.cpp"
#endif

#endif
