// -*- mode: c++ -*- 
#ifndef MIX_DOMEXCEPTION_H_
#define MIX_DOMEXCEPTION_H_

#include <exception>
#include "misc.h"
#include "classes.h"

namespace MiX{
  /**
   * DOM˼Ԥꤲ㳰ɽ饹
   *
   * 顼򵯤ΡɤФ
   */
  template <class Char,class Traits,class XMLTraits>
  class DOM_Exception : public MiX_STD::exception{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef Element<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  private:
    const node_type* node_;
    ErrorType type_;
    MiX_STD::string data_;
  public:
    ///󥹥ȥ饯
    DOM_Exception(const node_type* node,ErrorType type,const std::string& data) : node_(node),type_(type),data_(data){ };
    ///ǥȥ饯
    virtual ~DOM_Exception() throw(){ };
    ///顼ξܺ٤򤢤魯ʸ֤
    const char* what()const throw(){ return data_.c_str(); }
    ///顼򵯤NodeؤΥݥ󥿤֤
    const node_type* getNode()const throw(){ return node_; }
    ///顼פ֤
    ErrorType getType() const throw() { return type_; };
  };
}

#ifndef MIX_DOMEXCEPTION_CPP_
#include "DOM_Exception.cpp"
#endif//MIX_DOMEXCEPTION_CPP_

#endif
